/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.locality;

import com.sun.solaris.service.locality.LocalityDomain;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.PoolsException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LocalityGroup {
    private LocalityDomain domain;
    private long id;
    private LocalityGroup parent;
    private int[] cpu_ids;
    private Set children;

    public LocalityGroup(LocalityDomain localityDomain, long l, LocalityGroup localityGroup) {
        this.domain = localityDomain;
        this.id = l;
        this.parent = localityGroup;
        this.cpu_ids = this.jl_cpus();
        long[] lArray = this.jl_children();
        this.children = new HashSet();
        for (int i = 0; i < lArray.length; ++i) {
            this.children.add(new LocalityGroup(localityDomain, lArray[i], this));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("locality group ").append(this.id).append(" with cpus [");
        String string = "";
        for (int i = 0; i < this.cpu_ids.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(this.cpu_ids[i]);
            string = " ";
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Set getChildren() {
        return this.children;
    }

    public int[] getCPUIDs() {
        return this.cpu_ids;
    }

    long getID() {
        return this.id;
    }

    public int getLatency(LocalityGroup localityGroup) {
        return this.jl_latency(this.id, localityGroup.getID());
    }

    public int countForeignGroups(List list) throws PoolsException {
        HashSet<LocalityGroup> hashSet = new HashSet<LocalityGroup>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            int n = (int)component.getLongProperty("cpu.sys_id");
            for (int i = 0; i < this.cpu_ids.length; ++i) {
                LocalityGroup localityGroup;
                if (this.cpu_ids[i] != n || (localityGroup = this.domain.getGroup(n)) == this || hashSet.contains(localityGroup)) continue;
                hashSet.add(localityGroup);
            }
        }
        return hashSet.size();
    }

    public Set contains(List list) throws PoolsException {
        HashSet<Component> hashSet = new HashSet<Component>();
        Iterator iterator = list.iterator();
        int[] nArray = this.getCPUIDs();
        block0: while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != (int)component.getLongProperty("cpu.sys_id")) continue;
                hashSet.add(component);
                continue block0;
            }
        }
        return hashSet;
    }

    private native long[] jl_children();

    private native int[] jl_cpus();

    private native int jl_latency(long var1, long var3);
}

