/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.locality;

import com.sun.solaris.service.locality.LocalityGroup;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LocalityDomain {
    public static final int LGRP_VIEW_CALLER = 0;
    public static final int LGRP_VIEW_OS = 1;
    private int view;
    private long cookie;
    private LocalityGroup root;
    private final int maxLatency;
    private static final String CPU_SYS_ID = "cpu.sys_id";

    public LocalityDomain(int n) throws Exception {
        this.view = n;
        this.cookie = this.jl_init(n);
        this.root = this.jl_root();
        this.maxLatency = this.calcMaxLatency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public LocalityGroup getRoot() {
        return this.root;
    }

    public void close() {
        if (this.cookie != 0L) {
            this.jl_fini();
            this.cookie = 0L;
            this.root = null;
        }
    }

    public String toString() {
        return this.root.toString();
    }

    public Set foreignGroups(Set set, List list) throws PoolsException {
        Iterator iterator = list.iterator();
        HashSet<LocalityGroup> hashSet = new HashSet<LocalityGroup>();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            int n = (int)component.getLongProperty(CPU_SYS_ID);
            LocalityGroup localityGroup = this.getGroup(n);
            if (localityGroup == null || set.contains(localityGroup)) continue;
            hashSet.add(localityGroup);
        }
        return hashSet;
    }

    public LocalityGroup getRepresentativeGroup(List list) throws PoolsException {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = list.iterator();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        while (iterator.hasNext()) {
            object3 = (Component)iterator.next();
            int n = (int)((Element)object3).getLongProperty(CPU_SYS_ID);
            object2 = this.getGroup(n);
            object = (Integer)hashMap.get(object2);
            if (object != null) {
                int n2 = (Integer)object + 1;
                hashMap.put(object2, new Integer(n2));
                continue;
            }
            hashMap.put(object2, new Integer(1));
        }
        object3 = hashMap.keySet().iterator();
        Object object4 = null;
        object2 = new Integer(0);
        while (object3.hasNext()) {
            object = (LocalityGroup)object3.next();
            Integer n = (Integer)hashMap.get(object);
            if (n <= (Integer)object2) continue;
            object2 = n;
            object4 = object;
        }
        return object4;
    }

    private int calcMaxLatency() {
        int n = 0;
        Set set = this.getGroups();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = set.iterator();
            LocalityGroup localityGroup = (LocalityGroup)iterator.next();
            while (iterator2.hasNext()) {
                LocalityGroup localityGroup2 = (LocalityGroup)iterator2.next();
                int n2 = localityGroup.getLatency(localityGroup2);
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public int getMaxLatency() {
        return this.maxLatency;
    }

    public Set getGroups() {
        HashSet<LocalityGroup> hashSet = new HashSet<LocalityGroup>();
        hashSet.add(this.root);
        this.getGroups(this.root, hashSet);
        return hashSet;
    }

    private void getGroups(LocalityGroup localityGroup, Set set) {
        Set set2 = localityGroup.getChildren();
        if (!set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                LocalityGroup localityGroup2 = (LocalityGroup)iterator.next();
                this.getGroups(localityGroup2, set);
            }
            set.addAll(set2);
        }
    }

    public LocalityGroup getGroup(int n) {
        LocalityGroup localityGroup = this.getGroup(this.root, n);
        return this.getGroup(this.root, n);
    }

    private LocalityGroup getGroup(LocalityGroup localityGroup, int n) {
        Set set = localityGroup.getChildren();
        if (set.isEmpty()) {
            int[] nArray = localityGroup.getCPUIDs();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return localityGroup;
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                LocalityGroup localityGroup2 = (LocalityGroup)iterator.next();
                LocalityGroup localityGroup3 = this.getGroup(localityGroup2, n);
                if (localityGroup3 == null) continue;
                return localityGroup3;
            }
        }
        return null;
    }

    private native long jl_init(int var1) throws Exception;

    private native int jl_fini();

    private native LocalityGroup jl_root();

    static {
        System.loadLibrary("jlgrp");
    }
}

