/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractObjective;
import com.sun.solaris.domain.pools.ComponentMove;
import com.sun.solaris.domain.pools.DecisionHistory;
import com.sun.solaris.domain.pools.Expression;
import com.sun.solaris.domain.pools.IllegalOFValueException;
import com.sun.solaris.domain.pools.LocalityObjective;
import com.sun.solaris.domain.pools.Monitor;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Objective;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.PooldException;
import com.sun.solaris.domain.pools.ResourceMonitor;
import com.sun.solaris.domain.pools.Solver;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.domain.pools.WorkloadDependentObjective;
import com.sun.solaris.service.locality.LocalityDomain;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.Pool;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.Value;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

class SystemSolver
implements Solver {
    public static final String DH_FILE_DEF_PATH = "/var/adm/pool/history";
    public static final String DH_FILE_PROP_NAME = "system.poold.history-file";
    private LocalityDomain ldom;
    private Map objMap = new HashMap();
    private static final Pattern p0 = Pattern.compile(";");
    private Configuration conf;
    private final Monitor monitor;
    private DecisionHistory dh;
    private String dhPath;
    private int cpuCount;
    private int examineCount;

    SystemSolver(Monitor monitor) {
        this.monitor = monitor;
    }

    public void initialize(Configuration configuration) throws PoolsException {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        String string = null;
        this.conf = configuration;
        this.cpuCount = configuration.getComponents(null).size();
        this.examineCount = 0;
        this.objMap.clear();
        try {
            string = configuration.getStringProperty("system.poold.objectives");
            if (string.length() > 0) {
                object3 = new HashSet();
                this.objMap.put(configuration, object3);
                Poold.CONF_LOG.log((Level)Severity.DEBUG, "adding configuration objective " + string);
                stringArray = p0.split(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        object2 = Expression.valueOf(stringArray[i]);
                        this.addObjective((Set)object3, "system", (Expression)object2);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Poold.utility.warn(Poold.CONF_LOG, illegalArgumentException, false);
                    }
                }
            }
        }
        catch (PoolsException poolsException) {
            // empty catch block
        }
        object3 = new Value("type", "pset");
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object3);
        object2 = configuration.getResources(linkedList).iterator();
        ((Value)object3).close();
        while (object2.hasNext()) {
            object = (Resource)object2.next();
            try {
                string = ((Element)object).getStringProperty("pset.poold.objectives");
                if (string.length() <= 0) continue;
                HashSet hashSet = new HashSet();
                this.objMap.put(object, hashSet);
                Poold.CONF_LOG.log((Level)Severity.DEBUG, "adding " + ((Element)object).getStringProperty("pset.name") + " objective \"" + string + "\"");
                stringArray = p0.split(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    Expression expression = null;
                    try {
                        expression = Expression.valueOf(stringArray[i]);
                        this.addObjective(hashSet, "pset", expression);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Poold.utility.warn(Poold.CONF_LOG, illegalArgumentException, false);
                    }
                }
            }
            catch (PoolsException poolsException) {
            }
        }
        Poold.CONF_LOG.log((Level)Severity.DEBUG, "objective map: " + this.objMap.toString());
        if (this.ldom != null) {
            this.ldom.close();
        }
        try {
            this.ldom = new LocalityDomain(1);
        }
        catch (Exception exception) {
            Poold.utility.die(Poold.OPT_LOG, exception);
        }
        try {
            object = configuration.getStringProperty(DH_FILE_PROP_NAME);
        }
        catch (PoolsException poolsException) {
            object = DH_FILE_DEF_PATH;
        }
        if (!((String)object).equals(this.dhPath)) {
            block23: {
                try {
                    this.dh = DecisionHistory.loadFromFile((String)object);
                    Poold.CONF_LOG.log((Level)Severity.DEBUG, "loaded history file " + (String)object);
                }
                catch (Exception exception) {
                    if (!(exception instanceof FileNotFoundException)) {
                        Poold.CONF_LOG.log((Level)Severity.WARNING, (String)object + ": contents unusable; ignoring");
                        Poold.CONF_LOG.log((Level)Severity.DEBUG, (String)object + ": contents unusable", exception);
                    }
                    if (this.dh != null) break block23;
                    this.dh = new DecisionHistory();
                }
            }
            try {
                this.dh.syncToFile((String)object);
            }
            catch (Exception exception) {
                Poold.utility.die(Poold.CONF_LOG, new PooldException((String)object + ": couldn't synchronize history file").initCause(exception), false);
            }
            this.dhPath = object;
        }
    }

    private boolean hasNonWorkloadDependentObjectives(Element element) {
        Set set = (Set)this.objMap.get(element);
        if (set == null) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof WorkloadDependentObjective)) continue;
            return false;
        }
        return true;
    }

    private boolean hasWorkloadDependentObjectives(Element element) {
        Set set = (Set)this.objMap.get(element);
        if (set == null) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof WorkloadDependentObjective)) continue;
            return true;
        }
        return false;
    }

    public boolean examine(Monitor monitor) throws PoolsException, StaleMonitorException {
        this.dh.expireAndMeasureImprovements(monitor);
        Iterator iterator = this.objMap.keySet().iterator();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Set set = (Set)this.objMap.get(element);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Objective objective = (Objective)iterator2.next();
                Poold.OPT_LOG.log((Level)Severity.DEBUG, "checking objective " + objective);
                if (!(objective instanceof WorkloadDependentObjective)) continue;
                if (this.isValid()) {
                    bl = ((WorkloadDependentObjective)objective).examine(this.conf, this, element) || bl;
                    continue;
                }
                bl3 = false;
            }
            if (bl2 || !this.hasNonWorkloadDependentObjectives(element)) continue;
            bl2 = true;
        }
        if (!bl3) {
            Poold.MON_LOG.log((Level)Severity.INFO, "not evaluating workload-dependent objectives until sufficient statistics are collected");
        }
        return bl || bl2 && this.examineCount++ < this.cpuCount / 2;
    }

    public boolean solve() throws Exception {
        boolean bl = false;
        Configuration configuration = new Configuration(this.conf.getLocation(), 1);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            Object object5;
            Object object6;
            List list;
            Object object7;
            HashMap<Resource, Long> hashMap = new HashMap<Resource, Long>();
            List list2 = configuration.getPools(null);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object7 = (Pool)iterator.next();
                long l = ((Element)object7).getLongProperty("pool.importance");
                list = ((Pool)object7).getResources(null);
                object6 = list.iterator();
                while (object6.hasNext()) {
                    object5 = (Resource)object6.next();
                    if (hashMap.containsKey(object5)) {
                        serializable = (Long)hashMap.get(object5);
                        if (l <= (Long)serializable) continue;
                        hashMap.put((Resource)object5, new Long(l));
                        continue;
                    }
                    hashMap.put((Resource)object5, new Long(l));
                }
            }
            object7 = new Value("type", "pset");
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(object7);
            List list3 = configuration.getResources(linkedList);
            ((Value)object7).close();
            list = this.getDonors(list3);
            object6 = this.getRecipients(list3);
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "donors: " + list);
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "receivers: " + object6);
            object5 = list.iterator();
            serializable = new ArrayList();
            while (object5.hasNext()) {
                object4 = (Resource)object5.next();
                object3 = this.getProcessors((Resource)object4);
                Poold.OPT_LOG.log((Level)Severity.DEBUG, "donor processors: " + object3);
                Iterator iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    Component component = (Component)iterator2.next();
                    object2 = object6.iterator();
                    while (object2.hasNext()) {
                        object = (Resource)object2.next();
                        if (object == object4) continue;
                        serializable.add(new ComponentMove((Resource)object4, (Resource)object, component));
                    }
                }
            }
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "potential moves: " + serializable);
            object4 = new HashSet();
            object3 = serializable.iterator();
            while (object3.hasNext()) {
                double d = 0.0;
                object2 = (Move)object3.next();
                object = this.objMap.keySet().iterator();
                while (object.hasNext()) {
                    Element element = (Element)object.next();
                    Set set = (Set)this.objMap.get(element);
                    Iterator iterator3 = set.iterator();
                    while (iterator3.hasNext()) {
                        Objective objective = (Objective)iterator3.next();
                        if (objective instanceof LocalityObjective) {
                            ((LocalityObjective)objective).prepare(this.ldom, (Resource)element);
                        }
                        if (objective instanceof WorkloadDependentObjective && !this.isValid()) continue;
                        double d2 = objective.calculate(configuration, (Move)object2, element);
                        if (d2 < -1.0 || d2 > 1.0) {
                            throw new IllegalOFValueException("x: " + d2 + " is invalid, legal " + "range is -1 <= x <= " + "1");
                        }
                        if (hashMap.containsKey(element)) {
                            d2 *= (double)((Long)hashMap.get(element)).longValue();
                        }
                        d += d2 * (double)objective.getExpression().getImportance();
                    }
                }
                Poold.OPT_LOG.log((Level)Severity.DEBUG, "scored move (" + object2 + ") " + d);
                ((HashSet)object4).add(new ScoreMove((Move)object2, d));
            }
            if (((HashSet)object4).size() != 0) {
                Object[] objectArray = ((HashSet)object4).toArray();
                Arrays.sort(objectArray, Collections.reverseOrder());
                bl = this.processMoves(configuration, objectArray, false);
                if (!bl) {
                    bl = this.processMoves(configuration, objectArray, true);
                }
            } else {
                Poold.OPT_LOG.log((Level)Severity.INFO, "no moves found");
            }
            configuration.close();
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "synchronizing decision history");
            this.dh.syncToFile(this.dhPath);
        }
        catch (Exception exception) {
            configuration.close();
            throw exception;
        }
        return bl;
    }

    private boolean processMoves(Configuration configuration, Object[] objectArray, boolean bl) throws PoolsException, StaleMonitorException {
        boolean bl2 = false;
        for (int i = 0; i < objectArray.length; ++i) {
            ScoreMove scoreMove = (ScoreMove)objectArray[i];
            if (scoreMove.getScore() <= 0.0) {
                if (!bl) break;
                Poold.OPT_LOG.log((Level)Severity.INFO, scoreMove + " not applied as " + "benefit not significant");
                break;
            }
            bl2 = this.applyMove(configuration, scoreMove, bl);
            if (bl2) break;
        }
        return bl2;
    }

    private boolean applyMove(Configuration configuration, ScoreMove scoreMove, boolean bl) throws PoolsException, StaleMonitorException {
        boolean bl2 = false;
        boolean bl3 = false;
        double d = 0.0;
        Poold.OPT_LOG.log((Level)Severity.DEBUG, "selected " + scoreMove);
        if (this.hasWorkloadDependentObjectives(scoreMove.getMove().getTo()) || this.hasWorkloadDependentObjectives(configuration)) {
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "Attempting to retrieve utilization for:" + scoreMove.getMove().getTo());
            d = this.monitor.getUtilization(scoreMove.getMove().getTo());
            bl3 = true;
        }
        if (bl || !bl3 || !this.dh.veto(scoreMove.getMove(), d)) {
            Poold.OPT_LOG.log((Level)Severity.INFO, "applying move " + scoreMove.getMove());
            scoreMove.getMove().apply();
            ResourceMonitor resourceMonitor = this.getMonitor().get(scoreMove.getMove().getFrom());
            resourceMonitor.resetData("utilization");
            resourceMonitor = this.getMonitor().get(scoreMove.getMove().getTo());
            resourceMonitor.resetData("utilization");
            try {
                Poold.OPT_LOG.log((Level)Severity.DEBUG, "committing configuration");
                configuration.commit(0);
                try {
                    if (scoreMove.getMove() instanceof ComponentMove) {
                        if (bl3) {
                            this.dh.recordProcessorMove((ComponentMove)scoreMove.getMove(), d, this.monitor.getSampleCount());
                        } else {
                            Poold.OPT_LOG.log((Level)Severity.DEBUG, "decision not recorded due to lack of workload-dependent objectives");
                        }
                    }
                }
                catch (Exception exception) {
                    Poold.OPT_LOG.log((Level)Severity.INFO, "couldn't update decision history (" + exception.toString() + ")");
                }
                bl2 = true;
            }
            catch (PoolsException poolsException) {
                configuration.rollback();
                Poold.OPT_LOG.log((Level)Severity.INFO, "move failed, possibly due to a bound process in a 1-processor set");
            }
        } else if (!bl && bl3) {
            Poold.OPT_LOG.log((Level)Severity.INFO, scoreMove.getMove() + " not applied due to " + "poor past results");
        }
        return bl2;
    }

    private void addObjective(Set set, String string, Expression expression) throws IllegalArgumentException {
        Objective objective = AbstractObjective.getInstance(string, expression);
        Poold.CONF_LOG.log((Level)Severity.DEBUG, "parsed objective " + objective);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Objective objective2 = (Objective)iterator.next();
            if (!objective.getExpression().contradicts(objective2.getExpression())) continue;
            throw new IllegalArgumentException("contradictory objectives:" + objective2 + ", " + objective);
        }
        if (!set.add(objective)) {
            throw new IllegalArgumentException("duplicate objective:" + objective);
        }
    }

    private List getRecipients(List list) throws PoolsException {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (int i = 0; i < list.size(); ++i) {
            long l;
            String string;
            Resource resource = (Resource)list.get(i);
            long l2 = resource.getLongProperty((string = resource.getStringProperty("type")) + ".size");
            if (l2 >= (l = resource.getLongProperty(string + ".max"))) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    private List getDonors(List list) throws PoolsException {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<Value> arrayList2 = new ArrayList<Value>();
            Resource resource = (Resource)list.get(i);
            String string = resource.getStringProperty("type");
            long l = resource.getLongProperty(string + ".size");
            Value value = new Value("cpu.pinned", true);
            arrayList2.add(value);
            List list2 = resource.getComponents(arrayList2);
            value.close();
            long l2 = resource.getLongProperty(string + ".min");
            if ((long)list2.size() > l2) {
                l -= (long)list2.size() - l2;
            }
            if (l <= l2) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    private List getProcessors(Resource resource) throws PoolsException {
        Iterator iterator = resource.getComponents(null).iterator();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            try {
                if (component.getBoolProperty("cpu.pinned")) continue;
                arrayList.add(component);
            }
            catch (PoolsException poolsException) {
                arrayList.add(component);
            }
        }
        return arrayList;
    }

    public boolean isValid() {
        return this.monitor.isValid();
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public Set getObjectives(Element element) {
        return (Set)this.objMap.get(element);
    }

    static class ScoreMove
    implements Comparable {
        private final Move m;
        private final double score;
        private static final DecimalFormat scoreFormat = new DecimalFormat("0.00");

        public ScoreMove(Move move, double d) {
            this.m = move;
            this.score = d;
        }

        public int compareTo(Object object) {
            ScoreMove scoreMove = (ScoreMove)object;
            return this.score < scoreMove.getScore() ? -1 : (this.score > scoreMove.getScore() ? 1 : 0);
        }

        public String toString() {
            return "move (" + this.m + ") score " + scoreFormat.format(this.score);
        }

        double getScore() {
            return this.score;
        }

        Move getMove() {
            return this.m;
        }
    }
}

