/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AggregateStatistic;
import com.sun.solaris.domain.pools.KVOpExpression;
import com.sun.solaris.domain.pools.StatisticEvent;
import com.sun.solaris.domain.pools.StatisticListener;
import com.sun.solaris.domain.pools.StatisticOperations;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class StatisticList
extends LinkedList {
    private final String name;
    private final int maxSize;
    private List listeners;
    private StatisticOperations statisticOperations;

    public StatisticList() {
        this("default", 10);
    }

    public StatisticList(String string, int n) {
        this(string, n, false);
    }

    public StatisticList(String string, int n, boolean bl) throws IllegalArgumentException {
        this.name = string;
        if (n < 1) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        this.maxSize = n;
        this.listeners = new LinkedList();
        if (bl) {
            this.statisticOperations = new StatisticOperations(this);
            this.addStatisticListener(this.statisticOperations);
        }
    }

    public String getName() {
        return this.name;
    }

    public AggregateStatistic getSnapshot() throws NoSuchElementException {
        return this.getSnapshotForInterval(this.iterator(), null, null);
    }

    private AggregateStatistic getSnapshot(Iterator iterator) throws NoSuchElementException {
        return this.getSnapshotForInterval(iterator, null, null);
    }

    public AggregateStatistic getSnapshotForInterval(Date date, Date date2) throws NoSuchElementException {
        return this.getSnapshotForInterval(this.iterator(), date, date2);
    }

    private AggregateStatistic getSnapshotForInterval(Iterator iterator, Date date, Date date2) {
        AggregateStatistic aggregateStatistic = (AggregateStatistic)this.getFirst();
        return aggregateStatistic.getSnapshotForInterval(iterator, date, date2);
    }

    public boolean add(Object object) {
        boolean bl;
        if (this.size() == this.maxSize) {
            this.removeFirst();
        }
        if (bl = super.add(object)) {
            this.notifyStatisticAdd((AggregateStatistic)object);
        }
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (bl) {
            this.notifyStatisticRemove((AggregateStatistic)object);
        }
        return bl;
    }

    public Object removeFirst() {
        Object e = this.getFirst();
        this.remove(e);
        return e;
    }

    public void addStatisticListener(StatisticListener statisticListener) {
        this.listeners.add(statisticListener);
    }

    public void removeStatisticListener(StatisticListener statisticListener) {
        this.listeners.remove(statisticListener);
    }

    private void notifyStatisticAdd(AggregateStatistic aggregateStatistic) {
        StatisticEvent statisticEvent = new StatisticEvent(this, 1, aggregateStatistic);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            StatisticListener statisticListener = (StatisticListener)iterator.next();
            statisticListener.onStatisticAdd(statisticEvent);
        }
    }

    private void notifyStatisticRemove(AggregateStatistic aggregateStatistic) {
        StatisticEvent statisticEvent = new StatisticEvent(this, 2, aggregateStatistic);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            StatisticListener statisticListener = (StatisticListener)iterator.next();
            statisticListener.onStatisticRemove(statisticEvent);
        }
    }

    boolean isValid() {
        return this.statisticOperations.isValid();
    }

    int getZone(KVOpExpression kVOpExpression, double d) {
        return this.statisticOperations.getZone(kVOpExpression, d);
    }

    int getZoneMean(double d) {
        return this.statisticOperations.getZoneMean(d);
    }

    double getGap(KVOpExpression kVOpExpression, double d) {
        return this.statisticOperations.getGap(kVOpExpression, d);
    }

    public void clear() {
        if (this.statisticOperations != null) {
            this.removeStatisticListener(this.statisticOperations);
            this.statisticOperations = new StatisticOperations(this);
            this.addStatisticListener(this.statisticOperations);
        }
        super.clear();
    }

    public String toZoneString(KVOpExpression kVOpExpression, double d) {
        return this.statisticOperations.toZoneString(kVOpExpression, d);
    }
}

