/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AggregateStatistic;
import com.sun.solaris.domain.pools.DoubleStatistic;
import com.sun.solaris.domain.pools.StatisticList;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.UnsignedInt64;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ResourceMonitor
extends HashMap {
    private Resource target;
    private final int maxSize;
    private LinkedList compList;

    public ResourceMonitor() {
        this(null, 50);
    }

    public ResourceMonitor(Resource resource, int n) {
        this.target = resource;
        this.maxSize = n;
        this.compList = new LinkedList();
    }

    public void initialize() throws PoolsException {
        this.compList.clear();
        List list = this.target.getComponents(null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            String string = component.getStringProperty("cpu.status");
            if (string.compareTo("off-line") == 0 || string.compareTo("powered-off") == 0) continue;
            this.compList.add(component);
        }
    }

    public List getComponents() {
        return (List)this.compList.clone();
    }

    public int getMaxSampleSize() {
        return this.maxSize;
    }

    public Resource getMonitored() {
        return this.target;
    }

    public void setResource(Resource resource) {
        if (this.target == null) {
            throw new IllegalArgumentException("Once the target of a ResourceMonitor is set, it cannot be changed.");
        }
        this.target = resource;
    }

    public String getName() throws PoolsException {
        String string = this.target.getStringProperty("type");
        return this.target.getStringProperty(string + ".name");
    }

    public void updateDerived() {
        StatisticList statisticList = (StatisticList)this.get("utilization");
        AggregateStatistic aggregateStatistic = this.calcDerivedStatistic("utilization");
        if (aggregateStatistic != null) {
            statisticList.add(aggregateStatistic);
        }
    }

    public AggregateStatistic getDerivedStatistic(String string) {
        return (AggregateStatistic)((StatisticList)this.get(string)).getLast();
    }

    private AggregateStatistic calcDerivedStatistic(String string) {
        if (string.compareTo("utilization") != 0) {
            throw new IllegalArgumentException("No such derived statistic: " + string);
        }
        StatisticList statisticList = (StatisticList)this.get("idle");
        switch (statisticList.size()) {
            case 0: 
            case 1: {
                return null;
            }
        }
        BigInteger bigInteger = new BigInteger("0");
        double d = 0.0;
        double d2 = 0.0;
        LinkedList linkedList = new LinkedList(this.keySet());
        linkedList.remove("utilization");
        for (int i = 0; i < linkedList.size(); ++i) {
            StatisticList statisticList2 = (StatisticList)this.get(linkedList.get(i));
            AggregateStatistic aggregateStatistic = (AggregateStatistic)statisticList2.getLast();
            AggregateStatistic aggregateStatistic2 = (AggregateStatistic)statisticList2.get(statisticList2.size() - 2);
            if (statisticList2.getName().compareTo("idle") == 0) {
                d2 = ((UnsignedInt64)aggregateStatistic.subtract(aggregateStatistic2).getValue()).doubleValue();
            }
            bigInteger = bigInteger.add((UnsignedInt64)aggregateStatistic.subtract(aggregateStatistic2).getValue());
        }
        d = 100.0 * ((bigInteger.doubleValue() - d2) / bigInteger.doubleValue());
        return new DoubleStatistic(new Double(d), ((AggregateStatistic)statisticList.get(statisticList.size() - 2)).getStart(), ((AggregateStatistic)statisticList.getLast()).getEnd());
    }

    void resetData(String string) {
        StatisticList statisticList = (StatisticList)this.get(string);
        statisticList.clear();
    }
}

