/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;

class QuantityMove
extends Move {
    private long qty;

    QuantityMove(Resource resource, Resource resource2, long l) {
        super(resource, resource2);
        if (l < 0L) {
            throw new IllegalArgumentException("The resource quantity supplied (" + l + ") is illegal.");
        }
        this.qty = l;
    }

    void apply() throws PoolsException {
        this.getTo().transfer(this.getFrom(), this.qty);
    }

    long getQty() {
        return this.qty;
    }

    public String toString() {
        return "from " + this.getFrom().toString() + " to " + this.getTo().toString() + " quantity " + this.qty;
    }
}

