/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.Expression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class KVExpression
extends Expression {
    private String val;
    private static final Pattern pattern = Pattern.compile("\\s*((\\d+)\\s*:)?\\s*(\\w+)\\s+(tight|loose|none)\\s*");
    private static final String[] keys = new String[]{"locality"};

    private KVExpression(long l, String string, String string2) {
        super(l, string);
        this.val = string2;
    }

    static Expression valueOf(String string) throws IllegalArgumentException {
        KVExpression kVExpression = null;
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            long l = 1L;
            if (matcher.group(2) != null) {
                l = KVExpression.validateImportance(matcher.group(2));
            }
            KVExpression.validateKeyword(keys, matcher.group(3));
            kVExpression = new KVExpression(l, matcher.group(3), matcher.group(4));
        }
        return kVExpression;
    }

    String getValue() {
        return this.val;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.getImportance());
        stringBuffer.append(", ");
        stringBuffer.append(this.getName());
        stringBuffer.append(", ");
        stringBuffer.append(this.val);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KVExpression)) {
            return false;
        }
        KVExpression kVExpression = (KVExpression)object;
        return this.getName().compareTo(kVExpression.getName()) == 0 && this.val.compareTo(kVExpression.getValue()) == 0;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.val.hashCode();
    }

    public boolean contradicts(Expression expression) {
        if (!(expression instanceof KVExpression)) {
            return false;
        }
        KVExpression kVExpression = (KVExpression)expression;
        if (this.getName().compareTo(kVExpression.getName()) != 0) {
            return false;
        }
        return this.val.compareTo(kVExpression.getValue()) != 0;
    }
}

