/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.ProgramInfo;

public class Program
implements Serializable {
    static final long serialVersionUID = 364989786308628466L;
    private int id = -1;
    LocalConsumer.Identifier consumerID;
    String contents;
    private ProgramInfo info;

    private Program() {
    }

    void validate() {
        if (this.id < 0) {
            throw new IllegalArgumentException("id is negative");
        }
        if (this.consumerID == null) {
            throw new NullPointerException("consumer ID is null");
        }
    }

    public String getContents() {
        return this.contents;
    }

    public ProgramInfo getInfo() {
        return this.info;
    }

    public void setInfo(ProgramInfo programInfo) {
        this.info = programInfo;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    static String getProgramString(java.io.File programFile) throws IOException {
        if (programFile == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(programFile));
        int i = ((InputStream)in).read();
        while (i >= 0) {
            buf.append((char)i);
            i = ((InputStream)in).read();
        }
        String s = buf.toString();
        return s;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Program.class.getName());
        buf.append("[contents = ");
        buf.append(this.contents);
        buf.append(", info = ");
        buf.append(this.info);
        buf.append(']');
        return buf.toString();
    }

    public static final class File
    extends Program {
        java.io.File file;

        private File() {
        }

        void validate() {
            super.validate();
            if (this.file == null) {
                throw new NullPointerException("file is null");
            }
        }

        public java.io.File getFile() {
            return this.file;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(File.class.getName());
            buf.append("[super = ");
            buf.append(super.toString());
            buf.append(", file = ");
            buf.append(this.file);
            buf.append(']');
            return buf.toString();
        }
    }
}

