/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.EventObject;
import org.opensolaris.os.dtrace.ProcessState;

public class ProcessEvent
extends EventObject {
    static final long serialVersionUID = -3779443761929558702L;
    private ProcessState processState;

    public ProcessEvent(Object source, ProcessState p) {
        super(source);
        this.processState = p;
        this.validate();
    }

    private void validate() {
        if (this.processState == null) {
            throw new NullPointerException("process state is null");
        }
    }

    public ProcessState getProcessState() {
        return this.processState;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(ProcessEvent.class.getName());
        buf.append("[source = ");
        buf.append(this.getSource());
        buf.append(", processState = ");
        buf.append(this.processState);
        buf.append(']');
        return buf.toString();
    }
}

