/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.ProbeDescription;
import org.opensolaris.os.dtrace.ProbeInfo;

public final class Probe
implements Serializable {
    static final long serialVersionUID = 8917481979541675727L;
    private final ProbeDescription description;
    private final ProbeInfo info;

    public Probe(ProbeDescription probeDescription, ProbeInfo probeInfo) {
        this.description = probeDescription;
        this.info = probeInfo;
        this.validate();
    }

    private void validate() {
        if (this.description == null) {
            throw new NullPointerException("description is null");
        }
    }

    public ProbeDescription getDescription() {
        return this.description;
    }

    public ProbeInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (o instanceof Probe) {
            Probe p = (Probe)o;
            return this.description.equals(p.description);
        }
        return false;
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Probe.class.getName());
        buf.append("[description = ");
        buf.append(this.description);
        buf.append(", info = ");
        buf.append(this.info);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Probe.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"description", "info"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

