/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensolaris.os.dtrace.Aggregate;
import org.opensolaris.os.dtrace.Aggregation;
import org.opensolaris.os.dtrace.AggregationRecord;
import org.opensolaris.os.dtrace.Record;
import org.opensolaris.os.dtrace.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrintaRecord
implements Record,
Serializable {
    static final long serialVersionUID = -4174277639915895694L;
    private final long snaptime;
    private List<Aggregation> aggregations;
    private Map<Tuple, String> formattedStrings;
    private List<Tuple> tuples;
    private transient StringBuffer outputBuffer;
    private transient String output;
    private transient boolean formatted;

    PrintaRecord(long snaptimeNanos, boolean isFormatString) {
        this.snaptime = snaptimeNanos;
        this.aggregations = new ArrayList<Aggregation>();
        this.formattedStrings = new HashMap<Tuple, String>();
        this.tuples = new ArrayList<Tuple>();
        this.outputBuffer = new StringBuffer();
        this.formatted = isFormatString;
        this.validate();
    }

    public PrintaRecord(long snaptimeNanos, Collection<Aggregation> aggs, Map<Tuple, String> formattedOutput, List<Tuple> orderedTuples, String formattedOutputString) {
        this.snaptime = snaptimeNanos;
        if (aggs != null) {
            this.aggregations = new ArrayList<Aggregation>(aggs.size());
            this.aggregations.addAll(aggs);
        }
        if (formattedOutput != null) {
            this.formattedStrings = new HashMap<Tuple, String>(formattedOutput);
        }
        if (orderedTuples != null) {
            this.tuples = new ArrayList<Tuple>(orderedTuples.size());
            this.tuples.addAll(orderedTuples);
        }
        this.output = formattedOutputString;
        this.validate();
    }

    private void validate() {
        if (this.snaptime < 0L) {
            throw new IllegalArgumentException("snaptime is negative");
        }
        if (this.aggregations == null) {
            throw new NullPointerException("aggregations list is null");
        }
        int len = this.aggregations.size();
        for (int i = 0; i < len; ++i) {
            Aggregation a = this.aggregations.get(i);
            if (a != null) continue;
            throw new NullPointerException("null aggregation at index " + i);
        }
        if (this.tuples == null) {
            throw new NullPointerException("ordered tuple list is null");
        }
        if (this.output == null && this.outputBuffer == null) {
            throw new NullPointerException("formatted output is null");
        }
    }

    public long getSnaptime() {
        return this.snaptime;
    }

    private Aggregation getAggregationImpl(String name) {
        if (name == null) {
            return null;
        }
        for (Aggregation a : this.aggregations) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Aggregation getAggregation(String name) {
        name = Aggregate.filterUnnamedAggregationName(name);
        return this.getAggregationImpl(name);
    }

    public List<Aggregation> getAggregations() {
        return new ArrayList<Aggregation>(this.aggregations);
    }

    public String getFormattedString(Tuple key) {
        if (this.formattedStrings == null) {
            return null;
        }
        return this.formattedStrings.get(key);
    }

    public Map<Tuple, String> getFormattedStrings() {
        if (this.formattedStrings == null) {
            return new HashMap<Tuple, String>();
        }
        return new HashMap<Tuple, String>(this.formattedStrings);
    }

    public List<Tuple> getTuples() {
        return new ArrayList<Tuple>(this.tuples);
    }

    public String getOutput() {
        if (this.output == null) {
            this.output = this.outputBuffer.toString();
            this.outputBuffer = null;
            if (this.output.length() == 0 && !this.formatted) {
                this.output = "\n";
            }
        }
        return this.output;
    }

    void addRecord(String aggregationName, long aggid, AggregationRecord record) {
        block4: {
            if (this.formattedStrings == null) {
                return;
            }
            Aggregation aggregation = this.getAggregationImpl(aggregationName = Aggregate.filterUnnamedAggregationName(aggregationName));
            if (aggregation == null) {
                aggregation = new Aggregation(aggregationName, aggid);
                this.aggregations.add(aggregation);
            }
            try {
                aggregation.addRecord(record);
            }
            catch (IllegalArgumentException e) {
                Map<Tuple, AggregationRecord> map = aggregation.asMap();
                AggregationRecord r = map.get(record.getTuple());
                if (r.equals(record)) break block4;
                throw e;
            }
        }
    }

    void invalidate() {
        this.formattedStrings = null;
        this.aggregations.clear();
        this.tuples.clear();
    }

    void addFormattedString(Tuple tuple, String formattedString) {
        if (tuple != null && this.formattedStrings != null) {
            if (this.formattedStrings.containsKey(tuple)) {
                throw new IllegalArgumentException("A formatted string for tuple " + tuple + " already exists.");
            }
            this.formattedStrings.put(tuple, formattedString);
            this.tuples.add(tuple);
        }
        this.outputBuffer.append(formattedString);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.output == null) {
            s.writeObject(this.outputBuffer.toString());
        } else {
            s.writeObject(this.output);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ArrayList<Aggregation> copy;
        s.defaultReadObject();
        this.output = (String)s.readObject();
        if (this.aggregations != null) {
            copy = new ArrayList<Aggregation>(this.aggregations.size());
            copy.addAll(this.aggregations);
            this.aggregations = copy;
        }
        if (this.formattedStrings != null) {
            this.formattedStrings = new HashMap<Tuple, String>(this.formattedStrings);
        }
        if (this.tuples != null) {
            copy = new ArrayList(this.tuples.size());
            copy.addAll(this.tuples);
            this.tuples = copy;
        }
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(PrintaRecord.class.getName());
        buf.append("[snaptime = ");
        buf.append(this.snaptime);
        buf.append(", aggregations = ");
        buf.append(this.aggregations);
        buf.append(", formattedStrings = ");
        buf.append(this.formattedStrings);
        buf.append(", tuples = ");
        buf.append(this.tuples);
        buf.append(", output = ");
        buf.append(this.getOutput());
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(PrintaRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"snaptime", "aggregations", "formattedStrings", "tuples", "output"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

