/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.opensolaris.os.dtrace.Aggregate;
import org.opensolaris.os.dtrace.AggregateSpec;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.ConsumerEvent;
import org.opensolaris.os.dtrace.ConsumerException;
import org.opensolaris.os.dtrace.ConsumerListener;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.DataEvent;
import org.opensolaris.os.dtrace.Drop;
import org.opensolaris.os.dtrace.DropEvent;
import org.opensolaris.os.dtrace.Error;
import org.opensolaris.os.dtrace.ErrorEvent;
import org.opensolaris.os.dtrace.ExceptionHandler;
import org.opensolaris.os.dtrace.Option;
import org.opensolaris.os.dtrace.Probe;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.ProbeDescription;
import org.opensolaris.os.dtrace.ProcessEvent;
import org.opensolaris.os.dtrace.ProcessState;
import org.opensolaris.os.dtrace.Program;
import org.opensolaris.os.dtrace.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConsumer
implements Consumer {
    static Logger logger = Logger.getLogger(LocalConsumer.class.getName());
    private static final int DTRACE_JNI_VERSION = 2;
    private static final Option[] DEFAULT_OPTIONS = new Option[]{new Option("bufsize", Option.kb(256)), new Option("aggsize", Option.kb(256))};
    private static boolean debug;
    private static int maxConsumers;
    protected EventListenerList listenerList;
    protected ExceptionHandler exceptionHandler;
    private int _handle = -1;
    private final Identifier id;
    private State state = State.INIT;
    private boolean stopCalled;
    private boolean abortCalled;
    private Object consumerLock;
    private Object stopLock;
    private boolean workEnded;
    private static int sequence;

    private static native void _loadJniTable();

    private static native void _checkVersion(int var0);

    private native void _open(Consumer.OpenFlag[] var1) throws DTraceException;

    private native Program _compileString(String var1, String[] var2) throws DTraceException;

    private native Program.File _compileFile(String var1, String[] var2) throws DTraceException;

    private native void _exec(Program var1) throws DTraceException;

    private native void _getProgramInfo(Program var1) throws DTraceException;

    private native void _setOption(String var1, String var2) throws DTraceException;

    private native long _getOption(String var1) throws DTraceException;

    private native boolean _isEnabled();

    private native void _checkProgramEnabling();

    private native void _go() throws DTraceException;

    private native void _stop() throws DTraceException;

    private native void _consume() throws DTraceException;

    private native void _interrupt();

    private native void _close();

    private native Aggregate _getAggregate(AggregateSpec var1) throws DTraceException;

    private native int _createProcess(String var1) throws DTraceException;

    private native void _grabProcess(int var1) throws DTraceException;

    private native void _listProbes(List<ProbeDescription> var1, ProbeDescription var2);

    private native void _listProbeDetail(List<Probe> var1, ProbeDescription var2);

    private native void _listCompiledProbes(List<ProbeDescription> var1, Program var2);

    private native void _listCompiledProbeDetail(List<Probe> var1, Program var2);

    private static native String _getVersion();

    private static native int _openCount();

    private native void _destroy();

    static native long _quantizeBucket(int var0);

    private native String _lookupKernelFunction(Number var1);

    private native String _lookupUserFunction(int var1, Number var2);

    private static native String _getExecutableName();

    private static native void _setMaximumConsumers(int var0);

    private static native void _setDebug(boolean var0);

    private static void configureLogging() {
        logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        logger.addHandler(handler);
        logger.setLevel(Level.OFF);
    }

    private static Integer getIntegerProperty(String name) {
        Integer value = null;
        String property = System.getProperty(name);
        if (property != null && property.length() != 0) {
            try {
                value = Integer.parseInt(property);
                System.out.println(name + "=" + value);
            }
            catch (NumberFormatException e) {
                System.err.println("Warning: property ignored: " + name + "=" + property);
            }
        }
        return value;
    }

    private static void getConfigurationOptions() {
        Integer property = LocalConsumer.getIntegerProperty("JAVA_DTRACE_API_DEBUG");
        if (property != null) {
            boolean bl = debug = property != 0;
        }
        if ((property = LocalConsumer.getIntegerProperty("JAVA_DTRACE_MAX_CONSUMERS")) != null) {
            maxConsumers = property;
        }
    }

    public LocalConsumer() {
        this.id = new Identifier(this);
        this.consumerLock = new Object();
        this.stopLock = new Object();
        this.listenerList = new EventListenerList();
    }

    private int getHandle() {
        return this._handle;
    }

    private void setHandle(int n) {
        this._handle = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(Consumer.OpenFlag ... flags) throws DTraceException {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("cannot reopen a closed consumer");
        }
        if (this.state != State.INIT) {
            throw new IllegalStateException("consumer already open");
        }
        for (Consumer.OpenFlag flag : flags) {
            if (flag != null) continue;
            throw new NullPointerException("open flag is null");
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._open(flags);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.state = State.OPEN;
            this.setOptions(DEFAULT_OPTIONS);
            if (this.abortCalled) {
                this._interrupt();
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("consumer table count: " + LocalConsumer._openCount());
            }
            return;
        }
    }

    private synchronized void checkCompile() {
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: 
            case COMPILED: {
                break;
            }
            case GO: 
            case STARTED: {
                throw new IllegalStateException("go() already called");
            }
            case STOPPED: {
                throw new IllegalStateException("consumer stopped");
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Program compile(String program, String ... macroArgs) throws DTraceException {
        Class<LocalConsumer> clazz;
        if (program == null) {
            throw new NullPointerException("program string is null");
        }
        this.checkCompile();
        Program p = null;
        String[] argv = null;
        if (macroArgs == null) {
            clazz = LocalConsumer.class;
            // MONITORENTER : org.opensolaris.os.dtrace.LocalConsumer.class
            argv = new String[]{LocalConsumer._getExecutableName()};
            // MONITOREXIT : clazz
        } else {
            for (String macroArg : macroArgs) {
                if (macroArg != null) continue;
                throw new NullPointerException("macro argument is null");
            }
            argv = new String[macroArgs.length + 1];
            clazz = LocalConsumer.class;
            // MONITORENTER : org.opensolaris.os.dtrace.LocalConsumer.class
            argv[0] = LocalConsumer._getExecutableName();
            // MONITOREXIT : clazz
            System.arraycopy(macroArgs, 0, argv, 1, macroArgs.length);
        }
        clazz = LocalConsumer.class;
        // MONITORENTER : org.opensolaris.os.dtrace.LocalConsumer.class
        p = this._compileString(program, argv);
        // MONITOREXIT : clazz
        p.consumerID = this.id;
        p.contents = program;
        p.validate();
        this.state = State.COMPILED;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Program compile(File program, String ... macroArgs) throws DTraceException, IOException, SecurityException {
        if (program == null) {
            throw new NullPointerException("program file is null");
        }
        if (!program.canRead()) {
            throw new FileNotFoundException("failed to open " + program.getName());
        }
        this.checkCompile();
        Program.File p = null;
        String[] argv = null;
        if (macroArgs != null) {
            for (String macroArg : macroArgs) {
                if (macroArg != null) continue;
                throw new NullPointerException("macro argument is null");
            }
            argv = new String[macroArgs.length + 1];
            argv[0] = program.getPath();
            System.arraycopy(macroArgs, 0, argv, 1, macroArgs.length);
        } else {
            macroArgs = new String[]{program.getPath()};
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            p = this._compileFile(program.getPath(), argv);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            p.consumerID = this.id;
            p.contents = Program.getProgramString(program);
            p.file = program;
            p.validate();
            this.state = State.COMPILED;
            return p;
        }
    }

    private synchronized void checkProgram(Program program) {
        if (program == null) {
            throw new NullPointerException("program is null");
        }
        if (!this.id.equals(program.consumerID)) {
            throw new IllegalArgumentException("program not compiled by this consumer");
        }
    }

    @Override
    public void enable() throws DTraceException {
        this.enable(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enable(Program program) throws DTraceException {
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: {
                throw new IllegalStateException("no compiled program");
            }
            case COMPILED: {
                break;
            }
            case GO: 
            case STARTED: {
                throw new IllegalStateException("go() already called");
            }
            case STOPPED: {
                throw new IllegalStateException("consumer stopped");
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
        }
        if (program != null) {
            this.checkProgram(program);
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._exec(program);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getProgramInfo(Program program) throws DTraceException {
        this.checkProgram(program);
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("consumer closed");
        }
        assert (this.state != State.INIT && this.state != State.OPEN);
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._getProgramInfo(program);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void setOptions(Option[] options) throws DTraceException {
        for (Option o : options) {
            this.setOption(o.getName(), o.getValue());
        }
    }

    @Override
    public void setOption(String option) throws DTraceException {
        this.setOption(option, "set");
    }

    @Override
    public void unsetOption(String option) throws DTraceException {
        this.setOption(option, "unset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setOption(String option, String value) throws DTraceException {
        if (option == null) {
            throw new NullPointerException("option is null");
        }
        if (value == null) {
            throw new NullPointerException("option value is null");
        }
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: 
            case COMPILED: 
            case GO: 
            case STARTED: 
            case STOPPED: {
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._setOption(option, value);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getOption(String option) throws DTraceException {
        if (option == null) {
            throw new NullPointerException("option is null");
        }
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: 
            case COMPILED: 
            case GO: 
            case STARTED: 
            case STOPPED: {
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            long value = this._getOption(option);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return value;
        }
    }

    @Override
    public final synchronized boolean isOpen() {
        return this.state != State.INIT && this.state != State.CLOSED;
    }

    @Override
    public final synchronized boolean isEnabled() {
        if (this.state != State.COMPILED) {
            return false;
        }
        return this._isEnabled();
    }

    @Override
    public final synchronized boolean isRunning() {
        return this.state == State.STARTED;
    }

    @Override
    public final synchronized boolean isClosed() {
        return this.state == State.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void work() {
        try {
            LocalConsumer localConsumer = this;
            synchronized (localConsumer) {
                block38: {
                    if (this.state == State.GO) break block38;
                    return;
                }
                this.state = State.STARTED;
                this.fireConsumerStarted(new ConsumerEvent(this, System.nanoTime()));
            }
            this._consume();
        }
        catch (Throwable e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handleException(e);
            } else {
                e.printStackTrace();
            }
        }
        finally {
            Object object = this.stopLock;
            synchronized (object) {
                LocalConsumer localConsumer = this;
                synchronized (localConsumer) {
                    if (this.state != State.STOPPED) {
                        if (this.state != State.CLOSED) {
                            this.state = State.STOPPED;
                            this.fireConsumerStopped(new ConsumerEvent(this, System.nanoTime()));
                        }
                    }
                }
                this.workEnded = true;
                this.stopLock.notifyAll();
            }
        }
    }

    protected Thread createThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                LocalConsumer.this.work();
            }
        }, "DTrace consumer " + this.id);
        return t;
    }

    @Override
    public void go() throws DTraceException {
        this.go(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void go(ExceptionHandler h) throws DTraceException {
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: {
                throw new IllegalStateException("no compiled program");
            }
            case COMPILED: {
                this._checkProgramEnabling();
                break;
            }
            case GO: 
            case STARTED: {
                throw new IllegalStateException("go() already called");
            }
            case STOPPED: {
                throw new IllegalStateException("consumer stopped");
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
            default: {
                throw new IllegalArgumentException("unknown state: " + (Object)((Object)this.state));
            }
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._go();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.state = State.GO;
            this.exceptionHandler = h;
            Thread t = this.createThread();
            t.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean running = false;
        Object object = this;
        synchronized (object) {
            switch (this.state) {
                case INIT: {
                    throw new IllegalStateException("consumer not open");
                }
                case OPEN: 
                case COMPILED: {
                    throw new IllegalStateException("go() not called");
                }
                case GO: {
                    try {
                        Class<LocalConsumer> clazz = LocalConsumer.class;
                        synchronized (LocalConsumer.class) {
                            this._stop();
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            this.state = State.STOPPED;
                            this.fireConsumerStopped(new ConsumerEvent(this, System.nanoTime()));
                        }
                    }
                    catch (DTraceException e) {
                        if (this.exceptionHandler != null) {
                            this.exceptionHandler.handleException(e);
                            break;
                        }
                        e.printStackTrace();
                    }
                    break;
                }
                case STARTED: {
                    running = true;
                    break;
                }
                case STOPPED: {
                    if (this.stopCalled) {
                        throw new IllegalStateException("consumer already stopped");
                    }
                    logger.fine("consumer already stopped");
                    break;
                }
                case CLOSED: {
                    throw new IllegalStateException("consumer closed");
                }
                default: {
                    throw new IllegalArgumentException("unknown state: " + (Object)((Object)this.state));
                }
            }
            {
                this.stopCalled = true;
            }
        }
        {
            if (running) {
                if (Thread.holdsLock(this)) {
                    throw new IllegalThreadStateException("The current thread cannot stop this LocalConsumer while holding the lock on this LocalConsumer");
                }
                this._interrupt();
                object = this.stopLock;
                synchronized (object) {
                    while (!this.workEnded) {
                        try {
                            this.stopLock.wait();
                        }
                        catch (InterruptedException e) {
                            logger.warning(e.toString());
                        }
                    }
                }
            }
            return;
        }
    }

    @Override
    public synchronized void abort() {
        if (this.state != State.INIT && this.state != State.CLOSED) {
            this._interrupt();
        }
        this.abortCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        LocalConsumer localConsumer = this;
        synchronized (localConsumer) {
            if (this.state == State.INIT || this.state == State.CLOSED) {
                this.state = State.CLOSED;
                return;
            }
        }
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        localConsumer = this;
        synchronized (localConsumer) {
            if (this.state == State.CLOSED) return;
            Class<LocalConsumer> clazz = LocalConsumer.class;
            synchronized (LocalConsumer.class) {
                this._close();
                // ** MonitorExit[var2_4] (shouldn't be in output)
                this._destroy();
                this.state = State.CLOSED;
                if (!logger.isLoggable(Level.INFO)) return;
                logger.info("consumer table count: " + LocalConsumer._openCount());
                return;
            }
        }
    }

    @Override
    public void addConsumerListener(ConsumerListener l) {
        this.listenerList.add(ConsumerListener.class, l);
    }

    @Override
    public void removeConsumerListener(ConsumerListener l) {
        this.listenerList.remove(ConsumerListener.class, l);
    }

    @Override
    public Aggregate getAggregate() throws DTraceException {
        return this.getAggregate(null, Collections.<String>emptySet());
    }

    @Override
    public Aggregate getAggregate(Set<String> includedAggregationNames) throws DTraceException {
        return this.getAggregate(includedAggregationNames, Collections.<String>emptySet());
    }

    @Override
    public Aggregate getAggregate(Set<String> includedAggregationNames, Set<String> clearedAggregationNames) throws DTraceException {
        AggregateSpec spec = new AggregateSpec();
        if (includedAggregationNames == null) {
            spec.setIncludeByDefault(true);
        } else {
            spec.setIncludeByDefault(false);
            for (String included : includedAggregationNames) {
                spec.addIncludedAggregationName(included);
            }
        }
        if (clearedAggregationNames == null) {
            spec.setClearByDefault(true);
        } else {
            spec.setClearByDefault(false);
            for (String cleared : clearedAggregationNames) {
                spec.addClearedAggregationName(cleared);
            }
        }
        return this.getAggregate(spec);
    }

    private synchronized Aggregate getAggregate(AggregateSpec spec) throws DTraceException {
        this.checkGoCalled();
        Aggregate aggregate = this._getAggregate(spec);
        return aggregate;
    }

    private synchronized void checkGoCalled() {
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: 
            case COMPILED: {
                throw new IllegalStateException("go() not called");
            }
            case GO: 
            case STARTED: 
            case STOPPED: {
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
        }
    }

    private synchronized void checkGoNotCalled() {
        switch (this.state) {
            case INIT: {
                throw new IllegalStateException("consumer not open");
            }
            case OPEN: 
            case COMPILED: {
                break;
            }
            case GO: 
            case STARTED: {
                throw new IllegalStateException("go() already called");
            }
            case STOPPED: {
                throw new IllegalStateException("consumer stopped");
            }
            case CLOSED: {
                throw new IllegalStateException("consumer closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int createProcess(String command) throws DTraceException {
        if (command == null) {
            throw new NullPointerException("command is null");
        }
        this.checkGoNotCalled();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            int pid = this._createProcess(command);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return pid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void grabProcess(int pid) throws DTraceException {
        this.checkGoNotCalled();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._grabProcess(pid);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<ProbeDescription> listProbes(ProbeDescription filter) throws DTraceException {
        this.checkGoNotCalled();
        LinkedList<ProbeDescription> probeList = new LinkedList<ProbeDescription>();
        if (filter == ProbeDescription.EMPTY) {
            filter = null;
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._listProbes(probeList, filter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return probeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Probe> listProbeDetail(ProbeDescription filter) throws DTraceException {
        this.checkGoNotCalled();
        LinkedList<Probe> probeList = new LinkedList<Probe>();
        if (filter == ProbeDescription.EMPTY) {
            filter = null;
        }
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._listProbeDetail(probeList, filter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return probeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<ProbeDescription> listProgramProbes(Program program) throws DTraceException {
        this.checkProgram(program);
        this.checkGoNotCalled();
        LinkedList<ProbeDescription> probeList = new LinkedList<ProbeDescription>();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._listCompiledProbes(probeList, program);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return probeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Probe> listProgramProbeDetail(Program program) throws DTraceException {
        this.checkProgram(program);
        this.checkGoNotCalled();
        LinkedList<Probe> probeList = new LinkedList<Probe>();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            this._listCompiledProbeDetail(probeList, program);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return probeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String lookupKernelFunction(int address) {
        this.checkGoCalled();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this._lookupKernelFunction(new Integer(address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String lookupKernelFunction(long address) {
        this.checkGoCalled();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return this._lookupKernelFunction(new Long(address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String lookupUserFunction(int pid, int address) {
        this.checkGoCalled();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this._lookupUserFunction(pid, new Integer(address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String lookupUserFunction(int pid, long address) {
        this.checkGoCalled();
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this._lookupUserFunction(pid, new Long(address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        Class<LocalConsumer> clazz = LocalConsumer.class;
        synchronized (LocalConsumer.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return LocalConsumer._getVersion();
        }
    }

    private void nextProbeData(ProbeData probeData) throws ConsumerException {
        this.fireDataReceived(new DataEvent(this, probeData));
    }

    private void dataDropped(Drop drop) throws ConsumerException {
        this.fireDataDropped(new DropEvent(this, drop));
    }

    private void errorEncountered(Error error) throws ConsumerException {
        this.fireErrorEncountered(new ErrorEvent(this, error));
    }

    private void processStateChanged(ProcessState processState) throws ConsumerException {
        this.fireProcessStateChanged(new ProcessEvent(this, processState));
    }

    protected void fireDataReceived(DataEvent e) throws ConsumerException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).dataReceived(e);
        }
    }

    protected void fireDataDropped(DropEvent e) throws ConsumerException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).dataDropped(e);
        }
    }

    protected void fireErrorEncountered(ErrorEvent e) throws ConsumerException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).errorEncountered(e);
        }
    }

    protected void fireProcessStateChanged(ProcessEvent e) throws ConsumerException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).processStateChanged(e);
        }
    }

    protected void fireConsumerStarted(ConsumerEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).consumerStarted(e);
        }
    }

    protected void fireConsumerStopped(ConsumerEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).consumerStopped(e);
        }
    }

    private void intervalBegan() {
        this.fireIntervalBegan(new ConsumerEvent(this, System.nanoTime()));
    }

    protected void fireIntervalBegan(ConsumerEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).intervalBegan(e);
        }
    }

    private void intervalEnded() {
        this.fireIntervalEnded(new ConsumerEvent(this, System.nanoTime()));
    }

    protected void fireIntervalEnded(ConsumerEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ConsumerListener.class) continue;
            ((ConsumerListener)listeners[i + 1]).intervalEnded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(LocalConsumer.class.getName());
        LocalConsumer localConsumer = this;
        synchronized (localConsumer) {
            buf.append("[open = ");
            buf.append(this.isOpen());
            buf.append(", enabled = ");
            buf.append(this.isEnabled());
            buf.append(", running = ");
            buf.append(this.isRunning());
            buf.append(", closed = ");
            buf.append(this.isClosed());
        }
        buf.append(']');
        return buf.toString();
    }

    protected void finalize() {
        this.close();
    }

    private String getTag() {
        return super.toString();
    }

    static /* synthetic */ int access$108() {
        return sequence++;
    }

    static {
        LocalConsumer.configureLogging();
        LocalConsumer.getConfigurationOptions();
        Utility.loadLibrary("libdtrace_jni.so.1", debug);
        LocalConsumer._checkVersion(2);
        LocalConsumer._setDebug(debug);
        if (maxConsumers > 0) {
            LocalConsumer._setMaximumConsumers(maxConsumers);
        }
        LocalConsumer._loadJniTable();
        sequence = 0;
    }

    static class Identifier
    implements Serializable {
        static final long serialVersionUID = 2183165132305302834L;
        private int id = LocalConsumer.access$108();
        private long timestamp = System.currentTimeMillis();
        private InetAddress localHost;
        private String tag;

        private Identifier(LocalConsumer consumer) {
            try {
                this.localHost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                this.localHost = null;
            }
            this.tag = consumer.getTag();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Identifier) {
                Identifier i = (Identifier)o;
                return this.id == i.id && this.timestamp == i.timestamp && (this.localHost == null ? i.localHost == null : this.localHost.equals(i.localHost)) && this.tag.equals(i.tag);
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = 37 * hash + this.id;
            hash = 37 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
            hash = 37 * hash + (this.localHost == null ? 0 : this.localHost.hashCode());
            hash = 37 * hash + this.tag.hashCode();
            return hash;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(Identifier.class.getName());
            buf.append("[id = ");
            buf.append(this.id);
            buf.append(", timestamp = ");
            buf.append(this.timestamp);
            buf.append(", localHost = ");
            buf.append(this.localHost);
            buf.append(", tag = ");
            buf.append(this.tag);
            buf.append(']');
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        OPEN,
        COMPILED,
        GO,
        STARTED,
        STOPPED,
        CLOSED;

    }
}

