/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.ScalarRecord;
import org.opensolaris.os.dtrace.StackFrame;
import org.opensolaris.os.dtrace.StackValueRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KernelStackRecord
implements StackValueRecord,
Serializable,
Comparable<KernelStackRecord> {
    static final long serialVersionUID = 8616454544771346573L;
    static final int STACK_INDENT = 14;
    static final StackFrame[] EMPTY_FRAMES = new StackFrame[0];
    static final Pattern STACK_TOKENIZER;
    private StackFrame[] stackFrames;
    private byte[] rawStackData;

    static StackFrame[] parse(String s) {
        StackFrame[] frames;
        if ((s = s.trim()).length() == 0) {
            frames = EMPTY_FRAMES;
        } else {
            String[] f = STACK_TOKENIZER.split(s);
            int n = f.length;
            frames = new StackFrame[n];
            for (int i = 0; i < n; ++i) {
                frames[i] = new StackFrame(f[i]);
            }
        }
        return frames;
    }

    KernelStackRecord(byte[] rawBytes) {
        this.rawStackData = rawBytes;
        if (this.rawStackData == null) {
            throw new NullPointerException("raw stack data is null");
        }
    }

    public KernelStackRecord(StackFrame[] frames, byte[] rawBytes) {
        if (frames != null) {
            this.stackFrames = (StackFrame[])frames.clone();
        }
        if (rawBytes != null) {
            this.rawStackData = (byte[])rawBytes.clone();
        }
        this.validate();
    }

    private void validate() {
        if (this.rawStackData == null) {
            throw new NullPointerException("raw stack data is null");
        }
        if (this.stackFrames != null) {
            for (StackFrame f : this.stackFrames) {
                if (f != null) continue;
                throw new NullPointerException("stack frame is null");
            }
        }
    }

    @Override
    public StackFrame[] getStackFrames() {
        if (this.stackFrames == null) {
            return EMPTY_FRAMES;
        }
        return (StackFrame[])this.stackFrames.clone();
    }

    void setStackFrames(StackFrame[] frames) {
        this.stackFrames = frames;
        this.validate();
    }

    @Override
    public byte[] getRawStackData() {
        return (byte[])this.rawStackData.clone();
    }

    @Override
    public Object getValue() {
        return (byte[])this.rawStackData.clone();
    }

    @Override
    public List<StackFrame> asList() {
        if (this.stackFrames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.stackFrames));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KernelStackRecord) {
            KernelStackRecord r = (KernelStackRecord)o;
            return Arrays.equals(this.rawStackData, r.rawStackData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawStackData);
    }

    @Override
    public int compareTo(KernelStackRecord r) {
        if (r == this) {
            return 0;
        }
        return ProbeData.compareByteArrays(this.rawStackData, r.rawStackData);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.stackFrames != null) {
            this.stackFrames = (StackFrame[])this.stackFrames.clone();
        }
        if (this.rawStackData != null) {
            this.rawStackData = (byte[])this.rawStackData.clone();
        }
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        StackFrame[] frames = this.getStackFrames();
        if (frames.length == 0) {
            return ScalarRecord.rawBytesString(this.rawStackData);
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\n');
        for (StackFrame f : frames) {
            for (int i = 0; i < 14; ++i) {
                buf.append(' ');
            }
            buf.append(f);
            buf.append('\n');
        }
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(KernelStackRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"stackFrames", "rawStackData"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
        STACK_TOKENIZER = Pattern.compile("\\s*\n\\s*");
    }
}

