/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.EventObject;
import org.opensolaris.os.dtrace.Drop;

public class DropEvent
extends EventObject {
    static final long serialVersionUID = 5454623535426339134L;
    private Drop drop;

    public DropEvent(Object source, Drop dataDrop) {
        super(source);
        this.drop = dataDrop;
        this.validate();
    }

    private void validate() {
        if (this.drop == null) {
            throw new NullPointerException("drop is null");
        }
    }

    public Drop getDrop() {
        return this.drop;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(DropEvent.class.getName());
        buf.append("[source = ");
        buf.append(this.getSource());
        buf.append(", drop = ");
        buf.append(this.drop);
        buf.append(']');
        return buf.toString();
    }
}

