/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import org.opensolaris.os.dtrace.AbstractAggregationValue;

public final class CountValue
extends AbstractAggregationValue {
    static final long serialVersionUID = 5948954123445410783L;

    public CountValue(long v) {
        super(v);
        this.validate();
    }

    private void validate() {
        long count = super.getValue().longValue();
        if (count < 0L) {
            throw new IllegalArgumentException("count is negative");
        }
    }

    public Long getValue() {
        return (Long)super.getValue();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(CountValue.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"value"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

