/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.AggregationValue;
import org.opensolaris.os.dtrace.Record;
import org.opensolaris.os.dtrace.Tuple;

public final class AggregationRecord
implements Record,
Serializable {
    static final long serialVersionUID = -8439277589555814411L;
    private Tuple tuple;
    private AggregationValue value;

    public AggregationRecord(Tuple tupleKey, AggregationValue recordValue) {
        this.tuple = tupleKey;
        this.value = recordValue;
        this.validate();
    }

    private void validate() {
        if (this.tuple == null) {
            throw new NullPointerException("key is null");
        }
        if (this.value == null) {
            throw new NullPointerException("value is null");
        }
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public AggregationValue getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof AggregationRecord) {
            AggregationRecord r = (AggregationRecord)o;
            return this.tuple.equals(r.tuple) && this.value.equals(r.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.tuple.hashCode();
        hash = 37 * hash + this.value.hashCode();
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(AggregationRecord.class.getName());
        buf.append("[tuple = ");
        buf.append(this.tuple);
        buf.append(", value = ");
        buf.append(this.value);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(AggregationRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"tuple", "value"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

