#!/bin/ksh
#
# Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)fbtmplmeth.ksh	1.1	06/06/21 SMI"

#
# This is invoked with the following arguments:
# $1 = FMRI of this instance
#

if [ `/sbin/zonename` != "global" ]; then
	exit 0
fi

PATCHID=%%PATCHID%%

#
# Import the zpools to resynch the devids in the cache and
# in the zvol labels to the current devids.  Ignore errors,
# since there's not much we can do besides let the user
# know about it.
#
%%ZFSCMDS%%

#
# Done with this service and method, so remove it from smf.
# It's essential that when we delete the service, we delete
# the SERVICE, including all instances of it:
#
/usr/sbin/svccfg delete -f ${1%:*}
/bin/rm -f /var/svc/manifest/system/patch-${PATCHID}.xml
/bin/rm -f $0
exit 0;
