/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public abstract class QPrintable
implements Printable {
    protected abstract double printHeader(Graphics2D var1, PageFormat var2, int var3, double var4);

    protected abstract double printBody(Graphics2D var1, PageFormat var2, int var3, double var4);

    protected abstract boolean pageExists(int var1);

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableY();
        if (this.pageExists(n)) {
            d = this.printHeader(graphics2D, pageFormat, n, d);
            d = this.printBody(graphics2D, pageFormat, n, d);
            return 0;
        }
        return 1;
    }

    protected boolean checkPageBreak(PageFormat pageFormat, double d, double d2) {
        return d + d2 > pageFormat.getImageableHeight() + pageFormat.getImageableY();
    }

    protected double printSeparator(Graphics2D graphics2D, PageFormat pageFormat, double d, double d2) {
        Line2D.Double double_ = new Line2D.Double(pageFormat.getImageableX(), d2, pageFormat.getImageableX() + pageFormat.getImageableWidth(), d2);
        graphics2D.draw(double_);
        return d2 += d;
    }

    protected void printOutline(Graphics2D graphics2D, PageFormat pageFormat) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        graphics2D.draw(double_);
    }

    public int getNumberOfPages() {
        return -1;
    }
}

