/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.QConstants;
import com.qlogic.util.AlarmEntry;
import com.qlogic.util.AlarmFilter;
import com.qlogic.util.AlarmListener;
import com.qlogic.util.AlarmNotifyRunnable;
import com.qlogic.util.EntryManager;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class AlarmManager
extends EntryManager {
    public static final int TOKEN_COUNT = 6;
    private static AlarmManager m_instance = new AlarmManager();
    public Vector m_AlarmListeners = new Vector();

    private AlarmManager() {
    }

    public static AlarmManager instance() {
        return m_instance;
    }

    public void addAlarmListener(AlarmListener alarmListener) {
        this.m_AlarmListeners.addElement(alarmListener);
    }

    public void removeAlarmListener(AlarmListener alarmListener) {
        this.m_AlarmListeners.removeElement(alarmListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(AlarmEntry alarmEntry) {
        Object[] objectArray;
        Vector vector = this.m_AlarmListeners;
        synchronized (vector) {
            objectArray = new AlarmListener[this.m_AlarmListeners.size()];
            this.m_AlarmListeners.copyInto(objectArray);
        }
        if (objectArray.length > 0) {
            AlarmNotifyRunnable alarmNotifyRunnable = new AlarmNotifyRunnable(alarmEntry, (AlarmListener[])objectArray);
            SwingUtilities.invokeLater(alarmNotifyRunnable);
        }
    }

    public synchronized void addEntry(Date date, String string, String string2, int n, String string3, int n2) {
        AlarmEntry[] alarmEntryArray;
        Trace.traceAt(400, "In AlarmManager.addEntry()");
        if (this.m_AlarmListeners.size() > 0) {
            alarmEntryArray = new AlarmEntry(date, string, string2, n, string3, n2);
            this.notifyListeners((AlarmEntry)alarmEntryArray);
        }
        if (this.m_enabled && this.m_open) {
            try {
                String string4;
                int n3 = new Integer(Utilities.getProperty(QConstants.ALARM_LOG_SIZE_KEY));
                int n4 = 0;
                int n5 = 0;
                alarmEntryArray = this.getEntries();
                n4 = alarmEntryArray == null ? 0 : alarmEntryArray.length;
                boolean bl = true;
                if (n4 > n3) {
                    n5 = n4 - n3;
                    if (bl) {
                        ++n5;
                    }
                    this.truncate();
                    string4 = null;
                    int n6 = n5;
                    while (n6 < n4) {
                        string4 = QConstants.DATE_FORMAT.format(alarmEntryArray[n6].getTimeStamp());
                        this.m_file.write(string4.getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(alarmEntryArray[n6].getHostName().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(alarmEntryArray[n6].getAdapterID().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(alarmEntryArray[n6].getApplicationType()).getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(alarmEntryArray[n6].getDescription().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(alarmEntryArray[n6].getSeverity()).getBytes());
                        this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                        ++n6;
                    }
                }
                if (bl) {
                    string4 = QConstants.DATE_FORMAT.format(date);
                    this.m_file.write(string4.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(string.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(string2.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(n).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(string3.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(n2).getBytes());
                    this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                }
            }
            catch (IOException iOException) {
                Trace.warn("Add of Entry failed.  Exception " + iOException.toString() + ".");
                iOException.printStackTrace();
            }
        }
    }

    public synchronized void removeFilteredEntries(AlarmFilter alarmFilter) {
        Trace.traceAt(900, "In AlarmManager.writeFilteredEntries()");
        if (alarmFilter == null) {
            this.truncate();
            return;
        }
        AlarmEntry[] alarmEntryArray = this.getEntries();
        this.writeEntries(alarmFilter.removeAlarms(alarmEntryArray));
        Trace.traceAt(900, "Out AlarmManager.writeFilteredEntries()");
    }

    private void writeEntries(AlarmEntry[] alarmEntryArray) {
        Trace.traceAt(900, "In AlarmManager.writeEntries()");
        this.truncate();
        if (alarmEntryArray != null) {
            int n = 0;
            int n2 = 0;
            try {
                n2 = Integer.parseInt(Utilities.getProperty(QConstants.ALARM_LOG_SIZE_KEY));
            }
            catch (NumberFormatException numberFormatException) {
                Trace.warn("Invalid AlarmLimit.  Exception " + numberFormatException.toString() + ".");
            }
            if (alarmEntryArray.length > n2) {
                n = alarmEntryArray.length - n2;
            }
            try {
                this.truncate();
                int n3 = n;
                while (n3 < alarmEntryArray.length) {
                    this.m_file.write(QConstants.DATE_FORMAT.format(alarmEntryArray[n3].getTimeStamp()).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(alarmEntryArray[n3].getHostName().getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(alarmEntryArray[n3].getAdapterID().getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(alarmEntryArray[n3].getApplicationType()).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(alarmEntryArray[n3].getDescription().getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(alarmEntryArray[n3].getSeverity()).getBytes());
                    this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                    ++n3;
                }
            }
            catch (IOException iOException) {
                Trace.warn("writeEntries () failed.  Exception " + iOException.toString() + ".");
                iOException.printStackTrace();
            }
        }
        Trace.traceAt(900, "Out AlarmManager.writeEntries()");
    }

    public synchronized AlarmEntry[] getEntries() {
        Trace.traceAt(900, "In AlarmManager.getAlarmEntries()");
        String string = null;
        Date date = null;
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        int n2 = -1;
        String string5 = QConstants.getString("_t_n_r_");
        this.entryVector.removeAllElements();
        if (this.m_enabled && this.m_open) {
            Object object;
            block13: {
                try {
                    if (this.m_file.length() != 0L) {
                        this.m_file.seek(0L);
                        while ((string = this.m_file.readLine()) != null) {
                            object = new StringTokenizer(string, string5);
                            if (((StringTokenizer)object).countTokens() == 6) {
                                boolean bl = true;
                                while (((StringTokenizer)object).hasMoreTokens()) {
                                    try {
                                        date = QConstants.DATE_FORMAT.parse(((StringTokenizer)object).nextToken().trim());
                                    }
                                    catch (ParseException parseException) {
                                        bl = false;
                                        Trace.traceAt(900, "AlarmManager could not parse date string from file.");
                                    }
                                    string2 = ((StringTokenizer)object).nextToken().trim();
                                    string3 = ((StringTokenizer)object).nextToken().trim();
                                    try {
                                        n = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl = false;
                                        Trace.traceAt(900, "Error reading AlarmEntry app type (int) from alarms file.");
                                    }
                                    string4 = ((StringTokenizer)object).nextToken().trim();
                                    try {
                                        n2 = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl = false;
                                        Trace.traceAt(900, "Error reading AlarmEntry severity (int) from alarms file.");
                                    }
                                    if (!bl) continue;
                                    this.entryVector.add(new AlarmEntry(date, string2, string3, n, string4, n2));
                                }
                                continue;
                            }
                            Trace.traceAt(900, "AlarmManager.getEntries (): Invalid entry encountered and rejected.");
                        }
                        break block13;
                    }
                    return null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object = new AlarmEntry[this.entryVector.size()];
            this.entryVector.copyInto((Object[])object);
            Trace.traceAt(900, "Returning " + this.entryVector.size() + " Events.");
            Trace.traceAt(900, "Out AlarmManager.getAlarmEntries()");
            return object;
        }
        Trace.traceAt(900, "Out AlarmManager.getAlarmEntries()");
        return null;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In AlarmManager.finalize()");
        Trace.traceAt(600, "This should not be called when the application is running.");
        m_instance = null;
        super.finalize();
        Trace.traceAt(600, "In AlarmManager.finalize()");
    }
}

