/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EolBufferedOutputStream
extends BufferedOutputStream {
    protected static byte[] EOL;
    protected int prevChar = -1;

    public EolBufferedOutputStream(OutputStream outputStream) {
        super(outputStream);
        if (EOL == null) {
            String string = System.getProperty("line.separator");
            if (string == null || string.length() <= 0) {
                string = "\n";
            }
            EOL = new byte[string.length()];
            System.arraycopy(string.getBytes(), 0, EOL, 0, string.length());
        }
    }

    public void write(int n) throws IOException {
        if (n == 13) {
            this.out.write(EOL);
        } else if (n == 10 && this.prevChar != 13) {
            this.out.write(EOL);
        } else {
            this.out.write(n);
        }
        this.prevChar = n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }
}

