/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.ui.MDIDesktopPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class WindowMenu
extends JMenu {
    private MDIDesktopPane desktop;
    private JMenuItem cascade = new JMenuItem("Cascade");
    private JMenuItem tile = new JMenuItem("Tile");
    private JMenuItem closeAll = new JMenuItem("Close All");

    public WindowMenu(MDIDesktopPane mDIDesktopPane) {
        this.desktop = mDIDesktopPane;
        this.setText("Window");
        this.setMnemonic('w');
        this.cascade.setMnemonic('c');
        this.cascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowMenu.this.desktop.cascadeFrames();
            }
        });
        this.tile.setMnemonic('t');
        this.tile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowMenu.this.desktop.tileFrames();
            }
        });
        this.closeAll.setMnemonic('a');
        this.closeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowMenu.this.desktop.closeAllFrames();
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
                WindowMenu.this.removeAll();
            }

            public void menuSelected(MenuEvent menuEvent) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        this.add(this.cascade);
        this.add(this.tile);
        this.addSeparator();
        this.add(this.closeAll);
        if (jInternalFrameArray.length > 0) {
            this.addSeparator();
        }
        this.cascade.setEnabled(jInternalFrameArray.length > 0);
        this.tile.setEnabled(jInternalFrameArray.length > 0);
        this.closeAll.setEnabled(jInternalFrameArray.length > 0);
        int n = 0;
        while (n < jInternalFrameArray.length) {
            ChildMenuItem childMenuItem = new ChildMenuItem(jInternalFrameArray[n]);
            childMenuItem.setState(n == 0);
            childMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JInternalFrame jInternalFrame = ((ChildMenuItem)actionEvent.getSource()).getFrame();
                    jInternalFrame.moveToFront();
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
            });
            childMenuItem.setIcon(jInternalFrameArray[n].getFrameIcon());
            this.add(childMenuItem);
            ++n;
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame jInternalFrame) {
            super(jInternalFrame.getTitle());
            this.frame = jInternalFrame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

