/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UserPreferences {
    public static final String HEADER = "User Defined Properties";
    public static final String PROPERTY_FILE_NAME = "sfv_user.properties";
    public static final String WORKING_DIR = "workingDir";
    public static final String BROWSER_PATH = "browserPath";
    public static final String AUTO_SAVE_LOAD = "autoSaveLoad";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected String userHomeDirname = System.getProperty("user.home");
    protected String browserPath = System.getProperty("node.browser.location");
    protected String propertyFilename = this.userHomeDirname + File.separator + "sfv_user.properties";
    protected File propertyFile = new File(this.propertyFilename);
    protected Properties defaultProperties = this.getDefaultProperties();
    protected Properties userProperties = null;
    private static UserPreferences userPreferences;

    private UserPreferences() {
    }

    public static UserPreferences getInstance() {
        if (userPreferences == null) {
            userPreferences = new UserPreferences();
            userPreferences.init();
        }
        return userPreferences;
    }

    public void init() {
        if (this.propertyFile != null && this.propertyFile.exists()) {
            this.userProperties = new Properties(this.defaultProperties);
            try {
                this.userProperties.load(new BufferedInputStream(new FileInputStream(this.propertyFilename)));
            }
            catch (IOException iOException) {
                this.userProperties = this.defaultProperties;
            }
        } else {
            this.userProperties = this.defaultProperties;
        }
    }

    public void write() throws IOException {
        if (!this.propertyFile.exists()) {
            this.propertyFile.createNewFile();
        }
        this.userProperties.store(new BufferedOutputStream(new FileOutputStream(this.propertyFile)), HEADER);
        Utilities.setProperty((String)"node.browser.location", (String)Utilities.removePathSeperator((String)this.userProperties.getProperty(BROWSER_PATH)));
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public String getWorkingDirectory() {
        String string = null;
        string = this.userProperties != null ? this.userProperties.getProperty(WORKING_DIR) : this.defaultProperties.getProperty(WORKING_DIR);
        return string;
    }

    public String getPropertyFilename() {
        return this.propertyFilename;
    }

    public String getBrowserPath() {
        String string = null;
        string = this.userProperties != null ? this.userProperties.getProperty(BROWSER_PATH) : this.defaultProperties.getProperty(BROWSER_PATH);
        return string;
    }

    public boolean isAutoSaveLoadEnabled() {
        String string = null;
        string = this.userProperties != null ? this.userProperties.getProperty(AUTO_SAVE_LOAD) : this.defaultProperties.getProperty(AUTO_SAVE_LOAD);
        return string.equals(TRUE);
    }

    protected Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty(WORKING_DIR, this.userHomeDirname);
        properties.setProperty(BROWSER_PATH, this.browserPath);
        properties.setProperty(AUTO_SAVE_LOAD, TRUE);
        return properties;
    }
}

