/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneMemberElement;
import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.SanSurferTreeNode;
import com.qlogic.perfmon.SbmUtilities;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SanSurferTreeNodeRenderer
extends DefaultTreeCellRenderer {
    private static final Icon ROOT_ICON = null;
    private static final Icon FABRIC_NORMAL_ICON = new ImageIcon(SbmUtilities.getImage("fabgreen.gif"));
    private static final Icon FABRIC_UNKNOWN_ICON = new ImageIcon(SbmUtilities.getImage("fabblue.gif"));
    private static final Icon FABRIC_WARN_ICON = new ImageIcon(SbmUtilities.getImage("faborange.gif"));
    private static final Icon FABRIC_CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("fabred.gif"));
    private static final Icon GENERIC_SWITCH_ICON = new ImageIcon(SbmUtilities.getImage("swtchgreen.gif"));
    private static final Icon GENERIC_SWITCH_WARN_ICON = new ImageIcon(SbmUtilities.getImage("swtchorange.gif"));
    private static final Icon GENERIC_SWITCH_CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("swtchred.gif"));
    private static final Icon GENERIC_SWITCH_UNKNOWN_ICON = new ImageIcon(SbmUtilities.getImage("swtchblue.gif"));
    private static final Icon SWITCH_0_ICON = new ImageIcon(SbmUtilities.getImage("switch0.gif"));
    private static final Icon SWITCH_1_ICON = new ImageIcon(SbmUtilities.getImage("switch1green.gif"));
    private static final Icon SWITCH_1_WARN_ICON = new ImageIcon(SbmUtilities.getImage("switch1yellow.gif"));
    private static final Icon SWITCH_1_CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("switch1red.gif"));
    private static final Icon SWITCH_1_UNKNOWN_ICON = new ImageIcon(SbmUtilities.getImage("switch1blue.gif"));
    private static final Icon SWITCH_2_ICON = new ImageIcon(SbmUtilities.getImage("switch2green.gif"));
    private static final Icon SWITCH_2_WARN_ICON = new ImageIcon(SbmUtilities.getImage("switch2yellow.gif"));
    private static final Icon SWITCH_2_CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("switch2red.gif"));
    private static final Icon SWITCH_2_UNKNOWN_ICON = new ImageIcon(SbmUtilities.getImage("switch2blue.gif"));
    private static final Icon SWITCH_3_ICON = new ImageIcon(SbmUtilities.getImage("switch3green.gif"));
    private static final Icon SWITCH_3_WARN_ICON = new ImageIcon(SbmUtilities.getImage("switch3yellow.gif"));
    private static final Icon SWITCH_3_CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("switch3red.gif"));
    private static final Icon SWITCH_3_UNKNOWN_ICON = new ImageIcon(SbmUtilities.getImage("switch3blue.gif"));
    private static final Icon SANBOX_8PORT_ICON = new ImageIcon(SbmUtilities.getImage("swtchgreen.gif"));
    private static final Icon SANBOX_16PORT_ICON = new ImageIcon(SbmUtilities.getImage("swtchgreen.gif"));
    private static final Icon PORT_ONLINE_ICON = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOnline.gif"));
    private static final Icon PORT_OFFLINE_ICON = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOffline.gif"));
    private static final Icon WWN_ICON = new ImageIcon(SbmUtilities.getImage("WwnNode24.gif"));
    private static final Icon ALIAS_ICON = new ImageIcon(SbmUtilities.getImage("Alias.gif"));
    private static final Icon ZONE_ICON = new ImageIcon(SbmUtilities.getImage("ZoneTreeIcon.gif"));
    private static final Icon ZONE_SET_ICON = new ImageIcon(SbmUtilities.getImage("ZoneSet24.gif"));
    private static final Icon ZONE_SET_ACTIVE_ICON = new ImageIcon(SbmUtilities.getImage("ActiveZoneSet24.gif"));
    private static final Icon N_PORT_ICON = new ImageIcon(SbmUtilities.getImage("NPort.gif"));
    private static final Icon NL_PORT_ICON = new ImageIcon(SbmUtilities.getImage("NLPort24.gif"));
    private static final Icon UNKNOWN_ICON = null;
    private static Font highlightedFont = null;
    private static Font nonHighlightedFont = null;
    private Fabric fabric;

    public SanSurferTreeNodeRenderer(Fabric fabric) {
        this.fabric = fabric;
    }

    public SanSurferTreeNodeRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)object;
        Chassis chassis = null;
        Fabric fabric = null;
        FCPort fCPort = null;
        String string = sanSurferTreeNode.toString();
        switch (sanSurferTreeNode.getNodeType()) {
            case 0: {
                this.setIcon(ROOT_ICON);
                break;
            }
            case 1: {
                fabric = (Fabric)sanSurferTreeNode.getUserObject();
                this.renderFabricStatus(fabric);
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                chassis = (Chassis)sanSurferTreeNode.getUserObject();
                this.renderSwitch1Status(chassis);
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 17: {
                chassis = (Chassis)sanSurferTreeNode.getUserObject();
                this.renderSwitch2Status(chassis);
                break;
            }
            case 16: {
                chassis = (Chassis)sanSurferTreeNode.getUserObject();
                this.renderSwitch3Status(chassis);
                break;
            }
            case 99: {
                this.setIcon(SWITCH_0_ICON);
                break;
            }
            case 8: {
                this.setIcon(ZONE_SET_ICON);
                break;
            }
            case 9: {
                this.setIcon(ZONE_SET_ACTIVE_ICON);
                break;
            }
            case 10: {
                this.setIcon(ZONE_ICON);
                break;
            }
            case 11: {
                this.setIcon(ALIAS_ICON);
                break;
            }
            case 7: {
                FCNode fCNode = (FCNode)sanSurferTreeNode.getUserObject();
                string = PerfFabricTreeControl.getResource("SanSurferTreeNode.wwn") + " " + fCNode.getWwnZoningStr() + "(" + fCNode.getFC4Descriptors() + ")";
                this.setIcon(WWN_ICON);
                break;
            }
            case 6: {
                PortStates portStates;
                FCNode fCNode = (FCNode)sanSurferTreeNode.getUserObject();
                string = PerfFabricTreeControl.getResource("SanSurferTreeNode.fcaddress") + " " + fCNode.getNPortZoningStr();
                fCPort = fCNode.getPort();
                this.setIcon(N_PORT_ICON);
                if (fCPort == null || (portStates = fCPort.getPortStates()) == null || !portStates.isLoopPort()) break;
                this.setIcon(NL_PORT_ICON);
                break;
            }
            case 5: {
                fCPort = (FCPort)sanSurferTreeNode.getUserObject();
                string = PerfFabricTreeControl.getPortNodeText(fCPort);
                this.setPortIcon(fCPort);
                break;
            }
            case 12: {
                ZoneMember zoneMember = (ZoneMember)sanSurferTreeNode.getUserObject();
                if (zoneMember instanceof ZoneMemberElement) {
                    ZoneMemberElement zoneMemberElement = (ZoneMemberElement)zoneMember;
                    switch (zoneMemberElement.getType()) {
                        case 1: {
                            fCPort = this.findPort(zoneMemberElement.getMember());
                            this.setPortIcon(fCPort);
                            break;
                        }
                        case 3: {
                            this.setIcon(N_PORT_ICON);
                            break;
                        }
                        case 2: {
                            this.setIcon(WWN_ICON);
                        }
                    }
                    break;
                }
                this.setIcon(ALIAS_ICON);
                break;
            }
            default: {
                this.setIcon(UNKNOWN_ICON);
            }
        }
        this.hasFocus = bl4;
        this.selected = bl;
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.setText(string);
        this.setToolTipText(string);
        if (sanSurferTreeNode.getHighlighted()) {
            this.setFont(this.getHighlightedFont());
        } else {
            this.setFont(this.getNonHighlightedFont());
        }
        return this;
    }

    Font getHighlightedFont() {
        Font font;
        if (highlightedFont == null && (font = this.getFont()) != null) {
            nonHighlightedFont = font;
            highlightedFont = new Font(font.getName(), font.getStyle() | 2 | 1, font.getSize());
        }
        return highlightedFont;
    }

    Font getNonHighlightedFont() {
        Font font;
        if (nonHighlightedFont == null && (font = this.getFont()) != null) {
            nonHighlightedFont = font;
            highlightedFont = new Font(font.getName(), font.getStyle() | 2 | 1, font.getSize());
        }
        return nonHighlightedFont;
    }

    FCPort findPort(long l) {
        if (this.fabric != null) {
            return this.fabric.getPortByAddr((int)l);
        }
        return null;
    }

    private void setPortIcon(FCPort fCPort) {
        PortStates portStates;
        if (fCPort != null && (portStates = fCPort.getPortStates()) != null && portStates.getLoggedIn() == 1) {
            this.setIcon(PORT_ONLINE_ICON);
            return;
        }
        this.setIcon(PORT_OFFLINE_ICON);
    }

    private void renderSwitch1Status(Chassis chassis) {
        switch (chassis.getOverallStatus()) {
            case 0: {
                this.setIcon(SWITCH_1_ICON);
                break;
            }
            case 1: {
                this.setIcon(SWITCH_1_WARN_ICON);
                break;
            }
            case 2: {
                this.setIcon(SWITCH_1_CRITICAL_ICON);
                break;
            }
            default: {
                this.setIcon(SWITCH_1_UNKNOWN_ICON);
            }
        }
    }

    private void renderSwitch2Status(Chassis chassis) {
        switch (chassis.getOverallStatus()) {
            case 0: {
                this.setIcon(SWITCH_2_ICON);
                break;
            }
            case 1: {
                this.setIcon(SWITCH_2_WARN_ICON);
                break;
            }
            case 2: {
                this.setIcon(SWITCH_2_CRITICAL_ICON);
                break;
            }
            default: {
                this.setIcon(SWITCH_2_UNKNOWN_ICON);
            }
        }
    }

    private void renderSwitch3Status(Chassis chassis) {
        switch (chassis.getOverallStatus()) {
            case 0: {
                this.setIcon(SWITCH_3_ICON);
                break;
            }
            case 1: {
                this.setIcon(SWITCH_3_WARN_ICON);
                break;
            }
            case 2: {
                this.setIcon(SWITCH_3_CRITICAL_ICON);
                break;
            }
            default: {
                this.setIcon(SWITCH_3_UNKNOWN_ICON);
            }
        }
    }

    private void renderFabricStatus(Fabric fabric) {
        switch (fabric.getOverallStatus()) {
            case 0: {
                this.setIcon(FABRIC_NORMAL_ICON);
                break;
            }
            case 1: {
                this.setIcon(FABRIC_WARN_ICON);
                break;
            }
            case 2: {
                this.setIcon(FABRIC_CRITICAL_ICON);
                break;
            }
            default: {
                this.setIcon(FABRIC_UNKNOWN_ICON);
            }
        }
    }
}

