/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.perfmon.GraphInternalFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;

public class PortGraphPanel
extends JPanel {
    private static final int DEFAULT_X_SCALE = 250;
    private static final int DEFAULT_Y_SCALE = 500;
    private int xScale = 250;
    private int yScale = 500;
    FCPort fcPort = null;
    public GraphInternalFrame graphInternalFrame;
    private int upperThreshold = 350;
    private int lowerThreshold = 100;
    private Color alarmColor = Color.red;
    private Color normalColor = Color.green;
    private Color gridColor = Color.white;

    public PortGraphPanel(FCPort fCPort) {
        this.fcPort = fCPort;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.placePanels();
    }

    public Vector getToolBarExtension() {
        Vector vector = new Vector();
        return vector;
    }

    public Vector getMenuBarExtension() {
        return null;
    }

    public void statusChanged() {
    }

    public void cleanupPopup() {
    }

    public void doRefresh() {
        this.refresh();
    }

    public void refresh() {
    }

    public void setSelectedPort(FCPort fCPort) {
        this.doLayout();
        this.invalidate();
        this.repaint();
    }

    public void selectAll() {
    }

    public void placePanels() {
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public int getXScale() {
        return this.xScale;
    }

    public int getYScale() {
        return this.yScale;
    }

    public void setThresholds(int n, int n2) {
        this.upperThreshold = n;
        this.lowerThreshold = n2;
    }

    public void setAlarmColor(Color color) {
        this.alarmColor = color;
    }

    public void setNormalColor(Color color) {
        this.normalColor = color;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setColors(Color color, Color color2, Color color3) {
        this.setAlarmColor(color);
        this.setNormalColor(color2);
        this.setGridColor(color3);
    }

    public void addValue(int n) {
    }

    protected Rectangle getDisplayArea() {
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(Color.gray);
        int n = this.getYScale();
        Rectangle rectangle = this.getDisplayArea();
        int n2 = rectangle.y + rectangle.height - 1;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.height * this.upperThreshold / n;
        int n5 = n2 - n4;
        graphics.drawLine(rectangle.x, n5, n3, n5);
        n4 = rectangle.height * this.lowerThreshold / n;
        n5 = n2 - n4;
        graphics.drawLine(rectangle.x, n5, n3, n5);
    }
}

