/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.SbmUtilities;
import com.qlogic.perfmon.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QValidatedTextField;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PollingFreqDialog
extends QDialog {
    private JLabel freqLabel = new JLabel(PerfFabricTreeControl.getResource("PollingFreqDialog.setPollFrequency"));
    private QValidatedTextField freqText = new QValidatedTextField(2){

        public boolean isValid(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    };
    JButton saveButton = new JButton(new SaveAndQuitAction());
    JButton cancelButton = new JButton(new CancelAction());
    private int pollingFrequency = 1;

    public PollingFreqDialog(Frame frame) {
        super(frame);
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() {
        String string = PerfFabricTreeControl.getResource("PollingFreqDialog.title") + " - " + VendorProperties.getFrameTitle();
        this.setTitle(string);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.freqLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.freqText, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.freqText.setText(String.valueOf(this.pollingFrequency));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4, 8, 0));
        jPanel2.add(this.saveButton);
        this.saveButton.setMnemonic('O');
        jPanel2.add(this.cancelButton);
        this.cancelButton.setMnemonic('C');
        jPanel2.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.pollingFreqDialogHelp"));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.getRootPane().setDefaultButton(this.saveButton);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public int getPollingFrequency() {
        return this.pollingFrequency;
    }

    private void setPollingFrequency(int n) {
        this.pollingFrequency = n;
    }

    class SaveAndQuitAction
    extends AbstractAction {
        public SaveAndQuitAction() {
            super(PerfFabricTreeControl.getResource("PollingFreqDialog.ok"));
        }

        public SaveAndQuitAction(String string) {
            Image image = SbmUtilities.getImage(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public SaveAndQuitAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            int n = 0;
            try {
                n = numberFormat.parse(PollingFreqDialog.this.freqText.getText()).intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (n > 0 && n < 61) {
                PerfFabricTreeControl.instance().setPerfMonPollingInterval(n);
                PollingFreqDialog.this.setVisible(false);
                PollingFreqDialog.this.setPollingFrequency(n);
            } else {
                JOptionPane.showMessageDialog(PollingFreqDialog.this, PerfFabricTreeControl.getResource("PollingFreqDialog.warning"));
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(PerfFabricTreeControl.getResource("PollingFreqDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PollingFreqDialog.this.setVisible(false);
            PollingFreqDialog.this.freqText.setText(Integer.toString(PollingFreqDialog.this.pollingFrequency));
        }
    }
}

