/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SanboxPerfMonResult;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.perfmon.GraphCanvas;
import com.qlogic.perfmon.GraphInternalFrame;
import com.qlogic.perfmon.GraphOption;
import com.qlogic.perfmon.PerfFabricTreeControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Grapher
implements ChassisEventListener {
    private static final int K = 1024;
    GraphCanvas graphCanvas;
    JPanel graphPanel;
    JPanel legendPanel;
    SanboxChassis selectedSwitch = null;
    FCPort selectedPort = null;
    Vector graphOptions = null;
    private Color bkgdColor = null;
    private Color gridColor = null;
    boolean gridFlag = true;
    boolean bytesSelected = false;
    boolean framesSelected = false;
    int pollingItem = 1;
    Vector mySwitchList = new Vector();
    boolean monitoringActive = false;
    GraphInternalFrame parentFrame;
    boolean waitingForRegistrationResponse = false;
    public static final int PRE_STARTUP_STATUS = 1;
    public static final int FAILED_TO_START_STATUS = 2;
    public static final int GRAPHING_ACTIVE_STATUS = 3;
    protected int status = 1;
    JLabel[] legendLabel;
    GraphLegend[] graphLegend;
    private Font labelFont = new Font("Dialog", 1, 9);
    private String[] legendStrings = new String[]{"", "total Kbytes/sec", "tx Kbytes/sec", "rx Kbytes/sec", "total frames/sec", "tx frames/sec", "rx frames/sec", "errors/sec"};

    public Grapher() {
        this.graphPanel = this.createGraphPanel();
    }

    public Grapher(GraphInternalFrame graphInternalFrame, SanboxChassis sanboxChassis, FCPort fCPort, Vector vector, Color color, Color color2, boolean bl, boolean bl2, boolean bl3) {
        this.selectedSwitch = sanboxChassis;
        this.selectedSwitch.addChassisEventListener((ChassisEventListener)this);
        this.selectedPort = fCPort;
        this.bkgdColor = color;
        this.gridColor = color2;
        this.graphOptions = vector;
        this.gridFlag = bl;
        this.bytesSelected = bl2;
        this.framesSelected = bl3;
        this.parentFrame = graphInternalFrame;
        this.graphLegend = new GraphLegend[this.graphOptions.size()];
        int n = 0;
        while (n < this.graphOptions.size()) {
            GraphOption graphOption = (GraphOption)this.graphOptions.elementAt(n);
            this.graphLegend[n] = new GraphLegend(graphOption.getGraphItem(), this.legendStrings[graphOption.getGraphItem()], graphOption.getGraphColor());
            ++n;
        }
        this.graphPanel = this.createGraphPanel();
        this.legendPanel = this.createLegendPanel();
    }

    public Grapher(SanboxChassis sanboxChassis, Vector vector) {
        this.selectedSwitch = sanboxChassis;
        this.selectedSwitch.addChassisEventListener((ChassisEventListener)this);
        this.graphOptions = vector;
        this.graphPanel = this.createGraphPanel();
        this.legendPanel = this.createLegendPanel();
    }

    public int getStatus() {
        return this.status;
    }

    public JPanel getGraphPanel() {
        return this.graphPanel;
    }

    public JPanel getLegendPanel() {
        return this.legendPanel;
    }

    public void setGraphScale(int n, int n2) {
        if (this.graphCanvas != null) {
            this.graphCanvas.setScale(n, n2);
        }
    }

    public void resetGraphOptions(Vector vector, Color color, boolean bl, Color color2, boolean bl2, boolean bl3) {
        if (this.graphCanvas != null) {
            this.graphCanvas.resetGraph(vector, color2, bl, bl2, bl3);
        }
        this.graphOptions = vector;
        this.bytesSelected = bl2;
        this.framesSelected = bl3;
        if (color != null) {
            this.bkgdColor = color;
        }
        if (color2 != null) {
            this.gridColor = color2;
        }
        this.getGraphPanel().setBackground(this.bkgdColor);
        this.getLegendPanel().setBackground(this.bkgdColor);
        this.resetGraphLegend(vector);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            GraphOption graphOption = (GraphOption)vector.elementAt(n2);
            int n3 = graphOption.getGraphItem();
            int n4 = 0;
            while (n4 < this.graphLegend.length) {
                if (this.graphLegend[n4].getGraphItem() == n3) {
                    this.graphLegend[n4].setColor(graphOption.getGraphColor());
                }
                ++n4;
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < this.legendLabel.length) {
            this.legendLabel[n5].setForeground(this.graphLegend[n5].getColor());
            this.legendLabel[n5].setBackground(this.bkgdColor);
            ++n5;
        }
        this.legendPanel = this.createLegendPanel();
    }

    private void resetGraphLegend(Vector vector) {
        GraphLegend[] graphLegendArray = new GraphLegend[vector.size()];
        JLabel[] jLabelArray = new JLabel[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            GraphOption graphOption = (GraphOption)vector.elementAt(n);
            graphLegendArray[n] = new GraphLegend(graphOption.getGraphItem(), this.legendStrings[graphOption.getGraphItem()], graphOption.getGraphColor());
            jLabelArray[n] = new JLabel(graphLegendArray[n].getString());
            jLabelArray[n].setForeground(graphLegendArray[n].getColor());
            jLabelArray[n].setBackground(this.bkgdColor);
            ++n;
        }
        this.graphLegend = graphLegendArray;
        this.legendLabel = jLabelArray;
    }

    private JPanel createGraphPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        Color[] colorArray = new Color[]{Color.red};
        this.graphCanvas = new GraphCanvas(this.graphOptions, this.gridColor, this.gridFlag, this.bytesSelected, this.framesSelected, this);
        jPanel.add((Component)this.graphCanvas, "Center");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(this.bkgdColor);
        return jPanel;
    }

    private JPanel createLegendPanel() {
        JPanel jPanel = new JPanel();
        int n = this.graphOptions.size();
        this.legendLabel = new JLabel[n];
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(this.bkgdColor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            block4: {
                block6: {
                    block7: {
                        GraphOption graphOption;
                        block5: {
                            this.legendLabel[n3] = new JLabel(this.graphLegend[n3].getString());
                            this.legendLabel[n3].setForeground(this.graphLegend[n3].getColor());
                            this.legendLabel[n3].setBackground(this.bkgdColor);
                            this.legendLabel[n3].setFont(this.labelFont);
                            graphOption = (GraphOption)this.graphOptions.get(n3);
                            if (!graphOption.getGraphItemSelected()) break block4;
                            if (graphOption.getGraphItem() != 1 && graphOption.getGraphItem() != 2 && graphOption.getGraphItem() != 3) break block5;
                            if (!this.bytesSelected) break block4;
                            ++n2;
                            break block6;
                        }
                        if (graphOption.getGraphItem() != 4 && graphOption.getGraphItem() != 5 && graphOption.getGraphItem() != 6) break block7;
                        if (!this.framesSelected) break block4;
                        ++n2;
                        break block6;
                    }
                    ++n2;
                }
                if (n2 > 0 && n2 % 2 == 0) {
                    ++gridBagConstraints.gridy;
                }
                if (n2 > 0 && n2 % 2 == 1) {
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                    gridBagConstraints.anchor = 13;
                    this.legendLabel[n3].setHorizontalAlignment(4);
                } else {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                    gridBagConstraints.anchor = 17;
                }
                jPanel.add((Component)this.legendLabel[n3], gridBagConstraints);
            }
            ++n3;
        }
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray));
        return jPanel;
    }

    public boolean startGraphing() {
        this.monitoringActive = true;
        this.graphCanvas.setSize(200, 300);
        if (!this.selectedSwitch.isPerformanceMonitoringActive()) {
            this.waitingForRegistrationResponse = true;
            return this.selectedSwitch.startPerformanceMonitoring();
        }
        return true;
    }

    public boolean stopGraphing() {
        this.selectedSwitch.removeChassisEventListener((ChassisEventListener)this);
        this.monitoringActive = false;
        return true;
    }

    public void frameResize() {
        this.graphCanvas.recalculateScale();
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + PerfFabricTreeControl.translateErrorType(errorType) + "]";
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyChassisEventHandler(chassisEvent, this));
    }

    class GraphLegend {
        int graphItem;
        String str;
        Color color;

        public GraphLegend(int n, String string, Color color) {
            this.graphItem = n;
            this.str = string;
            this.color = color;
        }

        public int getGraphItem() {
            return this.graphItem;
        }

        public void setGraphItem(int n) {
            this.graphItem = n;
        }

        public String getString() {
            return this.str;
        }

        public void setString(String string) {
            this.str = string;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    class ApplyChassisEventHandler
    implements Runnable {
        Object evt = null;
        Grapher grapher;

        public ApplyChassisEventHandler(Object object, Grapher grapher2) {
            this.evt = object;
            this.grapher = grapher2;
        }

        public void run() {
            long[] lArray = new long[16];
            ChassisEvent chassisEvent = (ChassisEvent)this.evt;
            int n = ((ChassisEvent)this.evt).getEventType();
            switch (n) {
                case 319: {
                    if (!chassisEvent.isSuccessful() && Grapher.this.waitingForRegistrationResponse) {
                        Grapher.this.waitingForRegistrationResponse = false;
                        Grapher.this.status = 2;
                        if (Grapher.this.graphCanvas != null) {
                            Grapher.this.graphCanvas.repaint();
                        }
                    } else if (chassisEvent.isSuccessful() && Grapher.this.waitingForRegistrationResponse) {
                        Grapher.this.status = 3;
                    }
                    Grapher.this.waitingForRegistrationResponse = false;
                    break;
                }
                case 320: {
                    break;
                }
                case 321: {
                    int n2 = 1;
                    if (!chassisEvent.isSuccessful()) break;
                    this.plotDataPoint(n2, (long[])chassisEvent.getValue());
                    break;
                }
                case 323: {
                    int n3 = 3;
                    if (!chassisEvent.isSuccessful()) break;
                    this.plotDataPoint(n3, (long[])chassisEvent.getValue());
                    break;
                }
                case 322: {
                    int n4 = 2;
                    if (!chassisEvent.isSuccessful()) break;
                    this.plotDataPoint(n4, (long[])chassisEvent.getValue());
                    break;
                }
                case 324: {
                    int n5 = 4;
                    if (!chassisEvent.isSuccessful()) break;
                    if (Grapher.this.selectedSwitch instanceof Sanbox2) {
                        this.plotDataPoint(n5, (long[])chassisEvent.getValue());
                        break;
                    }
                    SanboxPerfMonResult sanboxPerfMonResult = (SanboxPerfMonResult)chassisEvent.getValue();
                    if (sanboxPerfMonResult.getPortNumber() != Grapher.this.selectedPort.getPortNumber()) break;
                    long l = sanboxPerfMonResult.getValue();
                    Grapher.this.graphCanvas.plotPoint(n5, l);
                    break;
                }
                case 327: {
                    int n6 = 7;
                    if (!chassisEvent.isSuccessful()) break;
                    if (Grapher.this.selectedSwitch instanceof Sanbox2) {
                        this.plotDataPoint(n6, (long[])chassisEvent.getValue());
                        break;
                    }
                    SanboxPerfMonResult sanboxPerfMonResult = (SanboxPerfMonResult)chassisEvent.getValue();
                    if (sanboxPerfMonResult.getPortNumber() != Grapher.this.selectedPort.getPortNumber()) break;
                    long l = sanboxPerfMonResult.getValue();
                    Grapher.this.graphCanvas.plotPoint(n6, l);
                    break;
                }
                case 326: {
                    int n7 = 6;
                    if (!chassisEvent.isSuccessful()) break;
                    if (Grapher.this.selectedSwitch instanceof Sanbox2) {
                        this.plotDataPoint(n7, (long[])chassisEvent.getValue());
                        break;
                    }
                    SanboxPerfMonResult sanboxPerfMonResult = (SanboxPerfMonResult)chassisEvent.getValue();
                    if (sanboxPerfMonResult.getPortNumber() != Grapher.this.selectedPort.getPortNumber()) break;
                    long l = sanboxPerfMonResult.getValue();
                    Grapher.this.graphCanvas.plotPoint(n7, l);
                    break;
                }
                case 325: {
                    int n8 = 5;
                    if (!chassisEvent.isSuccessful()) break;
                    if (Grapher.this.selectedSwitch instanceof Sanbox2) {
                        this.plotDataPoint(n8, (long[])chassisEvent.getValue());
                        break;
                    }
                    SanboxPerfMonResult sanboxPerfMonResult = (SanboxPerfMonResult)chassisEvent.getValue();
                    if (sanboxPerfMonResult.getPortNumber() != Grapher.this.selectedPort.getPortNumber()) break;
                    long l = sanboxPerfMonResult.getValue();
                    Grapher.this.graphCanvas.plotPoint(n8, l);
                    break;
                }
            }
        }

        public void plotDataPoint(int n, long[] lArray) {
            long l = 0L;
            if (Grapher.this.selectedPort != null) {
                l = lArray[Grapher.this.selectedPort.getPortNumber()];
            }
            if (n == 1 || n == 3 || n == 2) {
                l = l > 1024L ? (l /= 1024L) : 0L;
            }
            Grapher.this.graphCanvas.plotPoint(n, l);
        }
    }
}

