/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.perfmon.GraphOption;
import com.qlogic.perfmon.Grapher;
import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.ReportPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class GraphInternalFrame
extends JInternalFrame
implements MouseListener,
ActionListener,
Printable {
    private Chassis fcSwitch = null;
    private FCPort fcPort = null;
    private String fabName;
    private Grapher grapher;
    int previousValue = -1;
    static final int xOffset = 20;
    static final int yOffset = 20;
    private Point defaultLocation;
    protected JPopupMenu menu = new JPopupMenu();
    private JMenuItem changeGraphOptionsItem = new JMenuItem(PerfFabricTreeControl.getResource("GraphInternalFrame.changeGraphOptions"));
    private JMenuItem printGraphItem = new JMenuItem(PerfFabricTreeControl.getResource("GraphInternalFrame.printGraph"));
    private JMenuItem saveStatisticsItem = new JMenuItem(PerfFabricTreeControl.getResource("GraphInternalFrame.saveStatistics"));
    private Vector singleGraphOpts;
    private Vector graphOnlyOpts;
    ReportPanel rptPanel = null;
    private JPanel legPanel;
    private boolean gridFlag;
    private Color gridColor;
    private Color bkgdColor;
    private boolean bytesSelected;
    private boolean framesSelected;
    private boolean selected;
    int printPageCount;
    double scale = 1.0;

    public GraphInternalFrame(String string, Chassis chassis, FCPort fCPort, Point point, Vector vector, String string2, boolean bl) {
        super(string, true, true, true, true);
        this.fcSwitch = chassis;
        this.fcPort = fCPort;
        this.defaultLocation = point;
        this.singleGraphOpts = vector;
        this.fabName = string2;
        this.setSize(300, 200);
        this.setMinimumSize(new Dimension(240, 160));
        this.setLocation(this.defaultLocation);
        this.graphOnlyOpts = new Vector();
        this.removeNonGraphableOptions(this.graphOnlyOpts);
        if (bl) {
            this.graphStartup();
        }
    }

    public void graphStartup() {
        if (this.fcSwitch instanceof Sanbox2) {
            Sanbox2 sanbox2 = (Sanbox2)this.fcSwitch;
            PerfFabricTreeControl perfFabricTreeControl = PerfFabricTreeControl.instance();
            if (sanbox2.getPerfMonInterval() != perfFabricTreeControl.getPerfMonPollingInterval()) {
                sanbox2.applyPerfMonInterval(perfFabricTreeControl.getPerfMonPollingInterval());
            }
        }
        this.grapher = new Grapher(this, (SanboxChassis)this.fcSwitch, this.fcPort, this.graphOnlyOpts, this.bkgdColor, this.gridColor, this.gridFlag, this.bytesSelected, this.framesSelected);
        this.getContentPane().add((Component)this.grapher.getGraphPanel(), "Center");
        this.legPanel = this.grapher.getLegendPanel();
        this.getContentPane().add((Component)this.legPanel, "South");
        this.grapher.startGraphing();
        this.changeGraphOptionsItem.addActionListener(this);
        this.printGraphItem.addActionListener(this);
        this.saveStatisticsItem.addActionListener(this);
        this.menu.add(this.changeGraphOptionsItem);
        this.menu.addSeparator();
        this.menu.add(this.printGraphItem);
        this.menu.add(this.saveStatisticsItem);
        this.addMouseListener(this);
    }

    private void removeNonGraphableOptions(Vector vector) {
        int n = 0;
        while (n < this.singleGraphOpts.size()) {
            try {
                GraphOption graphOption = (GraphOption)this.singleGraphOpts.get(n);
                switch (graphOption.getGraphItem()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        vector.add(graphOption);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        vector.add(graphOption);
                        break;
                    }
                    case 7: {
                        vector.add(graphOption);
                        break;
                    }
                    case 101: {
                        this.bytesSelected = graphOption.getGraphItemSelected();
                        break;
                    }
                    case 102: {
                        this.framesSelected = graphOption.getGraphItemSelected();
                        break;
                    }
                    case 103: {
                        this.gridFlag = graphOption.getGraphItemSelected();
                        this.gridColor = graphOption.getGraphColor();
                        break;
                    }
                    case 104: {
                        this.bkgdColor = graphOption.getGraphColor();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private boolean getItemSelectedState(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.singleGraphOpts.size()) {
            GraphOption graphOption = (GraphOption)this.singleGraphOpts.get(n2);
            if (graphOption.getGraphItem() == n && graphOption.getGraphItemSelected()) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public String getFabricName() {
        return this.fabName;
    }

    public Chassis getChassis() {
        return this.fcSwitch;
    }

    public FCPort getPort() {
        return this.fcPort;
    }

    public boolean getSavedSelectState() {
        return this.selected;
    }

    public void setSavedSelectState(boolean bl) {
        this.selected = bl;
    }

    public Vector getGraphOptions() {
        return this.singleGraphOpts;
    }

    public void setGraphOptions(Vector vector) {
        this.singleGraphOpts.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.singleGraphOpts.add(vector.get(n));
            ++n;
        }
    }

    public void applyGraphOptions(Vector vector) {
        this.setGraphOptions(vector);
        this.graphOnlyOpts = new Vector();
        this.removeNonGraphableOptions(this.graphOnlyOpts);
        this.grapher.resetGraphOptions(this.graphOnlyOpts, this.bkgdColor, this.gridFlag, this.gridColor, this.bytesSelected, this.framesSelected);
        this.getContentPane().remove(this.legPanel);
        this.legPanel = this.getGrapher().getLegendPanel();
        this.getContentPane().add((Component)this.legPanel, "South");
        this.validate();
    }

    private void createTitle() {
    }

    public Point getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setDefaultLocation(Point point) {
        this.defaultLocation = point;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.menu.show(this, n, n2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(PerfFabricTreeControl.getResource("GraphInternalFrame.printGraph"))) {
            this.printGraphWindow();
        } else if (actionEvent.getActionCommand().equals(PerfFabricTreeControl.getResource("GraphInternalFrame.saveStatistics"))) {
            PerfFabricTreeControl.instance().saveStatistics(this);
        } else {
            PerfFabricTreeControl.instance().graphOptions(this.singleGraphOpts);
        }
    }

    public void printGraphWindow() {
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
        int n = this.calculatePageCount(pageFormat);
        book.append(this, pageFormat, n);
        printerJob.setPageable(book);
        if (printerJob != null && printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
    }

    public int calculatePageCount(PageFormat pageFormat) {
        double d = pageFormat.getImageableHeight();
        double d2 = pageFormat.getImageableWidth();
        double d3 = this.getSize().getWidth();
        if (d3 > d2) {
            this.scale = d2 / d3;
        }
        double d4 = this.getSize().getHeight() * this.scale;
        this.printPageCount = (int)Math.round(Math.ceil(d4 / d));
        return this.printPageCount;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.printPageCount) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableHeight();
        double d2 = pageFormat.getImageableWidth();
        graphics2D.setClip(0, 0, (int)d2, (int)d);
        graphics2D.translate(pageFormat.getImageableX(), (double)(-n) * d + pageFormat.getImageableY());
        graphics2D.scale(this.scale, this.scale);
        this.paint(graphics2D);
        return 0;
    }

    public Grapher getGrapher() {
        return this.grapher;
    }
}

