/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.perfmon.GraphOption;
import com.qlogic.perfmon.Grapher;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;

public class GraphCanvas
extends JComponent {
    public static final long YSCALE_5 = 5L;
    public static final long YSCALE_10 = 10L;
    public static final long YSCALE_15 = 15L;
    public static final long YSCALE_20 = 20L;
    public static final long YSCALE_25 = 25L;
    public static final long YSCALE_50 = 50L;
    public static final long YSCALE_100 = 100L;
    public static final long YSCALE_250 = 250L;
    public static final long YSCALE_500 = 500L;
    public static final long YSCALE_750 = 750L;
    public static final long YSCALE_1K = 1000L;
    public static final long YSCALE_2K = 2000L;
    public static final long YSCALE_3K = 3000L;
    public static final long YSCALE_4K = 4000L;
    public static final long YSCALE_5K = 5000L;
    public static final long YSCALE_6K = 6000L;
    public static final long YSCALE_7K = 7000L;
    public static final long YSCALE_8K = 8000L;
    public static final long YSCALE_9K = 9000L;
    public static final long YSCALE_10K = 10000L;
    public static final long YSCALE_15K = 15000L;
    public static final long YSCALE_20K = 20000L;
    public static final long YSCALE_25K = 25000L;
    public static final long YSCALE_50K = 50000L;
    public static final long YSCALE_75K = 75000L;
    public static final long YSCALE_100K = 100000L;
    public static final long YSCALE_125K = 125000L;
    public static final long YSCALE_150K = 150000L;
    public static final long YSCALE_175K = 175000L;
    public static final long YSCALE_200K = 200000L;
    public static final long YSCALE_225K = 225000L;
    public static final long XSCALE_180SEC = 180L;
    public static final long XSCALE_MAX = 900L;
    public static final int LEFT_MARGIN = 35;
    public static final int BOTTOM_MARGIN = 20;
    public static final int TOP_RIGHT_MARGIN = 5;
    public static final int END_OF_GRAPH_SPACING = 15;
    public static final int Y_SCALE_LABEL_MARGIN = 5;
    public static final int X_SCALE_LABEL_MARGIN = 5;
    public static final int VERTICAL_GRID_LINE_SPACING = 60;
    public static final int HORIZONTAL_GRID_LINE_COUNT = 6;
    public static final int Y_AXIS_LABEL_LENGTH = 6;
    public static final int LABEL_OFFSET = 5;
    public static final int KEY_SPACING = 20;
    private long[] yScaleOptions = new long[]{5L, 10L, 15L, 20L, 25L, 50L, 100L, 250L, 500L, 750L, 1000L, 2000L, 3000L, 4000L, 5000L, 6000L, 7000L, 8000L, 9000L, 10000L, 15000L, 20000L, 25000L, 50000L, 75000L, 100000L, 125000L, 150000L, 175000L, 200000L, 225000L};
    private Font labelFont = new Font("Dialog", 1, 9);
    private Font failedMsgFont = new Font("Dialog", 1, 14);
    private String failedMsg = "Registration Failed";
    private long xScale;
    private long yScale;
    private Hashtable graphingTable = new Hashtable();
    int newGraphLinesRecorded;
    int graphLineCount;
    private boolean grid = true;
    private int time;
    boolean recalculateScaleFlag;
    int debugGrid = 0;
    private Color gridColor = null;
    private boolean bytesSelected = false;
    private boolean framesSelected = false;
    private int currentHeight;
    private Grapher grapher;

    public GraphCanvas(Vector vector, Color color, boolean bl, boolean bl2, boolean bl3, Grapher grapher) {
        this.grapher = grapher;
        this.xScale = 180L;
        this.yScale = 5L;
        this.time = 0;
        this.gridColor = color;
        this.grid = bl;
        this.bytesSelected = bl2;
        this.framesSelected = bl3;
        this.graphLineCount = 0;
        int n = 0;
        while (n < vector.size()) {
            GraphOption graphOption = (GraphOption)vector.elementAt(n);
            GraphTableEntry graphTableEntry = new GraphTableEntry(graphOption);
            if (graphOption.getGraphItemSelected()) {
                if (graphOption.getGraphItem() == 1 || graphOption.getGraphItem() == 2 || graphOption.getGraphItem() == 3) {
                    graphTableEntry.setIsGraphing(this.bytesSelected);
                } else if (graphOption.getGraphItem() == 4 || graphOption.getGraphItem() == 5 || graphOption.getGraphItem() == 6) {
                    graphTableEntry.setIsGraphing(this.framesSelected);
                } else {
                    graphTableEntry.setIsGraphing(true);
                }
            } else {
                graphTableEntry.setIsGraphing(false);
            }
            if (graphTableEntry.getIsGraphing()) {
                ++this.graphLineCount;
            }
            this.graphingTable.put(new Integer(graphOption.getGraphItem()), graphTableEntry);
            ++n;
        }
        this.recalculateScaleFlag = true;
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension);
    }

    public void recalculateScale() {
        this.recalculateScaleFlag = true;
        this.setScale(this.xScale, this.yScale);
        this.repaint();
    }

    public void plotPoint(int n, long l) {
        int n2;
        ++this.newGraphLinesRecorded;
        GraphTableEntry graphTableEntry = (GraphTableEntry)this.graphingTable.get(new Integer(n));
        if (graphTableEntry == null) {
            return;
        }
        ArrayList<GraphPoint> arrayList = graphTableEntry.getGraphPoints();
        GraphOption graphOption = graphTableEntry.getGraphOption();
        if (arrayList == null) {
            arrayList = new ArrayList<GraphPoint>();
            graphTableEntry.setGraphPoints(arrayList);
            n2 = (this.getHeight() - 25) % 5;
            arrayList.add(new GraphPoint(0L, this.yScale, this.getHeight() - 20 - n2));
        }
        if (l > this.yScale && this.yScale != this.yScaleOptions[this.yScaleOptions.length - 1] || this.getHeight() != this.currentHeight) {
            n2 = 0;
            while (n2 < this.yScaleOptions.length) {
                if (l <= this.yScaleOptions[n2]) {
                    this.setScale(180L, this.yScaleOptions[n2]);
                    break;
                }
                ++n2;
            }
            if (n2 == this.yScaleOptions.length) {
                this.setScale(180L, this.yScaleOptions[n2 - 1]);
            }
        }
        long l2 = arrayList.size() + 1;
        long l3 = l;
        if ((long)arrayList.size() > 900L) {
            arrayList.remove(0);
        }
        int n3 = this.getWidth() - 40;
        int n4 = this.getHeight() - 25;
        float f = (float)n3 / (float)this.xScale;
        float f2 = (float)n4 / (float)this.yScale;
        int n5 = (int)(f2 * (float)l3);
        int n6 = this.getHeight() - 20 - n4 % 5;
        n5 = n5 > n6 ? n6 : n5;
        n5 = n6 - n5;
        n5 = n5 <= 5 ? 5 : n5;
        arrayList.add(new GraphPoint(l3, this.yScale, n5));
        if (this.newGraphLinesRecorded >= this.graphLineCount) {
            this.newGraphLinesRecorded = 0;
            this.repaint();
        }
        this.currentHeight = this.getHeight();
    }

    public void setScale(long l, long l2) {
        this.xScale = l;
        this.yScale = l2;
        Enumeration enumeration = this.graphingTable.elements();
        while (enumeration.hasMoreElements()) {
            GraphTableEntry graphTableEntry = (GraphTableEntry)enumeration.nextElement();
            ArrayList arrayList = graphTableEntry.getGraphPoints();
            if (arrayList == null) continue;
            int n = 0;
            while (n < arrayList.size()) {
                ((GraphPoint)arrayList.get(n)).refactor(this.yScale, this.getHeight());
                ++n;
            }
        }
    }

    public void resetGraph(Vector vector, Color color, boolean bl, boolean bl2, boolean bl3) {
        Enumeration enumeration = this.graphingTable.elements();
        int n = vector.size();
        this.grid = bl;
        this.gridColor = color;
        this.bytesSelected = bl2;
        this.framesSelected = bl3;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            GraphTableEntry graphTableEntry = (GraphTableEntry)enumeration.nextElement();
            GraphOption graphOption = graphTableEntry.getGraphOption();
            int n3 = 0;
            while (n3 < n) {
                GraphOption graphOption2 = (GraphOption)vector.elementAt(n3);
                if (graphOption.getGraphItem() == graphOption2.getGraphItem()) {
                    graphTableEntry.setGraphOption(graphOption2);
                    if (graphOption2.getGraphItemSelected()) {
                        if (graphOption2.getGraphItem() == 1 || graphOption2.getGraphItem() == 2 || graphOption2.getGraphItem() == 3) {
                            graphTableEntry.setIsGraphing(this.bytesSelected);
                        } else if (graphOption2.getGraphItem() == 4 || graphOption2.getGraphItem() == 5 || graphOption2.getGraphItem() == 6) {
                            graphTableEntry.setIsGraphing(this.framesSelected);
                        } else {
                            graphTableEntry.setIsGraphing(true);
                        }
                    } else {
                        graphTableEntry.setIsGraphing(false);
                    }
                    if (graphTableEntry.getIsGraphing()) {
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        this.graphLineCount = n2;
    }

    public void setGridFlag(boolean bl) {
        this.grid = bl;
    }

    public void clearGraph() {
        Enumeration enumeration = this.graphingTable.elements();
        while (enumeration.hasMoreElements()) {
            GraphTableEntry graphTableEntry = (GraphTableEntry)enumeration.nextElement();
            ArrayList arrayList = graphTableEntry.getGraphPoints();
            if (arrayList == null) continue;
            int n = 0;
            while (n < arrayList.size()) {
                arrayList = null;
                ++n;
            }
        }
    }

    public Hashtable getGraphingTable() {
        return this.graphingTable;
    }

    public ArrayList getGraphData(int n) {
        GraphTableEntry graphTableEntry;
        ArrayList arrayList = null;
        if (this.graphingTable != null && (graphTableEntry = (GraphTableEntry)this.graphingTable.get(new Integer(n))) != null) {
            arrayList = graphTableEntry.getGraphPoints();
        }
        return arrayList;
    }

    public long getGraphValue(ArrayList arrayList, int n) {
        long l = 0L;
        GraphPoint graphPoint = (GraphPoint)arrayList.get(n);
        l = graphPoint.getRawY();
        return l;
    }

    public void drawLineGraph(Graphics graphics) {
        int n = this.getWidth() - 35;
        int n2 = this.getHeight() - 20;
        float f = (float)n / (float)this.xScale;
        float f2 = (float)n2 / (float)this.yScale;
        Enumeration enumeration = this.graphingTable.elements();
        while (enumeration.hasMoreElements()) {
            int n3;
            GraphTableEntry graphTableEntry = (GraphTableEntry)enumeration.nextElement();
            ArrayList arrayList = graphTableEntry.getGraphPoints();
            GraphOption graphOption = graphTableEntry.getGraphOption();
            if (arrayList == null || !graphTableEntry.getIsGraphing()) continue;
            int n4 = arrayList.size();
            int n5 = arrayList.size();
            int n6 = n5 > (n3 = this.getGraphWidth() - 35 - 5) ? n3 : n5;
            int n7 = n5 - n6;
            Object var15_15 = null;
            int n8 = 0;
            int n9 = 0;
            int n10 = n7;
            int n11 = 0;
            while (n11 < n6) {
                if (n11 == 0) {
                    n8 = ((GraphPoint)arrayList.get(n10)).getY();
                    n9 = 35;
                } else {
                    int n12 = n9 + 1;
                    int n13 = ((GraphPoint)arrayList.get(n10)).getY();
                    graphics.setColor(graphOption.getGraphColor());
                    graphics.drawLine(n9, n8, n12, n13);
                    n8 = n13;
                    n9 = n12;
                }
                ++n11;
                ++n10;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.grapher.getStatus() == 2) {
            this.drawFailedDisplay(graphics);
            return;
        }
        graphics.setFont(this.labelFont);
        if (this.grid) {
            this.drawGrid(graphics);
        } else {
            this.drawScaleLabels(graphics);
        }
        this.drawLineGraph(graphics);
    }

    public int getGraphWidth() {
        int n = this.getWidth() - 40;
        int n2 = 1;
        if (n > 60) {
            n2 = n / 60 + 1;
        }
        int n3 = n;
        if (n2 > 1) {
            n3 = n % (n2 - 1);
        }
        return this.getWidth() - 5 - n3;
    }

    public String rightJustifyString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < 6) {
            stringBuffer.insert(0, ' ');
        }
        return stringBuffer.toString();
    }

    public void drawGrid(Graphics graphics) {
        graphics.setColor(this.gridColor);
        int n = this.getWidth() - 40;
        int n2 = this.getHeight() - 25;
        int n3 = 1;
        if (n > 60) {
            n3 = n / 60 + 1;
        }
        float f = n2 / 5;
        float f2 = 60.0f;
        int n4 = n2 % 5;
        int n5 = n;
        if (n3 > 1) {
            n5 = n % (n3 - 1);
        }
        int n6 = 35;
        int n7 = 5;
        int n8 = this.getWidth() - 5 - n5;
        int n9 = 0;
        while (n9 < 6) {
            if (n9 < 5) {
                long l = this.yScale / 5L * (long)(6 - n9 - 1);
                String string = String.valueOf(l);
                graphics.drawString(this.rightJustifyString(string), 5, n7 + 5);
            }
            graphics.drawLine(n6, n7, n8, n7);
            n7 = (int)((float)n7 + f);
            ++n9;
        }
        n6 = 35;
        n7 = 5;
        int n10 = this.getHeight() - 20 - n4;
        int n11 = 0;
        while (n11 < n3) {
            graphics.drawLine(n6, n7, n6, n10);
            n6 += 60;
            ++n11;
        }
        graphics.drawLine(n8, 5, n8, n10);
    }

    public void drawScaleLabels(Graphics graphics) {
        graphics.setColor(this.gridColor);
        int n = this.getHeight() - 25;
        float f = n / 5;
        int n2 = 35;
        int n3 = 5;
        int n4 = this.getGraphWidth();
        int n5 = 0;
        while (n5 < 6) {
            if (n5 < 6) {
                long l = this.yScale / 5L * (long)(6 - n5 - 1);
                String string = String.valueOf(l);
                graphics.drawString(this.rightJustifyString(string), 5, n3 + 5);
            }
            n3 = (int)((float)n3 + f);
            ++n5;
        }
    }

    public void drawFailedDisplay(Graphics graphics) {
        graphics.setColor(this.gridColor);
        graphics.setFont(this.failedMsgFont);
        int n = this.getHeight() - 25;
        float f = n / 5;
        int n2 = 35;
        int n3 = 5;
        int n4 = this.getGraphWidth();
        graphics.drawString(this.rightJustifyString(this.failedMsg), 5, 5 + (int)(0.5 * (double)n));
    }

    class GraphKey {
        String key;
        Color color;

        public GraphKey(String string, Color color) {
            this.key = string;
            this.color = color;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    class GraphPoint {
        long rawY;
        long yScale;
        int y;

        public GraphPoint(long l, long l2, int n) {
            this.rawY = l;
            this.yScale = l2;
            this.y = n;
        }

        public long getRawY() {
            return this.rawY;
        }

        public long getYScale() {
            return this.yScale;
        }

        public void setYScale(long l) {
            this.yScale = l;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public void refactor(long l, int n) {
            int n2 = n - 25;
            float f = (float)n2 / (float)l;
            int n3 = (int)(f * (float)this.rawY);
            int n4 = n - 20 - n2 % 5;
            n3 = n3 > n4 ? n4 : n3;
            n3 = n4 - n3;
            n3 = n3 <= 5 ? 5 : n3;
            this.yScale = l;
            this.y = n3;
        }
    }

    class GraphTableEntry {
        GraphOption graphOption;
        ArrayList graphPoints = null;
        boolean isGraphing = false;

        public GraphTableEntry(GraphOption graphOption) {
            this.graphOption = graphOption;
        }

        public GraphOption getGraphOption() {
            return this.graphOption;
        }

        public void setGraphOption(GraphOption graphOption) {
            this.graphOption = graphOption;
        }

        public ArrayList getGraphPoints() {
            return this.graphPoints;
        }

        public void setGraphPoints(ArrayList arrayList) {
            this.graphPoints = arrayList;
        }

        public boolean getIsGraphing() {
            return this.isGraphing;
        }

        public void setIsGraphing(boolean bl) {
            this.isGraphing = bl;
        }
    }
}

