/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.zoning;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.events.ZoneSetEvent;
import com.qlogic.device.fcfabric.zoning.events.ZoneSetListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class ZoneSet
implements Serializable {
    transient Vector listeners = new Vector();
    boolean dirtyFlag = false;
    private String name;
    private boolean active;
    Vector zones = new Vector();
    private boolean orphanZoneSet = false;
    Zones zoneDb;

    ZoneSet(String string, Zones zones, boolean bl) {
        this.zoneDb = zones;
        this.name = string;
        this.orphanZoneSet = bl;
    }

    public int compareTo(Object object) {
        if (object instanceof ZoneSet) {
            ZoneSet zoneSet = (ZoneSet)object;
            int n = this.getName().compareToIgnoreCase(zoneSet.getName());
            if (n == 0) {
                n = this.getName().compareTo(zoneSet.getName());
            }
            return n;
        }
        return -1;
    }

    private void removeListener(ZoneSetListener zoneSetListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            return;
        }
        if (this.listeners.contains(zoneSetListener)) {
            this.listeners.remove(zoneSetListener);
        }
    }

    public void addListener(ZoneSetListener zoneSetListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(zoneSetListener)) {
            this.listeners.add(zoneSetListener);
        }
    }

    private void fireEvent(ZoneSetEvent zoneSetEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ZoneSetListener zoneSetListener = (ZoneSetListener)this.listeners.elementAt(n);
            zoneSetListener.zoneSetChanged(zoneSetEvent);
            ++n;
        }
    }

    public boolean getDirtyFlag() {
        int n = 0;
        while (n < this.zones.size()) {
            Zone zone = (Zone)this.zones.elementAt(n);
            if (zone.getDirtyFlag()) {
                return true;
            }
            ++n;
        }
        return this.dirtyFlag;
    }

    protected void resetDirtyFlag() {
        this.dirtyFlag = false;
    }

    void setName(String string) {
        this.name = string;
        this.dirtyFlag = true;
        this.fireEvent(new ZoneSetEvent(this, null, 3));
    }

    public String getName() {
        return this.name;
    }

    public boolean getIsOrphanZoneSet() {
        return this.orphanZoneSet;
    }

    public Zone findZone(String string) {
        Zone zone = this.getFirstZone();
        while (zone != null) {
            if (zone.getName().equals(string)) {
                return zone;
            }
            zone = this.getNextZone(zone);
        }
        return null;
    }

    public Zone getFirstZone() {
        if (this.zones.size() > 0) {
            return (Zone)this.zones.elementAt(0);
        }
        return null;
    }

    public Zone getNextZone(Zone zone) {
        int n;
        if (this.zones.size() > 0 && (n = this.getZoneIndex(zone)) >= 0 && n + 1 < this.zones.size()) {
            return (Zone)this.zones.elementAt(n + 1);
        }
        return null;
    }

    public int getMembersInSet() {
        int n = 0;
        Zone zone = this.getFirstZone();
        while (zone != null) {
            n += zone.getMembersInZone();
            zone = this.getNextZone(zone);
        }
        return n;
    }

    public int getNumberOfZones() {
        return this.zones.size();
    }

    int addZone(Zone zone) {
        return this.addZone(zone, true);
    }

    int indexToInsert(Zone zone) {
        Zone zone2;
        if (this.zones.size() == 0) {
            return 0;
        }
        int n = 0;
        int n2 = this.zones.size() - 1;
        while (n2 - n > 1) {
            int n3 = (n + n2) / 2;
            zone2 = (Zone)this.zones.elementAt(n3);
            if (zone.compareTo(zone2) < 0) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        if (n2 != n) {
            Zone zone3 = (Zone)this.zones.elementAt(n);
            if (zone.compareTo(zone3) < 0) {
                return n;
            }
            zone2 = (Zone)this.zones.elementAt(n2);
            if (zone.compareTo(zone2) > 0) {
                return n2 + 1;
            }
            return n2;
        }
        Zone zone4 = (Zone)this.zones.elementAt(n2);
        if (zone.compareTo(zone4) < 0) {
            return n2;
        }
        return n2 + 1;
    }

    int addZone(Zone zone, boolean bl) {
        if (this.getZoneIndex(zone) < 0) {
            this.dirtyFlag = true;
            int n = this.indexToInsert(zone);
            this.zones.insertElementAt(zone, n);
            if (!this.orphanZoneSet) {
                if (zone.isOrphanZone()) {
                    this.zoneDb.getOrphanZoneSet().removeZone(zone);
                }
                zone.addedToSet();
            }
            if (bl) {
                this.fireEvent(new ZoneSetEvent(this, zone, 1));
            }
            return 0;
        }
        return 108;
    }

    void resortZone(Zone zone) {
        int n = this.getZoneIndex(zone);
        this.zones.remove(n);
        this.zones.insertElementAt(zone, this.indexToInsert(zone));
        this.fireEvent(new ZoneSetEvent(this, this, zone));
    }

    protected void removeAllZones() {
        Zone zone = this.getFirstZone();
        while (zone != null) {
            this.removeZone(zone);
            zone = this.getFirstZone();
        }
    }

    public int removeZone(Zone zone) {
        if (this.getZoneIndex(zone) >= 0) {
            this.dirtyFlag = true;
            this.zones.remove(zone);
            if (!this.orphanZoneSet) {
                zone.removedFromSet();
                if (zone.isOrphanZone()) {
                    this.zoneDb.getOrphanZoneSet().addZone(zone, false);
                    this.fireEvent(new ZoneSetEvent(this, this.zoneDb.getOrphanZoneSet(), zone));
                    return 0;
                }
            }
            this.fireEvent(new ZoneSetEvent(this, zone, 2));
            return 0;
        }
        return 107;
    }

    public int getZoneIndex(Zone zone) {
        return Collections.binarySearch(this.zones, zone);
    }

    public String toString() {
        String string = DeviceUtilities.getResource("ZoneSet.zoneSet") + " " + this.name;
        return string;
    }

    void setActive(boolean bl) {
        this.active = bl;
        this.dirtyFlag = true;
        this.fireEvent(new ZoneSetEvent(this, null, 3));
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean equals(Object object) {
        ZoneSet zoneSet;
        return object instanceof ZoneSet && this.name.equals((zoneSet = (ZoneSet)object).getName());
    }
}

