/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgVersionReq
extends UtilMessage {
    int flashRevision = 0;
    int promHardwareVersion = 0;
    int promSoftwareVersion = 0;
    int flashSoftwareVersion = 0;
    int numberOfQuadrants = 0;
    int chassisType = 0;
    int chassisNumber = 0;
    int topology = 0;
    int stageType = 0;
    int fabricId = 0;
    long WWName = 0L;
    int moduleAddress = 0;
    int systemConfigRegister = 0;
    byte[] macAddress = null;
    boolean securityOn;
    private static final int VR_FLASH_VERSION_OFFSET = 4;
    private static final int VR_PROM_VERSION_OFFSET = 8;
    private static final int VR_PROM_SOFTWARE_VERSION_OFFSET = 12;
    private static final int VR_FLASH_SOFTWARE_VERSION_OFFSET = 16;
    private static final int VR_NUMBER_OF_QUADRANTS_OFFSET = 20;
    private static final int VR_CHASSIS_TYPE_OFFSET = 24;
    private static final int VR_CHASSIS_NUMBER_OFFSET = 28;
    private static final int VR_TOPOLOGY_OFFSET = 32;
    private static final int VR_FABRIC_ID_OFFSET = 36;
    private static final int VR_MODULE_ADDRESS_OFFSET = 40;
    private static final int VR_WW_NAME_OFFSET = 44;
    private static final int VR_SYSTEM_CONFIG_REGISTER_OFFSET = 52;
    private static final int VR_MAC_ADDRESS_OFFSET = 56;
    private static final int VR_SECURITY_OFFSET = 62;
    private static final int VR_REQ_DATA_LENGTH = 0;
    private static final int VR_RESP_DATA_LENGTH = 68;
    private static final int VR_REQ_COMMAND = 7;

    public UtilMsgVersionReq(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 7, utilEventListener, 0);
    }

    public UtilMsgVersionReq(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl) {
        super(utilDestination, 7, utilEventListener, 0, bl);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        this.command = 7;
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean sendEvenIfUnreachable() {
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length == 68) {
            this.flashRevision = UtilMessage.decodeInt(byArray, 4);
            this.promHardwareVersion = UtilMessage.decodeInt(byArray, 8);
            this.promSoftwareVersion = UtilMessage.decodeInt(byArray, 12);
            this.flashSoftwareVersion = UtilMessage.decodeInt(byArray, 16);
            this.numberOfQuadrants = UtilMessage.decodeInt(byArray, 20);
            this.chassisType = UtilMessage.decodeInt(byArray, 24);
            this.chassisNumber = UtilMessage.decodeInt(byArray, 28);
            this.stageType = UtilMessage.decodeInt(byArray, 32);
            this.fabricId = UtilMessage.decodeInt(byArray, 36);
            this.WWName = UtilMessage.decodeLong(byArray, 44);
            this.moduleAddress = UtilMessage.decodeInt(byArray, 40);
            this.systemConfigRegister = UtilMessage.decodeInt(byArray, 52);
            this.macAddress = new byte[6];
            UtilMessage.byteCopy(this.macAddress, 0, byArray, 56, 6);
            this.securityOn = (byArray[62] & 0x80) == 128;
            return true;
        }
        this.setStatus(105);
        return false;
    }

    private String IntToRevString(int n) {
        byte by = (byte)(n & 0xFF);
        byte by2 = (byte)(n >> 8 & 0xFF);
        byte by3 = (byte)(n >> 16 & 0xFF);
        byte by4 = (byte)(n >> 24 & 0xFF);
        return new String("v" + by4 + "." + by3 + "." + by2 + "." + by);
    }

    public int getFlashRevision() {
        return this.flashRevision;
    }

    public int getPromHardwareVersion() {
        return this.promHardwareVersion;
    }

    public int getPromSoftwareVersion() {
        return this.promSoftwareVersion;
    }

    public int getFlashSoftwareVersion() {
        return this.flashSoftwareVersion;
    }

    public int getChassisType() {
        return this.chassisType;
    }

    public int getChassisNumber() {
        return this.chassisNumber;
    }

    public int getStageType() {
        return this.stageType;
    }

    public int getFabricId() {
        return this.fabricId;
    }

    public long getWWName() {
        return this.WWName;
    }

    public int getModuleAddress() {
        return this.moduleAddress;
    }

    public int getSystemConfigRegister() {
        return this.systemConfigRegister;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public boolean getSecurityOn() {
        return this.securityOn;
    }

    public String toString() {
        String string = super.toString();
        string = string + new String("VERSION REQUEST\nflashRevision = " + this.IntToRevString(this.getFlashRevision()) + "\n" + "promHardwareVersion = " + this.IntToRevString(this.getPromHardwareVersion()) + "\n" + "promSoftwareVersion = " + this.IntToRevString(this.getPromSoftwareVersion()) + "\n" + "flashSoftwareVersion = " + this.IntToRevString(this.getFlashSoftwareVersion()) + "\n" + "chassisType = " + this.chassisType + "\n" + "chassisNumber = " + this.chassisNumber + "\n" + "stageType = " + this.stageType + "\n" + "fabricId = " + this.fabricId + "\n" + "WWName = " + Long.toHexString(this.WWName) + "\n" + "moduleAddress = " + Integer.toHexString(this.moduleAddress) + "\n" + "systemConfigRegister = " + Integer.toHexString(this.systemConfigRegister) + "\n" + "macAddress = " + UtilMessage.byteToStr(this.macAddress) + "\n");
        return string;
    }
}

