/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgTraceRequest
extends UtilMessage {
    public static final int MAX_ENTRIES = 240;
    private static final int TR_COMMAND = 9;
    private static final int TR_OFFSET_OFFSET = 0;
    private static final int TR_ENTRY_COUNT_OFFSET = 2;
    private static final int TR_DATA_OFFSET = 4;
    private static final int TR_REQ_DATA_LENGTH = 4;
    private static final int TR_RESP_DATA_LENGTH = 484;
    int offset;
    int entryCountReq;
    int entryCountRecv;
    byte[] data;

    public UtilMsgTraceRequest(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, int n2) {
        super(utilDestination, 9, utilEventListener, 4);
        this.offset = n;
        this.entryCountReq = n2;
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeShort(this.offset, this.dataBuffer, n + 0);
        UtilMessage.encodeShort(this.entryCountReq, this.dataBuffer, n + 2);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (byArray.length < 4) {
                this.setStatus(105);
                return false;
            }
            short s = UtilMessage.decodeShort(byArray, 0);
            if (s != this.offset) {
                this.setStatus(105);
                return false;
            }
            this.entryCountRecv = UtilMessage.decodeShort(byArray, 2);
            if (this.entryCountRecv > this.entryCountReq) {
                this.setStatus(105);
                return false;
            }
        } else {
            this.setStatus(105);
            return false;
        }
        this.data = new byte[this.entryCountRecv * 2];
        UtilMessage.byteCopy(this.data, 0, byArray, 4, this.entryCountRecv * 2);
        return true;
    }

    public int getEntryCountReq() {
        return this.entryCountReq;
    }

    public int getEntryCountRecv() {
        return this.entryCountRecv;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return super.toString() + new String("RESET SWITCH\n");
    }
}

