/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgSnmpCommunities
extends UtilMessage {
    String readCommunity;
    String writeCommunity;
    String trapCommunity;
    private static final int READ_COMMUNITY_OFFSET = 0;
    private static final int WRITE_COMMUNITY_OFFSET = 64;
    private static final int TRAP_COMMUNITY_OFFSET = 128;
    private static final int SC_GET_DATA_LENGTH = 0;
    private static final int SC_RESP_DATA_LENGTH = 192;
    private static final int SC_SET_DATA_LENGTH = 192;
    private static final int UM_SET_SNMP_COMMUNITIES = 136;
    private static final int UM_GET_SNMP_COMMUNITIES = 140;

    public UtilMsgSnmpCommunities() {
        super(null, 136, null, 192);
    }

    public UtilMsgSnmpCommunities(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 140, utilEventListener, 0);
    }

    public boolean setSetCommand() {
        this.command = 136;
        this.setDataLength(192);
        return true;
    }

    public boolean setGetCommand() {
        this.command = 140;
        this.setDataLength(0);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.command == 136;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        if (this.command == 136) {
            int n = this.getSendPayloadDataOffset();
            UtilMessage.encodeString(this.readCommunity, this.dataBuffer, n + 0, 64);
            UtilMessage.encodeString(this.writeCommunity, this.dataBuffer, n + 64, 64);
            UtilMessage.encodeString(this.trapCommunity, this.dataBuffer, n + 128, 64);
            this.encodeAndCalcCheckSum();
        }
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length == 192) {
            this.readCommunity = UtilMessage.decodeString(byArray, 0, 64);
            this.writeCommunity = UtilMessage.decodeString(byArray, 64, 64);
            this.trapCommunity = UtilMessage.decodeString(byArray, 128, 64);
            return true;
        }
        return false;
    }

    public String getReadCommunity() {
        return this.readCommunity;
    }

    public void setReadCommunity(String string) {
        this.readCommunity = string;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public void setWriteCommunity(String string) {
        this.writeCommunity = string;
    }

    public String getTrapCommunity() {
        return this.trapCommunity;
    }

    public void setTrapCommunity(String string) {
        this.trapCommunity = string;
    }

    public String toString() {
        return super.toString() + new String("SET SNMP COMMUNITY STRINGS: \nreadCommunity=" + this.readCommunity + "\nwriteCommunity=" + this.writeCommunity + "\ntrapCommunity=" + this.trapCommunity);
    }
}

