/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.SmlError;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.util.StringUtilities;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class UtilMsgSml
extends UtilMessage {
    public static final int SML_OK = 0;
    private int groupKey = -1;
    private int port = -1;
    protected static final int UM_SML_GET_COMMAND = 1024;
    protected static final int UM_SML_SET_COMMAND = 1025;
    protected static final int UM_SML_NOTIFY_COMMAND = 1026;
    protected static final int UM_STR_DATA_OFFSET = 0;
    protected static final int MAX_SML_COMMAND = 1399;
    protected static final int DEF_SML_SBUFF_ALLOC = 349;
    private Vector requestStrings = new Vector();
    private StringBuffer responseStr;
    private Vector responses = new Vector();
    private int nextCommandToPack = 0;
    private boolean sendEvenIfUnreachable = false;
    private byte[] requests = new byte[1399];
    private static byte SEMI = ";".getBytes()[0];

    public UtilMsgSml(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 1024, utilEventListener, 0);
        this.clearCommands();
    }

    public boolean sendEvenIfUnreachable() {
        return this.sendEvenIfUnreachable;
    }

    public void sendEvenIfUnreachable(boolean bl) {
        this.sendEvenIfUnreachable = bl;
    }

    public ErrorType getErrorType() {
        ErrorType errorType = super.getErrorType();
        if (errorType == null && !this.AllResponsesOk()) {
            int n = 0;
            while (n < this.getNumberOfResponses()) {
                if (this.getResponse(n).getErrorCode() != 0) {
                    return new SmlError(this.getResponse(n).getErrorCode());
                }
                ++n;
            }
        }
        return errorType;
    }

    public static InetAddress smlStrToIpAdress(String string) {
        InetAddress inetAddress;
        Long l = Long.decode("0x" + string);
        String string2 = UtilMessage.ipConvert(l.intValue());
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public void setGroupKey(int n) {
        this.groupKey = n;
    }

    public int getGroupKey() {
        return this.groupKey;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void clearCommands() {
        this.requestStrings = new Vector();
        this.responses = new Vector();
    }

    public void addSmlCommands(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.addSmlCommand((String)vector.elementAt(n));
            ++n;
        }
    }

    public boolean AllResponsesOk() {
        if (this.getStatus() == 108) {
            return false;
        }
        int n = 0;
        while (n < this.responses.size()) {
            SmlResponse smlResponse = this.getResponse(n);
            if (smlResponse.getErrorCode() != 0 && smlResponse.getErrorCode() != 27 && smlResponse.getErrorCode() != 74 && smlResponse.getErrorCode() != 103 && smlResponse.getErrorCode() != 82 && smlResponse.getErrorCode() != 52 && smlResponse.getErrorCode() != 54 && smlResponse.getErrorCode() != 57 && smlResponse.getErrorCode() != 60 && smlResponse.getErrorCode() != 69 && smlResponse.getErrorCode() != 79) {
                return false;
            }
            ++n;
        }
        return this.responses.size() == this.requestStrings.size();
    }

    public void addSmlCommand(String string) {
        this.requestStrings.add(string);
    }

    public void removeSmlCommand(String string) {
        if (this.requestStrings.contains(string)) {
            this.requestStrings.remove(string);
        }
    }

    public int getNumberOfRequests() {
        return this.requestStrings.size();
    }

    public SmlRequest getRequest(int n) {
        String string = (String)this.requestStrings.elementAt(n);
        return new SmlRequest(string);
    }

    public SmlResponse getResponse(int n) {
        return (SmlResponse)this.responses.elementAt(n);
    }

    public String getResponseStr() {
        return this.responseStr == null ? null : this.responseStr.toString();
    }

    public int getNumberOfResponses() {
        return this.responses.size();
    }

    public boolean getIsSetCommand() {
        return this.command == 1025;
    }

    public boolean getIsNotifyCommand() {
        return this.command == 1026;
    }

    public boolean setGetCommand() {
        this.command = 1024;
        return true;
    }

    public boolean setSetCommand() {
        this.command = 1025;
        return true;
    }

    public boolean setNotifyCommand() {
        this.command = 1026;
        return true;
    }

    public boolean pack() {
        int n = 0;
        int n2 = this.nextCommandToPack;
        int n3 = this.requestStrings.size();
        while (n2 < n3) {
            byte[] byArray = ((String)this.requestStrings.get(n2)).getBytes();
            if (byArray.length + n + 1 > 1399) break;
            if (n > 0) {
                this.requests[n++] = SEMI;
            }
            System.arraycopy(byArray, 0, this.requests, n, byArray.length);
            n += byArray.length;
            ++n2;
        }
        this.setDataLength(n + 1);
        if (!super.pack()) {
            return false;
        }
        int n4 = this.getSendPayloadDataOffset() + 0;
        System.arraycopy(this.requests, 0, this.dataBuffer, n4, n);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        byte[] byArray;
        if (this.command != 1026) {
            if (!super.unpack()) {
                return false;
            }
        } else {
            this.setStatus(103);
        }
        if ((byArray = super.getResponsePayloadData()) != null && byArray.length > 0) {
            String string = UtilMessage.decodeString(byArray, 0, byArray.length);
            if (this.responseStr != null) {
                this.responseStr.append(";");
            } else {
                this.responseStr = new StringBuffer(349);
            }
            this.responseStr.append(string);
            boolean bl = false;
            int n = -1;
            boolean bl2 = false;
            while (!bl) {
                int n2 = string.indexOf(59, n + 1);
                if (n2 > 0) {
                    this.responses.add(new SmlResponse(string.substring(n + 1, n2)));
                    bl2 = true;
                    n = n2;
                    continue;
                }
                if (n2 == -1 && n + 1 < string.length()) {
                    this.responses.add(new SmlResponse(string.substring(n + 1)));
                    bl2 = true;
                }
                bl = true;
            }
            if (bl2) {
                if (this.requestStrings.size() > this.responses.size()) {
                    this.sendAgain = true;
                    this.seqNumber = -1;
                    this.assignSeqNumber();
                    this.nextCommandToPack = this.responses.size();
                } else {
                    this.sendAgain = false;
                }
            }
            return bl2;
        }
        this.setStatus(105);
        return false;
    }

    void setDataLength(int n) {
        super.setDataLength(n);
    }

    public String getDataTransfered() {
        byte[] byArray;
        UtilDestination utilDestination = this.destination;
        StringBuffer stringBuffer = new StringBuffer(500 + this.requestStrings.size() * 80);
        stringBuffer.append(" Class=" + this.getClass() + " status=" + this.getStatus() + " error code =" + this.getErrorCode() + " getErrorCodeStr=" + this.getErrorCodeStr());
        if (utilDestination != null) {
            stringBuffer.append(" dest.toString=" + utilDestination.toString() + " dest=" + utilDestination.getClass().getName() + "@" + Integer.toHexString(utilDestination.hashCode()) + " dest.fcaddr=" + Integer.toHexString(this.destination.getFcAddress()) + " dest.isReachable=" + this.destination.isReachable());
        } else {
            stringBuffer.append(" dest=null");
        }
        stringBuffer.append(" sendEvenIfUnreachable=" + this.sendEvenIfUnreachable() + " AllResponsesOk=" + this.AllResponsesOk() + " getGroupKey=" + this.getGroupKey() + " getListener=" + this.getListener() + " getErrorCodeStr=" + this.getErrorCodeStr() + " getExpectReply=" + this.getExpectReply() + " getSendAgain=" + this.getSendAgain() + " getTimeoutValue=" + this.getTimeoutValue());
        int n = 0;
        while (n < this.requestStrings.size()) {
            stringBuffer.append(" sml" + n + "=" + this.requestStrings.elementAt(n));
            ++n;
        }
        if (this.sendPacket != null) {
            stringBuffer.append(" ip addr=" + this.sendPacket.getAddress().getHostAddress());
            byArray = this.sendPacket.getData();
            if (byArray != null) {
                stringBuffer.append(" data sent= " + StringUtilities.byteArrayToString(byArray, 0, byArray.length, "."));
            } else {
                stringBuffer.append(" data sent= null");
            }
            stringBuffer.append(" sml=");
            int n2 = 0;
            while (n2 < this.requestStrings.size()) {
                stringBuffer.append((String)this.requestStrings.elementAt(n2));
                if (n2 != this.requestStrings.size() - 1) {
                    stringBuffer.append(";");
                }
                ++n2;
            }
        } else {
            stringBuffer.append(" No data sent ");
        }
        if (this.receivePacket != null) {
            byArray = this.getResponseData();
            if (byArray != null) {
                stringBuffer.append(" data returned= " + StringUtilities.byteArrayToString(byArray, 0, this.receivePacket.getLength(), "."));
            } else {
                stringBuffer.append(" data returned= null");
            }
            stringBuffer.append(" sml=" + this.responseStr);
        } else {
            stringBuffer.append(" No data received ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        Object object;
        String string = super.toString();
        int n = 0;
        while (n < this.requestStrings.size()) {
            string = string + (String)this.requestStrings.elementAt(n);
            if (n != this.requestStrings.size() - 1) {
                string = string + ";";
            }
            ++n;
        }
        String string2 = new String();
        int n2 = 0;
        while (n2 < this.responses.size()) {
            object = this.getResponse(n2);
            string2 = string2 + ((SmlResponse)object).getResponse() + "#0x" + Integer.toHexString(((SmlResponse)object).getErrorCode());
            if (n2 != this.responses.size() - 1) {
                string2 = string2 + ";";
            }
            ++n2;
        }
        object = new String("SML " + this.requestStrings.size() + " requests with " + this.responses.size() + " responses \n" + string + " resp=" + this.responseStr);
        return object;
    }

    public class SmlResponse {
        String response;
        int errorCode;

        public SmlResponse(String string) {
            int n = string.indexOf(35);
            if (n < 0) {
                this.errorCode = -1;
                this.response = string;
            } else {
                this.response = string.substring(0, n);
                this.errorCode = Integer.parseInt(string.substring(n + 1), 16);
            }
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getResponse() {
            return this.response;
        }
    }

    public class SmlRequest {
        String request;

        public SmlRequest(String string) {
            this.request = string;
        }

        public String getReqStr() {
            return this.request;
        }

        public String getRequestWord(int n) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.request.indexOf(46, n2);
                if (n5 < 0) {
                    return null;
                }
                n2 = n5 + 1;
                ++n4;
            }
            n3 = this.request.indexOf(46, n2);
            if (n3 < 0) {
                n3 = this.request.length();
            }
            String string = this.request.substring(n2, n3);
            return string;
        }
    }
}

