/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgSensorStatus
extends UtilMsgConfig {
    int sensorCount = 0;
    byte[] sensorIndex = new byte[MAX_SENSOR_COUNT];
    byte[] sensorStatus = new byte[MAX_SENSOR_COUNT];
    byte[] sensorType = new byte[MAX_SENSOR_COUNT];
    int temp1 = 0;
    int temp2 = 0;
    int temp3 = 0;
    private static int MAX_SENSOR_COUNT = 12;
    private static int SENSOR_COUNT_OFFSET = 0;
    private static int SENSOR_TABLE_OFFSET = 4;
    private static int SENSOR_DATA_OFFSET = 16;
    private static int TEMP_ONE_OFFSET = 64;
    private static int TEMP_TWO_OFFSET = 68;
    private static int TEMP_THREE_OFFSET = 72;
    private static int POWER_SUPPLY_1 = 0;
    private static int POWER_SUPPLY_2 = 1;
    private static int FAN_1 = 2;
    private static int FAN_2 = 3;
    private static int FAN_3 = 4;
    private static int TEMP_1 = 5;
    private static int TEMP_2 = 6;
    private static int TEMP_3 = 7;
    private static int TEMP_4 = 8;
    private static int TEMP_5 = 9;
    private static int TEMP_6 = 10;
    public static final byte SENSOR_STATUS_UNKNOWN = 1;
    public static final byte SENSOR_STATUS_OTHER = 2;
    public static final byte SENSOR_STATUS_OK = 3;
    public static final byte SENSOR_STATUS_WARNING = 4;
    public static final byte SENSOR_STATUS_FAILED = 5;
    public static final byte SENSOR_STATUS_NOT_PRESENT = 6;
    private static final int REQ_DATA_LENGTH = 0;
    private static final int RESP_DATA_LENGTH = 76;
    private static final int REQ_EXT_COMMAND = 512;

    public UtilMsgSensorStatus(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 0, 512);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        return super.pack();
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 76) {
            this.sensorCount = byArray[SENSOR_COUNT_OFFSET];
            int n = 0;
            while (n < MAX_SENSOR_COUNT) {
                this.sensorIndex[n] = byArray[SENSOR_TABLE_OFFSET + n];
                this.sensorStatus[n] = byArray[SENSOR_DATA_OFFSET + n * 4];
                this.sensorType[n] = byArray[SENSOR_DATA_OFFSET + (n * 4 + 3)];
                ++n;
            }
            this.temp1 = UtilMessage.decodeInt(byArray, TEMP_ONE_OFFSET);
            this.temp2 = UtilMessage.decodeInt(byArray, TEMP_TWO_OFFSET);
            this.temp3 = UtilMessage.decodeInt(byArray, TEMP_THREE_OFFSET);
            return true;
        }
        this.setStatus(105);
        return false;
    }

    public int getPowerSupplyOneStatus() {
        byte by = this.sensorIndex[POWER_SUPPLY_1];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getPowerSupplyTwoStatus() {
        byte by = this.sensorIndex[POWER_SUPPLY_2];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getFanOneStatus() {
        byte by = this.sensorIndex[FAN_1];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getFanTwoStatus() {
        byte by = this.sensorIndex[FAN_2];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getFanThreeStatus() {
        byte by = this.sensorIndex[FAN_3];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getTempOneStatus() {
        byte by = this.sensorIndex[TEMP_1];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getTempTwoStatus() {
        byte by = this.sensorIndex[TEMP_2];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getTempThreeStatus() {
        byte by = this.sensorIndex[TEMP_3];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.sensorStatus[by];
    }

    public int getTempOne() {
        byte by = this.sensorIndex[TEMP_1];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.temp1;
    }

    public int getTempTwo() {
        byte by = this.sensorIndex[TEMP_2];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.temp2;
    }

    public int getTempThree() {
        byte by = this.sensorIndex[TEMP_3];
        if (by == MAX_SENSOR_COUNT) {
            return 6;
        }
        return this.temp3;
    }

    public String toString() {
        String string = super.toString() + new String("SENSOR STATUS REQUEST\n");
        return string;
    }
}

