/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLT;

public class UtilMsgOLTStatus
extends UtilMsgOLT {
    private static final int FIRST_PORT_OFFSET = 0;
    private static final int NUM_PORTS_OFFSET = 1;
    private static final int TOTAL_PORTS_OFFSET = 2;
    private static final int TOTAL_FAIL_COUNT_OFFSET = 4;
    private static final int TEST_STATUS_OFFSET = 8;
    private static final int TEST_COUNT_OFFSET = 24;
    private static final int FAIL_COUNT_OFFSET = 88;
    private static final int DATA_OFFSET = 4;
    private static final int REQ_DATA_LENGTH = 4;
    private static final int RESP_DATA_LENGTH = 152;
    private static final int EXT_COMMAND = 10;
    private int firstPort = 0;
    private int numPorts;
    private int totalPorts;
    private int totalFailCount;
    private int[] testStatus;
    private int[] testCount;
    private int[] failCount;

    public UtilMsgOLTStatus(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 4, 10);
    }

    public UtilMsgOLTStatus() {
        super(null, null, 4, 10);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return true;
    }

    public boolean pack() {
        if (this.extCommand == 0) {
            this.extCommand = 10;
        }
        this.setDataLength(4);
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = (byte)this.firstPort;
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length > 88) {
            this.firstPort = byArray[0];
            this.numPorts = byArray[1];
            this.totalPorts = byArray[2];
            this.totalFailCount = UtilMessage.decodeInt(byArray, 4);
            this.testStatus = new int[16];
            int n = 0;
            while (n < 16) {
                this.testStatus[n] = byArray[8 + n];
                ++n;
            }
            this.testCount = new int[16];
            int n2 = 0;
            while (n2 < 16) {
                this.testCount[n2] = UtilMessage.decodeInt(byArray, 24 + n2 * 4);
                ++n2;
            }
            this.failCount = new int[16];
            int n3 = 0;
            while (n3 < 16) {
                this.failCount[n3] = UtilMessage.decodeInt(byArray, 88 + n3 * 4);
                ++n3;
            }
            return true;
        }
        this.setStatus(105);
        return false;
    }

    public int getFirstPort() {
        return this.firstPort;
    }

    public void setFirstPort(int n) {
        this.firstPort = n;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public int getTotalPorts() {
        return this.totalPorts;
    }

    public int getTotalFailCount() {
        return this.totalFailCount;
    }

    public int getFailCount(int n) {
        if (this.failCount != null && this.failCount.length > n) {
            return this.failCount[n];
        }
        return -1;
    }

    public int getTestCount(int n) {
        if (this.testCount != null && this.testCount.length > n) {
            return this.testCount[n];
        }
        return -1;
    }

    public int getTestStatus(int n) {
        if (this.testStatus != null && this.testStatus.length > n) {
            return this.testStatus[n];
        }
        return -1;
    }

    public String toString() {
        String string = super.toString() + new String("OLT TEST STATUS: ");
        return string;
    }
}

