/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.net.InetAddress;
import java.util.Vector;

public class UtilMsgNameServerInfoSml
extends UtilMsgSml {
    int portId;
    int portNumber = -1;
    String domainId;
    String portType;
    WorldWideName portWwn;
    String symPortName;
    WorldWideName nodeWwn;
    String symNodeName;
    InetAddress nodeIpAddress;
    Vector classOfService;
    InetAddress portIpAddress;
    WorldWideName fabricWwn;
    int[] fc4TypeBitMap;
    String fc4Descriptors;
    String targetInitiator;
    int ttl;
    int scanNumber;
    private static final String reqNoIdString = new String("Oper.NameServer");
    private static final String reqString = new String("Oper.NameServerAll.");
    private static final String entryString = new String(".Entry.");

    public UtilMsgNameServerInfoSml(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, int n, int n2, boolean bl) {
        super(utilDestination, utilEventListener);
        this.clearCommands();
        this.domainId = string;
        this.portId = n;
        this.scanNumber = n2;
        String string2 = string != null ? reqString + string : reqNoIdString;
        string2 = string2 + entryString + Integer.toHexString(this.portId) + ".";
        this.addSmlCommand(string2 + "PortType");
        this.addSmlCommand(string2 + "PortWwn");
        this.addSmlCommand(string2 + "SymPortName");
        this.addSmlCommand(string2 + "NodeWwn");
        this.addSmlCommand(string2 + "SymNodeName");
        this.addSmlCommand(string2 + "NodeIPAddress");
        this.addSmlCommand(string2 + "COSList");
        this.addSmlCommand(string2 + "PortIPAddress");
        this.addSmlCommand(string2 + "FabricPortName");
        this.addSmlCommand(string2 + "FC4TypeBitMap");
        this.addSmlCommand(string2 + "FC4DescrList");
        if (bl) {
            this.addSmlCommand(string2 + "FC4PortRole");
        }
    }

    public String getDomainIdString() {
        return this.domainId;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        int n = 0;
        while (n < this.getNumberOfResponses()) {
            UtilMsgSml.SmlResponse smlResponse = this.getResponse(n);
            if (smlResponse.getErrorCode() != 0) {
                this.setStatus(105);
            } else {
                String string = smlResponse.getResponse();
                switch (n) {
                    case 0: {
                        this.portType = string;
                        break;
                    }
                    case 1: {
                        this.portWwn = new WorldWideName(string);
                        break;
                    }
                    case 2: {
                        this.symPortName = string;
                        break;
                    }
                    case 3: {
                        this.nodeWwn = new WorldWideName(string);
                        break;
                    }
                    case 4: {
                        this.symNodeName = string;
                        break;
                    }
                    case 5: {
                        this.nodeIpAddress = UtilMsgSml.smlStrToIpAdress(string);
                        break;
                    }
                    case 6: {
                        this.classOfService = new Vector();
                        while (string != null) {
                            int n2 = string.indexOf(44);
                            String string2 = null;
                            if (n2 < 0) {
                                string2 = string;
                                string = null;
                            } else {
                                string2 = string.substring(0, n2);
                                string = string.substring(n2 + 1);
                            }
                            int n3 = Integer.parseInt(string2);
                            this.classOfService.add(new Integer(n3));
                        }
                        break;
                    }
                    case 7: {
                        this.portIpAddress = UtilMsgSml.smlStrToIpAdress(string);
                        break;
                    }
                    case 8: {
                        this.fabricWwn = new WorldWideName(string);
                        break;
                    }
                    case 9: {
                        this.fc4TypeBitMap = this.hexStr2IntArray(string);
                        break;
                    }
                    case 10: {
                        if (string == null || string.length() <= 0 || string.equals("(NULL)")) break;
                        this.fc4Descriptors = string;
                        break;
                    }
                    case 11: {
                        if (string == null || string.length() <= 0 || string.equals("(NULL)")) break;
                        this.targetInitiator = string;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public int getPortId() {
        return this.portId;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public WorldWideName getPortWwn() {
        return this.portWwn;
    }

    public String getSymPortName() {
        return this.symPortName;
    }

    public WorldWideName getNodeWwn() {
        return this.nodeWwn;
    }

    public String getSymNodeName() {
        return this.symNodeName;
    }

    public InetAddress getNodeIpAddress() {
        return this.nodeIpAddress;
    }

    public Vector getClassOfService() {
        return this.classOfService;
    }

    public InetAddress getPortIpAddress() {
        return this.portIpAddress;
    }

    public String getPortType() {
        return this.portType;
    }

    public WorldWideName getFabricWwn() {
        return this.fabricWwn;
    }

    public int[] getFc4TypeBitMap() {
        return this.fc4TypeBitMap;
    }

    public String getFc4Descriptors() {
        return this.fc4Descriptors;
    }

    public String getTargetInitiator() {
        return this.targetInitiator;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getScanNumber() {
        return this.scanNumber;
    }

    private int[] hexStr2IntArray(String string) {
        int[] nArray = new int[8];
        int n = 0;
        while (n < 64) {
            nArray[n / 8] = Integer.parseInt(string.substring(n, n + 8), 16);
            n += 8;
        }
        return nArray;
    }

    public String toString() {
        return super.toString() + "UtilMsgNextNsPortId";
    }
}

