/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UtilMsgIpConfigSml
extends UtilMsgSml {
    private static final int MAX_IP_LENGTH = 8;
    InetAddress address;
    int mask;
    int broadcast;
    InetAddress gateway;
    int useBootp;
    int arpTimeout;

    public UtilMsgIpConfigSml(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl, IPInfo iPInfo) {
        super(utilDestination, utilEventListener);
        this.clearCommands();
        String string = "Config.System.";
        if (!bl) {
            this.addSmlCommand(string + "IPAddress");
            this.addSmlCommand(string + "IPMask");
            this.addSmlCommand(string + "GatewayAddr");
            this.addSmlCommand(string + "Discovery");
        } else {
            this.addSmlCommand("Cmd.Switch.ReqAdmin");
            this.addSmlCommand("Cmd.System.StartSetup");
            this.addSmlCommand(string + "IPAddress." + Sanbox2Sml.padIPAddr(iPInfo.getIpAddress()));
            this.addSmlCommand(string + "IPMask." + Sanbox2Sml.padIPAddr(Integer.toHexString(iPInfo.getNetMask())));
            this.addSmlCommand(string + "GatewayAddr." + Sanbox2Sml.padIPAddr(iPInfo.getGateway()));
            this.addSmlCommand(string + "Discovery." + this.translateNetworkDiscovery(iPInfo.getIpBootProcess()));
            this.addSmlCommand("Cmd.System.SaveSetup");
            this.addSmlCommand("Cmd.System.ActSetup");
            this.addSmlCommand("Cmd.Switch.RelAdmin");
            this.address = iPInfo.getIpAddress();
            this.mask = iPInfo.getNetMask();
            this.gateway = iPInfo.getGateway();
            this.useBootp = iPInfo.getIpBootProcess();
            this.arpTimeout = iPInfo.getArpTimeout();
            this.setSetCommand();
            this.setTimeoutValue(3000);
        }
    }

    private int translateNetworkDiscovery(String string) {
        if (string.equals("Static")) {
            return 0;
        }
        if (string.equals("Bootp")) {
            return 1;
        }
        if (string.equals("Dhcp")) {
            return 3;
        }
        if (string.equals("Rarp")) {
            return 2;
        }
        return -1;
    }

    private String translateNetworkDiscovery(int n) {
        if (n == 0) {
            return "Static";
        }
        if (n == 1) {
            return "Bootp";
        }
        if (n == 3) {
            return "Dhcp";
        }
        if (n == 2) {
            return "Rarp";
        }
        return "Static";
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        if (this.AllResponsesOk()) {
            if (!this.getIsSetCommand()) {
                IPInfo iPInfo = new IPInfo();
                try {
                    this.address = InetAddress.getByName(UtilMessage.ipConvert(Long.decode("0x" + this.getResponse(0).getResponse()).intValue()));
                    this.mask = Long.decode("0x" + this.getResponse(1).getResponse()).intValue();
                    this.gateway = InetAddress.getByName(UtilMessage.ipConvert(Long.decode("0x" + this.getResponse(2).getResponse()).intValue()));
                    this.useBootp = this.translateNetworkDiscovery(this.getResponse(3).getResponse());
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        } else {
            this.setStatus(105);
        }
        return true;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getMask() {
        return this.mask;
    }

    public int getBroadcast() {
        return this.broadcast;
    }

    public InetAddress getGateway() {
        return this.gateway;
    }

    public int getUseBootp() {
        return this.useBootp;
    }

    public int getArpTimeout() {
        return this.arpTimeout;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setMask(int n) {
        this.mask = n;
    }

    public void setBroadcast(int n) {
        this.broadcast = n;
    }

    public void setGateway(InetAddress inetAddress) {
        this.gateway = inetAddress;
    }

    public void setUseBootp(int n) {
        this.useBootp = n;
    }

    public void setArpTimeout(int n) {
        this.arpTimeout = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "IP CONFIG ");
        stringBuffer.append(this.getIsSetCommand() ? "SET\n" : "GET\n");
        if (this.address == null) {
            stringBuffer.append("address = null\n");
        } else {
            stringBuffer.append("address = " + this.address.getHostAddress() + "\n");
        }
        stringBuffer.append("mask = " + Integer.toHexString(this.mask) + "\n");
        stringBuffer.append("broadcast = " + Integer.toHexString(this.broadcast) + "\n");
        if (this.gateway == null) {
            stringBuffer.append("gateway = null\n");
        } else {
            stringBuffer.append("gateway = " + this.gateway + "\n");
        }
        stringBuffer.append("useBootp = " + this.useBootp + "\n");
        stringBuffer.append("arpTimeout = " + this.arpTimeout + "\n");
        return stringBuffer.toString();
    }
}

