/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;
import java.util.Vector;

public class UtilMsgGetZoneSetList
extends UtilMsgConfig {
    byte startIndex;
    Vector zoneSetList = null;
    boolean endOfData = true;
    private static final int GZSL_START_INDEX_OFFSET = 0;
    private static final int GZSL_NUMBER_OF_SETS_OFFSET = 1;
    private static final int GZSL_END_OF_DATA = 2;
    private static final int GZSL_ZONE_SET_LIST_OFFSET = 4;
    private static final int GZSL_ZONE_SET_LIST_STATUS_OFFSET = 439;
    private static final int GZSL_ZONE_SET_LENGTH = 72;
    private static final int GZSL_ZONE_SET_NAME_LENGTH = 64;
    private static final int GZSL_REQ_DATA_LENGTH = 4;
    private static final int GZSL_RESP_DATA_LENGTH = 440;
    private static final int GZSL_EXT_COMMAND = 771;
    private static final int MAX_ZONE_SET_ENTRY_PER_UTIL_MSG = 6;

    public UtilMsgGetZoneSetList(UtilDestination utilDestination, UtilEventListener utilEventListener, byte by) {
        super(utilDestination, utilEventListener, 4, 771);
        this.startIndex = by;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = this.startIndex;
        this.dataBuffer[n + 1] = 6;
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (byArray.length == 440) {
                if (this.startIndex != byArray[0]) {
                    this.setStatus(105);
                    return false;
                }
                if (byArray[439] < 20) {
                    int n = byArray[1];
                    this.zoneSetList = new Vector();
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = UtilMessage.decodeInt(byArray, 4 + n2 * 72);
                        byte by = byArray[4 + n2 * 72 + 4];
                        String string = UtilMessage.decodeString(byArray, 4 + n2 * 72 + 8, 64);
                        this.zoneSetList.add(string);
                        ++n2;
                    }
                } else {
                    this.setStatus(105);
                    return false;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    public String getZoneSet(int n) {
        if (this.zoneSetList == null || n < 0 || n > this.zoneSetList.size() - 1) {
            return null;
        }
        return (String)this.zoneSetList.elementAt(n);
    }

    public int getNumberOfZoneSets() {
        return this.zoneSetList.size();
    }

    public boolean getEndOfData() {
        return this.endOfData;
    }

    public int getStartIndex() {
        return this.startIndex;
    }
}

