/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgFlashLoad
extends UtilMessage {
    public static final int FLASH_LOAD_CMD = 14;
    public static final int DEF_BUF_LEN = 256;
    public static final int FIRST_PKT_TOV = 2000;
    public static final int SEQ_NUM_OFFSET = 0;
    public static final int BUF_LEN_OFFSET = 2;
    public static final int TOTAL_LEN_OFFSET = 4;
    public static final int BUFFER_OFFSET = 8;
    public static final int DEF_DATA_LEN = 264;
    private byte[] buffer;
    private int seqNum;
    private int totalLen;
    private int bufLen = 256;

    public UtilMsgFlashLoad() {
        super(null, 14, null, 264);
    }

    public UtilMsgFlashLoad(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, int n2) {
        super(utilDestination, 14, utilEventListener, 8 + n2);
        this.setTotalLen(n);
        this.setBufLen(n2);
    }

    public boolean setSetCommand() {
        return true;
    }

    public boolean setGetCommand() {
        return false;
    }

    public boolean getIsSetCommand() {
        return true;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeShort(this.seqNum, this.dataBuffer, n + 0);
        UtilMessage.encodeShort(this.bufLen, this.dataBuffer, n + 2);
        UtilMessage.encodeInt(this.totalLen, this.dataBuffer, n + 4);
        UtilMessage.encodeBytes(this.buffer, this.dataBuffer, n + 8);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        return this.getStatus() == 103;
    }

    public void setBuffer(byte[] byArray) {
        this.buffer = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.buffer, 0, this.buffer.length);
    }

    public void setSeqNum(int n) {
        this.seqNum = n;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setTotalLen(int n) {
        this.totalLen = n;
    }

    public int getTotalLen() {
        return this.totalLen;
    }

    public void setBufLen(int n) {
        this.bufLen = n;
    }

    public int getBufLen() {
        return this.bufLen;
    }
}

