/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.EPortEntry;
import com.qlogic.device.fcfabric.EPortEntryList;
import com.qlogic.device.fcfabric.EPortLink;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgEPortTopology
extends UtilMsgConfig {
    private static final byte EXT_COMMAND = 17;
    private static final int REQ_DATA_LENGTH = 8;
    private static final int RESPONSE_DATA_LENGTH = 60;
    private static final int DOMAIN_RECORD_LENGTH = 24;
    private static final int LINK_RECORD_LENGTH = 12;
    private int startDomain;
    private short startLink;
    private static final int REQ_START_DOMAIN_OFFSET = 0;
    private static final int REQ_START_LINK_OFFSET = 4;
    private int reportingDomainId;
    private int fabricIncarnation;
    private long principalWWName;
    private int grantedDomainBitmap;
    private short moreDomains;
    private int length;
    private EPortEntryList lsdb = new EPortEntryList();
    private static final int REPORTING_DOMAIN_ID_OFFSET = 0;
    private static final int FABRIC_INCARNATION_OFFSET = 4;
    private static final int PRINCIPAL_WWNAME_OFFSET = 8;
    private static final int BITMAP_OFFSET = 16;
    private static final int RESPONSE_START_DOMAIN_OFFSET = 48;
    private static final int RESPONSE_START_LINK_OFFSET = 52;
    private static final int MORE_DOMAINS_OFFSET = 54;
    private static final int LENGTH_OFFSET = 56;
    private static final int WWNAME_OFFSET = 0;
    private static final int DOMAIN_ID_OFFSET = 8;
    private static final int INCARNATION_OFFSET = 12;
    private static final int AGE_OFFSET = 16;
    private static final int NUM_LINKS_OFFSET = 18;
    private static final int DOMAIN_TYPE_OFFSET = 20;
    private static final int HOPS_OFFSET = 21;
    private static final int NUM_RECORDS_OFFSET = 22;
    private static final int NEIGHBOR_DOMAIN_OFFSET = 0;
    private static final int LINK_TYPE_OFFSET = 4;
    private static final int LOCAL_PORT_OFFSET = 6;
    private static final int REMOTE_PORT_OFFSET = 7;
    private static final int COST_OFFSET = 10;

    public UtilMsgEPortTopology(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 8, 17);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        this.setDataLength(8);
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeInt(this.startDomain, this.dataBuffer, n + 0);
        UtilMessage.encodeShort(this.startLink, this.dataBuffer, n + 4);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray == null || byArray.length < 60) {
            this.setStatus(105);
            return false;
        }
        try {
            this.reportingDomainId = UtilMessage.decodeInt(byArray, 0);
            this.fabricIncarnation = UtilMessage.decodeInt(byArray, 4);
            this.principalWWName = UtilMessage.decodeLong(byArray, 8);
            this.grantedDomainBitmap = UtilMessage.decodeInt(byArray, 16);
            this.startDomain = UtilMessage.decodeInt(byArray, 48);
            this.startLink = UtilMessage.decodeShort(byArray, 52);
            this.moreDomains = UtilMessage.decodeShort(byArray, 54);
            this.length = UtilMessage.decodeInt(byArray, 56);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException);
            System.err.println("UtilMsgEPortTopology: failed unpacking response header");
            this.setStatus(105);
            return false;
        }
        int n = this.length - 60;
        int n2 = 60;
        while (n > 0) {
            int n3;
            int n4;
            byte by;
            short s;
            short s2;
            int n5;
            int n6;
            long l;
            try {
                l = UtilMessage.decodeLong(byArray, 0 + n2);
                n6 = UtilMessage.decodeInt(byArray, 8 + n2);
                n5 = UtilMessage.decodeInt(byArray, 12 + n2);
                s2 = UtilMessage.decodeShort(byArray, 16 + n2);
                s = UtilMessage.decodeShort(byArray, 18 + n2);
                by = byArray[20 + n2];
                n4 = byArray[21 + n2];
                n3 = UtilMessage.decodeShort(byArray, 22 + n2);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.err.println("UtilMsgEPortTopology: failed unpacking domain record");
                this.setStatus(105);
                return false;
            }
            EPortEntry ePortEntry = new EPortEntry();
            ePortEntry.setWWName(new WorldWideName(l));
            ePortEntry.setDomainId(n6);
            ePortEntry.setIncarnation(n5);
            ePortEntry.setAge(s2);
            ePortEntry.setLinkCount(s);
            ePortEntry.setType(by);
            ePortEntry.setHops(n4 >= 0 ? n4 : n4 + 256);
            ePortEntry.setRecordCount(n3);
            this.lsdb.add(ePortEntry);
            n -= 24;
            n2 += 24;
            int n7 = 0;
            while (n7 < n3) {
                if (ePortEntry.getHops() < 255) {
                    short s3;
                    byte by2;
                    byte by3;
                    byte by4;
                    int n8;
                    try {
                        n8 = UtilMessage.decodeInt(byArray, 0 + n2);
                        by4 = byArray[4 + n2];
                        by3 = byArray[6 + n2];
                        by2 = byArray[7 + n2];
                        s3 = UtilMessage.decodeShort(byArray, 10 + n2);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                        System.err.println("UtilMsgEPortTopology: failed unpacking link record");
                        this.setStatus(105);
                        return false;
                    }
                    EPortLink ePortLink = new EPortLink(n8);
                    ePortLink.setDomainId(n6);
                    ePortLink.setType(by4);
                    ePortLink.setLocalPort(by3);
                    ePortLink.setRemotePort(by2);
                    ePortLink.setCost(s3);
                    ePortEntry.addLink(ePortLink);
                }
                n -= 12;
                n2 += 12;
                ++n7;
            }
        }
        return true;
    }

    public int getStartDomain() {
        return this.startDomain;
    }

    public void setStartDomain(int n) {
        this.startDomain = n;
    }

    public short getStartLink() {
        return this.startLink;
    }

    public void setStartLink(short s) {
        this.startLink = s;
    }

    public int getReportingDomainId() {
        return this.reportingDomainId;
    }

    public int getFabricIncarnation() {
        return this.fabricIncarnation;
    }

    public long getPrincipalWWName() {
        return this.principalWWName;
    }

    public int getGrantedDomainBitmap() {
        return this.grantedDomainBitmap;
    }

    public short getMoreDomains() {
        return this.moreDomains;
    }

    public int getLength() {
        return this.length;
    }

    public EPortEntryList getEPortList() {
        return this.lsdb;
    }

    public int getEPortEntryCount() {
        return this.lsdb.size();
    }

    public String toString() {
        String string = super.toString() + new String("E-PORT TOPOLOGY\nstartDomain = " + this.startDomain + " startLink = " + this.startLink + "\nreportingDomainId=" + this.reportingDomainId + " principalWWName=" + Long.toHexString(this.principalWWName) + "\nfabricIncarnation=" + this.fabricIncarnation + " moreDomains=" + this.moreDomains + "\nlength=" + this.length + "\n");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("Lsdb Table:\n");
        int n = this.lsdb.size();
        int n2 = 0;
        while (n2 < n) {
            EPortEntry ePortEntry = (EPortEntry)this.lsdb.elementAt(n2);
            stringBuffer.append(ePortEntry.toString() + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

