/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgAllAdminPortSpeedsReq
extends UtilMsgConfig {
    byte numberOfPorts;
    byte[] portSpeeds = null;
    private static final int GPS_NUMBER_OF_PORTS_OFFSET = 0;
    private static final int GPS_PORT_SPEEDS_OFFSET = 4;
    private static final int GPS_EXT_COMMAND = 114;
    private static final int GPS_REQ_DATA_LENGTH = 0;

    public UtilMsgAllAdminPortSpeedsReq(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 0, 114);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        return super.pack();
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 0) {
            this.numberOfPorts = byArray[0];
            if (byArray.length >= 4 + this.numberOfPorts) {
                this.portSpeeds = new byte[this.numberOfPorts];
                int n = 0;
                while (n < this.numberOfPorts) {
                    this.portSpeeds[n] = byArray[4 + n];
                    ++n;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public int getPortSpeed(int n) {
        if (this.portSpeeds == null || n < 0 || n >= this.portSpeeds.length) {
            return -1;
        }
        return this.portSpeeds[n];
    }

    public byte[] getPortSpeedArrayCopy() {
        byte[] byArray = new byte[this.portSpeeds.length];
        System.arraycopy(this.portSpeeds, 0, byArray, 0, this.portSpeeds.length);
        return byArray;
    }

    public String toString() {
        String string = super.toString() + new String("GET ALL ADMIN PORT SPEEDS\nnumberOfPorts = " + this.numberOfPorts + "\n");
        string = string + new String("Speeds = ");
        int n = 0;
        while (n < this.numberOfPorts) {
            string = string + new String(this.portSpeeds[n] + ",");
            ++n;
        }
        string = string + "\n";
        return string;
    }
}

