/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;
import java.util.Vector;

public class UtilMsgAddMembersToZone
extends UtilMsgConfig {
    String zoneName;
    Vector members;
    byte seqNumber;
    byte zoneStatus = 0;
    boolean endOfMembers;
    private static final int AMZ_ZONE_NAME_LENGTH_OFFSET = 0;
    private static final int AMZ_ZONE_NAME_OFFSET = 4;
    private static final int AMZ_MEMBERS_OFFSET = 68;
    private static final int AMZ_NUMBER_OF_MEMBERS_OFFSET = 476;
    private static final int AMZ_END_OF_MEMBERS_OFFSET = 480;
    private static final int AMZ_STATUS_OFFSET = 481;
    private static final int AMZ_SEQ_NUM_OFFSET = 482;
    private static final int AMZ_ZONE_NAME_LENGTH = 64;
    private static final int AMZ_ZONE_LENGTH = 68;
    private static final int AMZ_MEMBER_LENGTH = 12;
    private static final int AMZ_MEMBER_NAME_LENGTH = 8;
    public static final int AMZ_MAX_ZONE_CHANGE_MEMBERS_PER_UTIL_MSG = 34;
    private static final int AMZ_REQ_DATA_LENGTH = 484;
    private static final int AMZ_RESP_DATA_LENGTH = 484;
    private static final int AMZ_EXT_COMMAND = 784;
    private static final int MEMBER_TYPE_N_PORT_NAME = 1;
    private static final int MEMBER_TYPE_DOMAIN_ID_PORT = 2;
    private static final int MEMBER_TYPE_N_PORT_ADDRESS_ID = 3;
    private static final int MEMBER_TYPE_NODE_NAME = 4;

    public UtilMsgAddMembersToZone(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, Vector vector, byte by, boolean bl) {
        super(utilDestination, utilEventListener, 484, 784);
        this.zoneName = string;
        this.members = vector;
        this.seqNumber = by;
        this.endOfMembers = bl;
    }

    public boolean getIsSetCommand() {
        return true;
    }

    public boolean setGetCommand() {
        return false;
    }

    public boolean setSetCommand() {
        return true;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        if (this.members.size() > 34) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = (byte)this.zoneName.length();
        UtilMessage.encodeString(this.zoneName, this.dataBuffer, n + 4, 65);
        int n2 = 0;
        while (n2 < this.members.size()) {
            int n3 = n + 68 + n2 * 12;
            String string = (String)this.members.elementAt(n2);
            byte[] byArray = this.strToByteArray(string);
            switch (byArray.length) {
                case 8: {
                    this.dataBuffer[n3] = 1;
                    UtilMessage.byteCopy(this.dataBuffer, n3 + 4, byArray, 0, 8);
                    break;
                }
                case 3: {
                    this.dataBuffer[n3] = 3;
                    UtilMessage.byteCopy(this.dataBuffer, n3 + 5, byArray, 0, 3);
                    break;
                }
                case 2: {
                    this.dataBuffer[n3] = 2;
                    byte by = byArray[0];
                    byte by2 = byArray[1];
                    UtilMessage.encodeShort(by2, this.dataBuffer, n3 + 4);
                    this.dataBuffer[n3 + 6] = by;
                }
            }
            ++n2;
        }
        UtilMessage.encodeInt(this.members.size(), this.dataBuffer, n + 476);
        this.dataBuffer[n + 480] = this.endOfMembers ? (byte)1 : 0;
        this.dataBuffer[n + 481] = 0;
        this.dataBuffer[n + 482] = this.seqNumber;
        this.encodeAndCalcCheckSum();
        return true;
    }

    private byte[] strToByteArray(String string) {
        if (string.length() % 2 == 1) {
            string = "0" + string;
        }
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            String string2 = "0x" + string.substring(n2 * 2, n2 * 2 + 2);
            byArray[n2] = (byte)Integer.decode(string2).intValue();
            --n2;
        }
        return byArray;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (byArray.length == 484) {
                String string = UtilMessage.decodeString(byArray, 4, 64);
                if (!string.equals(this.zoneName)) {
                    this.setStatus(105);
                    return false;
                }
                this.zoneStatus = byArray[481];
                if (this.zoneStatus >= 20) {
                    this.setStatus(105);
                    return false;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public byte getZoneStatus() {
        return this.zoneStatus;
    }

    public byte getSeqNumber() {
        return this.seqNumber;
    }

    public Vector getMemberList() {
        return this.members;
    }

    public String toString() {
        String string = super.toString() + new String("Add members to zone = " + this.zoneName + " members=");
        int n = 0;
        while (n < this.members.size()) {
            string = string + (String)this.members.elementAt(n);
            if (n != this.members.size() - 1) {
                string = string + ",";
            }
            ++n;
        }
        return string;
    }
}

