/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.UtilError;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilPacket;
import com.qlogic.util.StringUtilities;
import java.net.InetAddress;

public abstract class UtilMessage {
    private static final int UM_MAX_SEQ_NUMBER = Integer.MAX_VALUE;
    private static final int UM_PORT = 5000;
    private static final int UM_STANDARD_HEADER_LENGTH_VERSION_BYTE_0 = 17;
    private static final int UM_STANDARD_HEADER_LENGTH_VERSION_BYTE_1 = 0;
    private static final int UM_VERSION0_HEADER_LENGTH_VERSION_BYTE_0 = 0;
    private static final int UM_VERSION0_HEADER_LENGTH_VERSION_BYTE_1 = 0;
    protected static final int UM_HEADER_0 = 0;
    protected static final int UM_HEADER_1 = 1;
    protected static final int UM_STATUS_FLAG = 2;
    protected static final int UM_CONTROL_FLAG = 3;
    protected static final int UM_DESTINATION_ADDRESS = 4;
    protected static final int UM_STAGE_TYPES = 4;
    protected static final int UM_COMMAND_CODE = 8;
    protected static final int UM_DATA_LENGTH = 10;
    protected static final int UM_SEQUENCE_CODE = 12;
    protected static final int UM_DATA_V1 = 16;
    protected static final int UM_DATA_V0 = 12;
    protected static final int UM_VERSION1_HEADER_LENGTH = 16;
    protected static final int UM_VERSION0_HEADER_LENGTH = 12;
    protected static int MAX_TRIES = 1;
    protected static final int FIXED_SEQ_NUMBER = 1;
    private static int nextSeqNumber = 2;
    protected long fcAddress;
    protected byte[] dataBuffer;
    protected UtilEventListener listener;
    protected UtilDestination destination;
    protected int command;
    protected int msgLength = 0;
    protected int dataLength = 0;
    protected int seqNumber = -1;
    protected UtilPacket sendPacket;
    protected UtilPacket receivePacket;
    protected int messageStatus = 100;
    protected int errorCode = 0;
    protected boolean sendAgain = false;
    protected boolean expectReply = true;
    protected int waitAfterSend = 0;
    protected int timeoutValue = 2000;
    protected long timeSent = 0L;
    private Object key;
    private static byte[] tempBuffer = new byte[2];

    public UtilMessage(UtilDestination utilDestination, int n, UtilEventListener utilEventListener, int n2) {
        this.listener = utilEventListener;
        this.destination = utilDestination;
        this.setDataLength(n2);
        this.command = n;
    }

    public UtilMessage(UtilDestination utilDestination, int n, UtilEventListener utilEventListener, int n2, boolean bl) {
        this.listener = utilEventListener;
        this.destination = utilDestination;
        this.setDataLength(n2);
        this.command = n;
        if (bl) {
            this.seqNumber = 1;
        }
    }

    public String toString() {
        String string = "UtilMessage =" + this.getClass() + " Status =" + this.messageStatus + " fcaddr=" + this.fcAddress + "error code=" + this.errorCode + "seqNum=" + this.seqNumber;
        return string;
    }

    public ErrorType getErrorType() {
        int n;
        switch (this.getStatus()) {
            case 104: {
                n = this.getErrorCode();
                break;
            }
            case 103: {
                return null;
            }
            default: {
                n = this.getStatus();
            }
        }
        return new UtilError(n);
    }

    public String getDataTransfered() {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        UtilDestination utilDestination = this.destination;
        String string = new String(" Class=" + this.getClass() + " status=" + this.getStatus() + " error code =" + this.getErrorCode() + " getErrorCodeStr=" + this.getErrorCodeStr() + " dest.toString=" + this.destination.toString() + " dest=" + utilDestination.getClass().getName() + "@" + Integer.toHexString(utilDestination.hashCode()) + " dest.fcaddr=" + Integer.toHexString(this.destination.getFcAddress()) + " dest.isReachable=" + this.destination.isReachable() + " sendEvenIfUnreachable=" + this.sendEvenIfUnreachable() + " getListener=" + this.getListener() + " getExpectReply=" + this.getExpectReply() + " getSendAgain=" + this.getSendAgain() + " getTimeoutValue=" + this.getTimeoutValue());
        if (this.sendPacket != null) {
            string = string + " ip addr=" + this.sendPacket.getAddress().getHostAddress();
            string = string + " data sent= ";
            byArray = this.sendPacket.getData();
            n3 = this.sendPacket.getLength();
            n2 = 0;
            while (n2 < n3) {
                n = 16;
                if (n2 + n > n3) {
                    n = n3 - n2;
                }
                string = string + StringUtilities.byteArrayToString(byArray, n2, n, ".");
                string = string + "  ";
                n2 += 16;
            }
        }
        if (this.receivePacket != null) {
            string = string + "data returned= ";
            byArray = this.receivePacket.getData();
            n3 = this.receivePacket.getLength();
            n2 = 0;
            while (n2 < n3) {
                n = 16;
                if (n2 + n > n3) {
                    n = n3 - n2;
                }
                string = string + StringUtilities.byteArrayToString(byArray, n2, n, ".");
                string = string + "  ";
                n2 += 16;
            }
        }
        return string;
    }

    boolean getSendAgain() {
        return this.sendAgain;
    }

    public Object getKey() {
        if (this.key == null) {
            this.key = new Integer(this.destination.getFcAddress());
        }
        return this.key;
    }

    void setDataLength(int n) {
        this.dataLength = n + 4;
        if (this.dataLength % 4 != 0) {
            this.dataLength += 4 - this.dataLength % 4;
        }
        this.dataBuffer = new byte[this.dataLength + 16];
    }

    UtilDestination getDestination() {
        return this.destination;
    }

    UtilPacket getReceivePacket() {
        return this.receivePacket;
    }

    public void setSendPacket(UtilPacket utilPacket) {
        this.sendPacket = utilPacket;
    }

    public void setReceivePacket(UtilPacket utilPacket) {
        this.receivePacket = utilPacket;
    }

    public int getSendFcAddr() {
        int n = UtilMessage.decodeInt(this.dataBuffer, 4);
        return n;
    }

    public abstract boolean setSetCommand();

    public abstract boolean setGetCommand();

    public abstract boolean getIsSetCommand();

    public boolean unpack() {
        byte[] byArray = this.getResponseData();
        if (byArray != null && byArray.length >= 12) {
            if (this.dataBuffer[0] != byArray[0]) {
                this.setStatus(105);
                return false;
            }
            short s = UtilMessage.decodeShort(this.dataBuffer, 8);
            if (s != this.command) {
                this.setStatus(105);
                return false;
            }
            if (this.dataBuffer[0] == 17) {
                if (byArray.length < 16) {
                    this.setStatus(105);
                    return false;
                }
                int n = UtilMessage.decodeInt(byArray, 12);
                if (n != this.seqNumber) {
                    this.setStatus(106);
                    return false;
                }
            }
            this.errorCode = byArray[2];
            if (this.errorCode != 0) {
                this.setStatus(104);
                return false;
            }
            this.setStatus(103);
            return true;
        }
        return false;
    }

    public boolean sendEvenIfUnreachable() {
        return false;
    }

    public boolean pack() {
        if (this.destination.getFcAddress() == 0 || !this.sendEvenIfUnreachable() && !this.destination.isReachable()) {
            this.setStatus(108);
            this.errorCode = 0;
            return false;
        }
        if (this.destination.useVersion_0()) {
            this.dataBuffer[0] = 0;
            this.dataBuffer[1] = 0;
            this.dataBuffer[2] = 0;
            this.dataBuffer[3] = 0;
            UtilMessage.encodeInt(this.destination.getFcAddress(), this.dataBuffer, 4);
            UtilMessage.encodeShort(this.dataLength, this.dataBuffer, 10);
            UtilMessage.encodeShort(this.command, this.dataBuffer, 8);
            this.msgLength = this.dataLength + 12 - 4;
        } else {
            this.dataBuffer[0] = 17;
            this.dataBuffer[1] = 0;
            this.dataBuffer[2] = 0;
            this.dataBuffer[3] = 0;
            UtilMessage.encodeInt(this.destination.getFcAddress(), this.dataBuffer, 4);
            UtilMessage.encodeShort(this.dataLength, this.dataBuffer, 10);
            UtilMessage.encodeShort(this.command, this.dataBuffer, 8);
            this.assignSeqNumber();
            UtilMessage.encodeInt(this.seqNumber, this.dataBuffer, 12);
            this.msgLength = this.dataLength + 16 - 4;
        }
        this.encodeAndCalcCheckSum();
        this.setStatus(101);
        return true;
    }

    protected void assignSeqNumber() {
        if (this.seqNumber == -1) {
            this.seqNumber = nextSeqNumber++;
        }
        if (nextSeqNumber == Integer.MAX_VALUE) {
            nextSeqNumber = 2;
        }
    }

    public int getRecvSeqNumber() {
        byte[] byArray = this.getResponseData();
        if (byArray != null) {
            int n = UtilMessage.decodeInt(byArray, 12);
            return n;
        }
        return 0;
    }

    public int getRecvCommandCode() {
        byte[] byArray = this.getResponseData();
        if (byArray != null) {
            short s = UtilMessage.decodeShort(byArray, 8);
            return s;
        }
        return 0;
    }

    int getSequenceNumber() {
        return this.seqNumber;
    }

    protected void encodeAndCalcCheckSum() {
        UtilMessage.encodeInt(UtilMessage.calcCheckSum(this.dataBuffer, this.msgLength), this.dataBuffer, this.msgLength);
    }

    public byte getResponseStatusFlag() {
        byte[] byArray = this.getResponseData();
        if (byArray != null) {
            return byArray[2];
        }
        return -1;
    }

    public byte getResponseControlFlag() {
        byte[] byArray = this.getResponseData();
        if (byArray != null) {
            return byArray[3];
        }
        return 0;
    }

    public byte[] getResponsePayloadData() {
        byte[] byArray = this.getResponseData();
        if (byArray != null) {
            int n = UtilMessage.decodeShort(byArray, 10) - 4;
            if (n > 0) {
                byte[] byArray2 = new byte[n];
                switch (byArray[0] & 0xF0) {
                    case 16: {
                        int n2 = 0;
                        while (n2 < n) {
                            byArray2[n2] = byArray[16 + n2];
                            ++n2;
                        }
                        break;
                    }
                    case 0: {
                        int n3 = 0;
                        while (n3 < n) {
                            byArray2[n3] = byArray[12 + n3];
                            ++n3;
                        }
                        break;
                    }
                    default: {
                        byArray2 = null;
                        return null;
                    }
                }
                return byArray2;
            }
            return null;
        }
        return null;
    }

    public int getSendPayloadDataOffset() {
        int n = UtilMessage.decodeShort(this.dataBuffer, 10) - 4;
        if (n > 0) {
            switch (this.dataBuffer[0] & 0xF0) {
                case 16: {
                    return 16;
                }
                case 0: {
                    return 12;
                }
            }
            return -1;
        }
        return -1;
    }

    public int getResponseDataLength() {
        byte[] byArray = this.getResponseData();
        return UtilMessage.getResponseDataLength(byArray);
    }

    public static int getResponseDataLength(byte[] byArray) {
        if (byArray != null) {
            return UtilMessage.decodeShort(byArray, 10) - 4;
        }
        return 0;
    }

    public byte[] getResponseData() {
        if (this.receivePacket != null) {
            return this.receivePacket.getData();
        }
        return null;
    }

    public int getResponseFcAddress() {
        byte[] byArray = this.getResponseData();
        if (byArray != null) {
            int n = UtilMessage.decodeInt(byArray, 4);
            int n2 = n & 0xF0000000;
            n &= 0xFFFFFF;
            return n |= (n2 >>= 4);
        }
        return 0;
    }

    public void setStatus(int n) {
        this.messageStatus = n;
    }

    public int getStatus() {
        return this.messageStatus;
    }

    protected byte[] getBuffer() {
        return this.dataBuffer;
    }

    protected int getBufferLength() {
        return this.msgLength;
    }

    private static int calcCheckSum(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n < byArray.length ? n : byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = byArray[n4];
            n2 += n5 < 0 ? n5 + 256 : n5;
            ++n4;
        }
        return n2;
    }

    public UtilEventListener getListener() {
        return this.listener;
    }

    void setListener(UtilEventListener utilEventListener) {
        this.listener = utilEventListener;
    }

    void setDestination(UtilDestination utilDestination) {
        this.destination = utilDestination;
        this.key = null;
        this.getKey();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorCodeStr() {
        switch (this.errorCode) {
            case 0: {
                return "NO ERRORS";
            }
            case 1: {
                return "UNKNOWN MESSAGE ERROR";
            }
            case 2: {
                return "BAD DATA ERROR";
            }
            case 3: {
                return "FLASH LOAD FAIL";
            }
            case 4: {
                return "MKII INTERNAL ERROR";
            }
            case 5: {
                return "LOGIN BUSY";
            }
            case 6: {
                return "REJECTED NOT ONLINE";
            }
            case 7: {
                return "REJECTED PORT INCORRECT STATE";
            }
            case 8: {
                return "REJECTED ANOTHER TEST ACTIVE";
            }
            case 9: {
                return "CPU NOT ABLE TO PERFORM";
            }
            case 10: {
                return "SAVED DATA INVALID";
            }
            case 11: {
                return "ZONING DATA INVALID";
            }
            case 12: {
                return "UNABLE TO ROUTE";
            }
            case 13: {
                return "EC_VERSION_NOT_SUPPORTED";
            }
            case 14: {
                return "EC_LOGIN_REQUIRED";
            }
            case 15: {
                return "EC_NO_ENTRY_SWITCH_SESSION";
            }
            case 16: {
                return "EC_NON_QLOGIC_QWITCH";
            }
        }
        return "Invalid error code = " + this.errorCode;
    }

    public boolean getExpectReply() {
        return this.expectReply;
    }

    public void setExpectReply(boolean bl) {
        this.expectReply = bl;
    }

    public int getWaitAfterSend() {
        return this.waitAfterSend;
    }

    public void setWaitAfterSend(int n) {
        this.waitAfterSend = n;
    }

    public long getTimeSent() {
        return this.timeSent;
    }

    public void setTimeSent(long l) {
        this.timeSent = l;
    }

    public int getTimeoutValue() {
        return this.timeoutValue;
    }

    public void setTimeoutValue(int n) {
        this.timeoutValue = n;
    }

    public String rawDataString() {
        byte[] byArray = this.getResponsePayloadData();
        String string = new String("Raw data=");
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                string = string + "[" + Integer.toHexString(byArray[n]) + "]";
                ++n;
            }
        }
        return string;
    }

    public static int inetToIp(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        int n = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
        return n;
    }

    public static String ipConvert(long l) {
        return new String("" + (l >> 24 & 0xFFL) + "." + (l >> 16 & 0xFFL) + "." + (l >> 8 & 0xFFL) + "." + (l & 0xFFL));
    }

    public static String ipConvert(int n) {
        return new String("" + (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF));
    }

    public static String byteToStr(byte[] byArray) {
        String string = new String("");
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                string = string + "[" + Integer.toHexString(byArray[n]) + "]";
                ++n;
            }
        } else {
            string = new String("null");
        }
        return string;
    }

    public static void byteCopy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        System.arraycopy(byArray2, n2, byArray, n, n3);
    }

    public static String decodeString(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n + n3] == 0) break;
            ++n3;
        }
        return new String(byArray, n, n3);
    }

    public static void decodeByteArray(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n + n3];
            ++n3;
        }
    }

    public static long decodeLong(byte[] byArray, int n) {
        long l = ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n] & 0x7FL) << 56);
        return l;
    }

    public static long decodeUnsignedInt(byte[] byArray, int n) {
        long l = ((long)byArray[n + 3] & 0xFFL) + (((long)byArray[n + 2] & 0xFFL) << 8) + (((long)byArray[n + 1] & 0xFFL) << 16) + (((long)byArray[n] & 0xFFL) << 24);
        return l;
    }

    public static long decodeUnsignedInt(int[] nArray, int n) {
        long l = (((long)nArray[n] & 0xFFFFL) << 16) + ((long)nArray[n + 1] & 0xFFFFL);
        return l;
    }

    public static int decodeInt(byte[] byArray, int n) {
        int n2 = (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n] & 0xFF) << 24);
        return n2;
    }

    public static int decodeInt(int[] nArray, int n) {
        int n2 = ((nArray[n] & 0xFFFF) << 16) + (nArray[n + 1] & 0xFFFF);
        return n2;
    }

    public static int decodeInt24(byte[] byArray, int n) {
        int n2 = (byArray[n + 2] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 16);
        return n2;
    }

    public static int decodeUnsignedShort(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) + ((byArray[n] & 0xFF) << 8);
        return n2;
    }

    public static short decodeShort(byte[] byArray, int n) {
        short s = (short)((byArray[n + 1] & 0xFF) + ((byArray[n] & 0xFF) << 8));
        return s;
    }

    public static int decodeByte(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public static void encodeString(String string, byte[] byArray, int n, int n2) {
        int n3 = string.length();
        if (n3 >= n2 - 1) {
            n3 = n2 - 1;
        }
        int n4 = 0;
        while (n4 < n3) {
            byArray[n + n4] = (byte)(string.charAt(n4) & 0xFF);
            ++n4;
        }
        while (n4 < n2) {
            byArray[n + n4] = 0;
            ++n4;
        }
    }

    public static void encodeBytes(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[n + n2] = byArray[n2];
            ++n2;
        }
    }

    public static void encodeLong(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >> 56 & 0xFFL);
        byArray[n + 1] = (byte)(l >> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l >> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l & 0xFFL);
    }

    public static void encodeUnsignedInt(long l, byte[] byArray, int n) {
        byArray[3 + n] = (byte)(l & 0xFFL);
        byArray[2 + n] = (byte)(l >> 8 & 0xFFL);
        byArray[1 + n] = (byte)(l >> 16 & 0xFFL);
        byArray[n] = (byte)(l >> 24 & 0xFFL);
    }

    public static void encodeIntArray(int[] nArray, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            UtilMessage.encodeInt(nArray[n2], byArray, n + n2 * 4);
            ++n2;
        }
    }

    public static void decodeIntArray(int[] nArray, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = UtilMessage.decodeInt(byArray, n + n2 * 4);
            ++n2;
        }
    }

    public static void encodeInt(int n, byte[] byArray, int n2) {
        byArray[3 + n2] = (byte)(n & 0xFF);
        byArray[2 + n2] = (byte)(n >> 8 & 0xFF);
        byArray[1 + n2] = (byte)(n >> 16 & 0xFF);
        byArray[n2] = (byte)(n >> 24 & 0xFF);
    }

    public static void encodeShort(int n, byte[] byArray, int n2) {
        byArray[1 + n2] = (byte)(n & 0xFF);
        byArray[n2] = (byte)(n / 256 & 0xFF);
    }

    public static void encodeByte(byte by, byte[] byArray, int n) {
        byArray[n] = by;
    }
}

