/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.User;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ComAgentEvent;
import com.qlogic.device.fcfabric.event.ComAgentEventListener;
import com.qlogic.device.fcfabric.util.messages.TCPAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessageParallelQueue;
import com.qlogic.device.fcfabric.util.messages.UtilMsgActivateZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgActiveTLConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAddMembersToZone;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAddZonesToZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAllActiveAdminPortTypes;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAllAdminPortSpeedsReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAllPortsStates;
import com.qlogic.device.fcfabric.util.messages.UtilMsgBeaconSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgBeaconStatusReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgChassisMode;
import com.qlogic.device.fcfabric.util.messages.UtilMsgChassisStatusReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgClearZoning;
import com.qlogic.device.fcfabric.util.messages.UtilMsgCommitZoning;
import com.qlogic.device.fcfabric.util.messages.UtilMsgCreateZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgDelayedSwReset;
import com.qlogic.device.fcfabric.util.messages.UtilMsgEPortIsolationReason;
import com.qlogic.device.fcfabric.util.messages.UtilMsgEPortTopology;
import com.qlogic.device.fcfabric.util.messages.UtilMsgFlashLoad;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetActiveZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetAllPortCounters;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetAllSwitchInternalCounters;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetTimeStamp;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZoneMembers;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZoneSetList;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZonesInAZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZoningConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgIpConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgLoginRequest;
import com.qlogic.device.fcfabric.util.messages.UtilMsgMemoryWrite;
import com.qlogic.device.fcfabric.util.messages.UtilMsgModelCfgReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNameServerGetAllNextFabricUnzoned;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTReset;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTStart;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTStatus;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTStop;
import com.qlogic.device.fcfabric.util.messages.UtilMsgResetEmbeddedTOVs;
import com.qlogic.device.fcfabric.util.messages.UtilMsgResetSwitch;
import com.qlogic.device.fcfabric.util.messages.UtilMsgRscn;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSaveActiveTLConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSaveAllAdminPortTypes;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSensorStatus;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetAllActivePortAdminStates;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetAllActivePortTypes;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetPortSpeedReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetZoningConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSnmpCommunities;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSnmpConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSwitchConfigurationParameters;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSysCfgReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgTraceControl;
import com.qlogic.device.fcfabric.util.messages.UtilMsgTraceRequest;
import com.qlogic.device.fcfabric.util.messages.UtilMsgTrapConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgZoningTypeReq;
import com.qlogic.device.fcfabric.util.messages.UtilThread;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.net.InetAddress;
import java.util.Vector;

public class UtilAgent
implements ComAgent {
    private WorldWideName connectionWwn;
    private User loginInfo = new User("", "", -1);
    private int agentStatus = 2;
    long startTime;
    int messagesSent;
    int messagesReturned;
    int messagesTimedOut;
    int messagesDiscards;
    int messagesResent;
    double aveMessagesPerSec = 0.0;
    int lastMessagesSent = 0;
    long lastTime = System.currentTimeMillis();
    int notifications;
    double aveTime;
    UtilMessageParallelQueue messageQueue = null;
    TCPAgent tcpAgent = null;
    UtilThread utilThread = null;
    Vector listeners = new Vector();

    public UtilAgent(InetAddress inetAddress) {
        this.startTime = System.currentTimeMillis();
        this.messageQueue = new UtilMessageParallelQueue();
        this.tcpAgent = new TCPAgent(inetAddress);
        this.utilThread = new UtilThread(this, this.tcpAgent, this.messageQueue);
    }

    public void die() {
        this.utilThread.die();
    }

    public boolean isConnected() {
        return this.tcpAgent.isConnected();
    }

    public boolean connect() {
        this.setComAgentStatus(3);
        if (this.tcpAgent.connect()) {
            this.setComAgentStatus(1);
            return true;
        }
        this.setComAgentStatus(2);
        return false;
    }

    public void setEntryKey(Object object) {
        this.utilThread.setEntryKey(object);
    }

    public boolean isThisThreadTheReponseThread(Thread thread) {
        return thread == this.utilThread.getRepsonseThread();
    }

    public WorldWideName getConnectionWwn() {
        return this.connectionWwn;
    }

    public void setConnectionWwnAndFcAddress(WorldWideName worldWideName, int n) {
        this.connectionWwn = worldWideName;
        this.utilThread.setEntryKey(new Integer(n));
    }

    public void flushTheQueue() {
        this.utilThread.flushTheQueue();
    }

    public User getLoginInfo() {
        return this.loginInfo;
    }

    public int getMessagesInSendQueue() {
        return this.messageQueue.getNumberInQueue();
    }

    public int getMessagesInResponseQueue() {
        return this.utilThread.responseThread.responseQueue.getNumberInQueue();
    }

    public int getMessagesTimedOut() {
        return this.messagesTimedOut;
    }

    public int getMessagesDiscards() {
        return this.messagesDiscards;
    }

    public int getMessagesSent() {
        return this.messagesSent;
    }

    public double getMessagesSentPerSecond() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTime;
        if (l2 > 0L) {
            double d = 1000.0 * (double)(this.messagesSent - this.lastMessagesSent) / (double)l2;
            this.aveMessagesPerSec = this.aveMessagesPerSec * 0.9 + d * 0.1;
            this.lastMessagesSent = this.messagesSent;
            this.lastTime = l;
        }
        return this.aveMessagesPerSec;
    }

    public int getMessagesResent() {
        return this.messagesResent;
    }

    public int getNotifications() {
        return this.notifications;
    }

    public double getAveTime() {
        return this.aveTime;
    }

    public int getComAgentStatus() {
        return this.agentStatus;
    }

    public void setComAgentStatus(int n) {
        boolean bl = n != this.agentStatus;
        this.agentStatus = n;
        if (bl) {
            this.fireComAgentEvent(4, new ComAgentEvent(this, 4, null));
        }
    }

    void incMessagesSent() {
        ++this.messagesSent;
    }

    void incMessagesResent() {
        ++this.messagesResent;
    }

    void incMessagesReturned(long l) {
        ++this.messagesReturned;
        double d = l;
        this.aveTime = 0.999 * this.aveTime + 0.001 * d;
    }

    void incMessagesDiscards() {
        ++this.messagesDiscards;
    }

    void incMessagesTimedOut() {
        ++this.messagesTimedOut;
    }

    void incNotifications() {
        ++this.notifications;
    }

    public int getMessagesReturned() {
        return this.messagesReturned;
    }

    public void startMessageThread() {
        this.utilThread.start();
    }

    public boolean getVersion(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgVersionReq utilMsgVersionReq = new UtilMsgVersionReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgVersionReq, true);
    }

    public boolean getBeacon(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgBeaconStatusReq utilMsgBeaconStatusReq = new UtilMsgBeaconStatusReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgBeaconStatusReq, true);
    }

    public boolean getModelType(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgModelCfgReq utilMsgModelCfgReq = new UtilMsgModelCfgReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgModelCfgReq, true);
    }

    public boolean getSysCfg(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSysCfgReq utilMsgSysCfgReq = new UtilMsgSysCfgReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgSysCfgReq, true);
    }

    public boolean setBeacon(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl) {
        UtilMsgBeaconSet utilMsgBeaconSet = new UtilMsgBeaconSet(utilDestination, utilEventListener, bl);
        return this.messageQueue.queueMessage(utilMsgBeaconSet, true);
    }

    public boolean sendLoginRequest(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, String string2) {
        UtilMsgLoginRequest utilMsgLoginRequest = new UtilMsgLoginRequest(utilDestination, utilEventListener, string, string2);
        return this.messageQueue.queueMessage(utilMsgLoginRequest, true);
    }

    public boolean getSmlCommands(UtilDestination utilDestination, UtilEventListener utilEventListener, Vector vector) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(utilDestination, utilEventListener);
        utilMsgSml.addSmlCommands(vector);
        return this.messageQueue.queueMessage(utilMsgSml, true);
    }

    public boolean sendSml(UtilMsgSml utilMsgSml) {
        return this.messageQueue.queueMessage(utilMsgSml, true);
    }

    public boolean getChassisStatus(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgChassisStatusReq utilMsgChassisStatusReq = new UtilMsgChassisStatusReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgChassisStatusReq, true);
    }

    public boolean getSnmpConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSnmpConfig utilMsgSnmpConfig = new UtilMsgSnmpConfig(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgSnmpConfig, true);
    }

    public boolean getSnmpCommunityInfo(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSnmpCommunities utilMsgSnmpCommunities = new UtilMsgSnmpCommunities(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgSnmpCommunities, true);
    }

    public boolean setSnmpConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSnmpConfig utilMsgSnmpConfig) {
        utilMsgSnmpConfig.setListener(utilEventListener);
        utilMsgSnmpConfig.setDestination(utilDestination);
        utilMsgSnmpConfig.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSnmpConfig, true);
    }

    public boolean setAllActiveAdminPortTypes(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgAllActiveAdminPortTypes utilMsgAllActiveAdminPortTypes) {
        utilMsgAllActiveAdminPortTypes.setListener(utilEventListener);
        utilMsgAllActiveAdminPortTypes.setDestination(utilDestination);
        utilMsgAllActiveAdminPortTypes.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgAllActiveAdminPortTypes, true);
    }

    public boolean saveAllAdminPortTypes(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSaveAllAdminPortTypes utilMsgSaveAllAdminPortTypes) {
        utilMsgSaveAllAdminPortTypes.setListener(utilEventListener);
        utilMsgSaveAllAdminPortTypes.setDestination(utilDestination);
        utilMsgSaveAllAdminPortTypes.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSaveAllAdminPortTypes, true);
    }

    public boolean setActiveTLConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgActiveTLConfig utilMsgActiveTLConfig) {
        utilMsgActiveTLConfig.setListener(utilEventListener);
        utilMsgActiveTLConfig.setDestination(utilDestination);
        utilMsgActiveTLConfig.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgActiveTLConfig, true);
    }

    public boolean saveActiveTLConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSaveActiveTLConfig utilMsgSaveActiveTLConfig) {
        utilMsgSaveActiveTLConfig.setListener(utilEventListener);
        utilMsgSaveActiveTLConfig.setDestination(utilDestination);
        utilMsgSaveActiveTLConfig.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSaveActiveTLConfig, true);
    }

    public boolean setSnmpCommunityStrings(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSnmpCommunities utilMsgSnmpCommunities) {
        utilMsgSnmpCommunities.setListener(utilEventListener);
        utilMsgSnmpCommunities.setDestination(utilDestination);
        utilMsgSnmpCommunities.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSnmpCommunities, true);
    }

    public boolean getEPortTopology(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, short s) {
        UtilMsgEPortTopology utilMsgEPortTopology = new UtilMsgEPortTopology(utilDestination, utilEventListener);
        utilMsgEPortTopology.setGetCommand();
        utilMsgEPortTopology.setStartDomain(n);
        utilMsgEPortTopology.setStartLink(s);
        return this.messageQueue.queueMessage(utilMsgEPortTopology, true);
    }

    public boolean getActiveSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters(utilDestination, utilEventListener);
        utilMsgSwitchConfigurationParameters.setActive();
        utilMsgSwitchConfigurationParameters.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean getTimeStamp(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgGetTimeStamp utilMsgGetTimeStamp = new UtilMsgGetTimeStamp(utilDestination, utilEventListener);
        utilMsgGetTimeStamp.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgGetTimeStamp, true);
    }

    public boolean getPendingSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters(utilDestination, utilEventListener);
        utilMsgSwitchConfigurationParameters.setPending();
        utilMsgSwitchConfigurationParameters.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean getSavedSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters(utilDestination, utilEventListener);
        utilMsgSwitchConfigurationParameters.setSaved();
        utilMsgSwitchConfigurationParameters.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean setPendingSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters) {
        utilMsgSwitchConfigurationParameters.setListener(utilEventListener);
        utilMsgSwitchConfigurationParameters.setDestination(utilDestination);
        utilMsgSwitchConfigurationParameters.setPending();
        utilMsgSwitchConfigurationParameters.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean setActiveSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters) {
        utilMsgSwitchConfigurationParameters.setListener(utilEventListener);
        utilMsgSwitchConfigurationParameters.setDestination(utilDestination);
        utilMsgSwitchConfigurationParameters.setActive();
        utilMsgSwitchConfigurationParameters.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean saveActiveSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters) {
        utilMsgSwitchConfigurationParameters.setListener(utilEventListener);
        utilMsgSwitchConfigurationParameters.setDestination(utilDestination);
        utilMsgSwitchConfigurationParameters.setSaveActive();
        utilMsgSwitchConfigurationParameters.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean savePendingSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters) {
        utilMsgSwitchConfigurationParameters.setListener(utilEventListener);
        utilMsgSwitchConfigurationParameters.setDestination(utilDestination);
        utilMsgSwitchConfigurationParameters.setSavePending();
        utilMsgSwitchConfigurationParameters.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean reconfigSwitchHardware(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters) {
        utilMsgSwitchConfigurationParameters.setListener(utilEventListener);
        utilMsgSwitchConfigurationParameters.setDestination(utilDestination);
        utilMsgSwitchConfigurationParameters.setReconfig();
        utilMsgSwitchConfigurationParameters.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSwitchConfigurationParameters, true);
    }

    public boolean startLoopbackTest(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgOLTStart utilMsgOLTStart) {
        utilMsgOLTStart.setListener(utilEventListener);
        utilMsgOLTStart.setDestination(utilDestination);
        utilMsgOLTStart.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgOLTStart, true);
    }

    public boolean stopLoopbackTest(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgOLTStop utilMsgOLTStop) {
        utilMsgOLTStop.setListener(utilEventListener);
        utilMsgOLTStop.setDestination(utilDestination);
        utilMsgOLTStop.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgOLTStop, true);
    }

    public boolean resetLoopbackTest(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgOLTReset utilMsgOLTReset) {
        utilMsgOLTReset.setListener(utilEventListener);
        utilMsgOLTReset.setDestination(utilDestination);
        utilMsgOLTReset.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgOLTReset, true);
    }

    public boolean getLoopbackTestStatus(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgOLTStatus utilMsgOLTStatus = new UtilMsgOLTStatus(utilDestination, utilEventListener);
        utilMsgOLTStatus.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgOLTStatus, true);
    }

    public boolean getAllActiveAdminPortTypes(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgAllActiveAdminPortTypes utilMsgAllActiveAdminPortTypes = new UtilMsgAllActiveAdminPortTypes(utilDestination, utilEventListener);
        utilMsgAllActiveAdminPortTypes.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgAllActiveAdminPortTypes, true);
    }

    public boolean getActiveTLConfig(int n, UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgActiveTLConfig utilMsgActiveTLConfig = new UtilMsgActiveTLConfig(utilDestination, utilEventListener);
        utilMsgActiveTLConfig.setPortNum(n);
        utilMsgActiveTLConfig.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgActiveTLConfig, true);
    }

    public boolean getEPortIsolationReasons(int n, UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgEPortIsolationReason utilMsgEPortIsolationReason = new UtilMsgEPortIsolationReason(utilDestination, utilEventListener);
        utilMsgEPortIsolationReason.setPortCount(n);
        utilMsgEPortIsolationReason.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgEPortIsolationReason, true);
    }

    public boolean getRscn(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgRscn utilMsgRscn = new UtilMsgRscn(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgRscn, true);
    }

    public boolean setRscn(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgRscn utilMsgRscn) {
        utilMsgRscn.setListener(utilEventListener);
        utilMsgRscn.setDestination(utilDestination);
        utilMsgRscn.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgRscn, true);
    }

    public boolean getIpConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgIpConfig utilMsgIpConfig = new UtilMsgIpConfig(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgIpConfig, true);
    }

    public boolean setIpConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgIpConfig utilMsgIpConfig) {
        utilMsgIpConfig.setListener(utilEventListener);
        utilMsgIpConfig.setDestination(utilDestination);
        utilMsgIpConfig.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgIpConfig, true);
    }

    public boolean setChassisMode(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        UtilMsgChassisMode utilMsgChassisMode = new UtilMsgChassisMode(utilDestination, utilEventListener);
        utilMsgChassisMode.setSetCommand();
        utilMsgChassisMode.setChassisMode((byte)n);
        return this.messageQueue.queueMessage(utilMsgChassisMode, true);
    }

    public boolean writeMemory(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, byte[] byArray) {
        UtilMsgMemoryWrite utilMsgMemoryWrite = new UtilMsgMemoryWrite(utilDestination, utilEventListener, n, byArray);
        return this.messageQueue.queueMessage(utilMsgMemoryWrite, true);
    }

    public boolean getSensorStatus(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgSensorStatus utilMsgSensorStatus = new UtilMsgSensorStatus(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgSensorStatus, true);
    }

    public boolean getAllAdminPortSpeeds(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgAllAdminPortSpeedsReq utilMsgAllAdminPortSpeedsReq = new UtilMsgAllAdminPortSpeedsReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgAllAdminPortSpeedsReq, true);
    }

    public boolean setPortSpeed(UtilDestination utilDestination, UtilEventListener utilEventListener, UtilMsgSetPortSpeedReq utilMsgSetPortSpeedReq) {
        utilMsgSetPortSpeedReq.setListener(utilEventListener);
        utilMsgSetPortSpeedReq.setDestination(utilDestination);
        utilMsgSetPortSpeedReq.setSetCommand();
        return this.messageQueue.queueMessage(utilMsgSetPortSpeedReq, true);
    }

    public boolean getAllPortsStates(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgAllPortsStates utilMsgAllPortsStates = new UtilMsgAllPortsStates(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgAllPortsStates, true);
    }

    public boolean getTraceConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgTrapConfig utilMsgTrapConfig = new UtilMsgTrapConfig(utilDestination, utilEventListener, true);
        return this.messageQueue.queueMessage(utilMsgTrapConfig, true);
    }

    public boolean saveTraceConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgTrapConfig utilMsgTrapConfig = new UtilMsgTrapConfig(utilDestination, utilEventListener, false);
        return this.messageQueue.queueMessage(utilMsgTrapConfig, true);
    }

    public boolean setTrapConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl, int n, int n2, int[] nArray, int[] nArray2, boolean[] blArray) {
        byte[] byArray = new byte[blArray.length];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = blArray[n3] ? (byte)1 : 0;
            ++n3;
        }
        UtilMsgTrapConfig utilMsgTrapConfig = new UtilMsgTrapConfig(utilDestination, utilEventListener, bl, n, n2, nArray, nArray2, byArray);
        return this.messageQueue.queueMessage(utilMsgTrapConfig, true);
    }

    public boolean getTraceLog(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, int n2) {
        UtilMsgTraceRequest utilMsgTraceRequest = new UtilMsgTraceRequest(utilDestination, utilEventListener, n, n2);
        return this.messageQueue.queueMessage(utilMsgTraceRequest, true);
    }

    public boolean sendTraceLogControlFlag(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        UtilMsgTraceControl utilMsgTraceControl = new UtilMsgTraceControl(utilDestination, utilEventListener, n);
        return this.messageQueue.queueMessage(utilMsgTraceControl, true);
    }

    public boolean getTraceLogControlFlag(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgTraceControl utilMsgTraceControl = new UtilMsgTraceControl(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgTraceControl, true);
    }

    public boolean getAllSwitchInternalCounters(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgGetAllSwitchInternalCounters utilMsgGetAllSwitchInternalCounters = new UtilMsgGetAllSwitchInternalCounters(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgGetAllSwitchInternalCounters, true);
    }

    public boolean resetSwitch(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgResetSwitch utilMsgResetSwitch = new UtilMsgResetSwitch(utilDestination, utilEventListener);
        utilMsgResetSwitch.setExpectReply(false);
        utilMsgResetSwitch.setWaitAfterSend(5000);
        return this.messageQueue.queueMessage(utilMsgResetSwitch, true);
    }

    public boolean delayedSwReset(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        UtilMsgDelayedSwReset utilMsgDelayedSwReset = new UtilMsgDelayedSwReset(utilDestination, utilEventListener, n);
        return this.messageQueue.queueMessage(utilMsgDelayedSwReset, true);
    }

    public boolean getAllPortCounters(UtilDestination utilDestination, UtilEventListener utilEventListener, byte by) {
        UtilMsgGetAllPortCounters utilMsgGetAllPortCounters = new UtilMsgGetAllPortCounters(utilDestination, utilEventListener, by);
        return this.messageQueue.queueMessage(utilMsgGetAllPortCounters, true);
    }

    public boolean getZoningType(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgZoningTypeReq utilMsgZoningTypeReq = new UtilMsgZoningTypeReq(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgZoningTypeReq, true);
    }

    public boolean getOperationalChassisMode(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgChassisMode utilMsgChassisMode = new UtilMsgChassisMode(utilDestination, utilEventListener);
        utilMsgChassisMode.setGetCommand();
        return this.messageQueue.queueMessage(utilMsgChassisMode, true);
    }

    public boolean getAdminChassisMode(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgChassisMode utilMsgChassisMode = new UtilMsgChassisMode(utilDestination, utilEventListener);
        utilMsgChassisMode.setGetCommand();
        utilMsgChassisMode.setGetAdmin();
        return this.messageQueue.queueMessage(utilMsgChassisMode, true);
    }

    public boolean getNameServerGetAllNext(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        UtilMsgNameServerGetAllNextFabricUnzoned utilMsgNameServerGetAllNextFabricUnzoned = new UtilMsgNameServerGetAllNextFabricUnzoned(utilDestination, utilEventListener, n);
        return this.messageQueue.queueMessage(utilMsgNameServerGetAllNextFabricUnzoned, true);
    }

    public boolean getZoneSetList(UtilDestination utilDestination, UtilEventListener utilEventListener, byte by) {
        UtilMsgGetZoneSetList utilMsgGetZoneSetList = new UtilMsgGetZoneSetList(utilDestination, utilEventListener, by);
        return this.messageQueue.queueMessage(utilMsgGetZoneSetList, true);
    }

    public boolean getZonesInAZoneSet(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, byte by) {
        UtilMsgGetZonesInAZoneSet utilMsgGetZonesInAZoneSet = new UtilMsgGetZonesInAZoneSet(utilDestination, utilEventListener, string, by);
        return this.messageQueue.queueMessage(utilMsgGetZonesInAZoneSet, true);
    }

    public boolean getMembersInAZone(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, int n) {
        UtilMsgGetZoneMembers utilMsgGetZoneMembers = new UtilMsgGetZoneMembers(utilDestination, utilEventListener, string, n);
        return this.messageQueue.queueMessage(utilMsgGetZoneMembers, true);
    }

    public boolean getActiveZoneSet(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgGetActiveZoneSet utilMsgGetActiveZoneSet = new UtilMsgGetActiveZoneSet(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgGetActiveZoneSet, true);
    }

    public boolean getZoningConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgGetZoningConfig utilMsgGetZoningConfig = new UtilMsgGetZoningConfig(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgGetZoningConfig, true);
    }

    public boolean setZoningConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, ZoningConfig zoningConfig) {
        UtilMsgSetZoningConfig utilMsgSetZoningConfig = new UtilMsgSetZoningConfig(utilDestination, utilEventListener, zoningConfig.getDefaultVisibility());
        return this.messageQueue.queueMessage(utilMsgSetZoningConfig, true);
    }

    public boolean addMembersToAZone(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, Vector vector, byte by, boolean bl) {
        UtilMsgAddMembersToZone utilMsgAddMembersToZone = new UtilMsgAddMembersToZone(utilDestination, utilEventListener, string, vector, by, bl);
        return this.messageQueue.queueMessage(utilMsgAddMembersToZone, true);
    }

    public boolean addZonesToAZoneSet(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, Vector vector, byte by, boolean bl) {
        UtilMsgAddZonesToZoneSet utilMsgAddZonesToZoneSet = new UtilMsgAddZonesToZoneSet(utilDestination, utilEventListener, string, vector, by, bl);
        return this.messageQueue.queueMessage(utilMsgAddZonesToZoneSet, true);
    }

    public boolean activateAZoneSet(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, boolean bl) {
        UtilMsgActivateZoneSet utilMsgActivateZoneSet = new UtilMsgActivateZoneSet(utilDestination, utilEventListener, string, bl);
        return this.messageQueue.queueMessage(utilMsgActivateZoneSet, true);
    }

    public boolean clearZoning(UtilDestination utilDestination, UtilEventListener utilEventListener, byte by) {
        UtilMsgClearZoning utilMsgClearZoning = new UtilMsgClearZoning(utilDestination, utilEventListener, by);
        return this.messageQueue.queueMessage(utilMsgClearZoning, true);
    }

    public boolean createZoneSet(UtilDestination utilDestination, UtilEventListener utilEventListener, String string) {
        UtilMsgCreateZoneSet utilMsgCreateZoneSet = new UtilMsgCreateZoneSet(utilDestination, utilEventListener, string);
        return this.messageQueue.queueMessage(utilMsgCreateZoneSet, true);
    }

    public boolean setAllActivePortTypes(UtilDestination utilDestination, UtilEventListener utilEventListener, byte[] byArray) {
        UtilMsgSetAllActivePortTypes utilMsgSetAllActivePortTypes = new UtilMsgSetAllActivePortTypes(utilDestination, utilEventListener, byArray);
        return this.messageQueue.queueMessage(utilMsgSetAllActivePortTypes, true);
    }

    public boolean setAllActivePortAdminStates(UtilDestination utilDestination, UtilEventListener utilEventListener, byte[] byArray) {
        UtilMsgSetAllActivePortAdminStates utilMsgSetAllActivePortAdminStates = new UtilMsgSetAllActivePortAdminStates(utilDestination, utilEventListener, byArray);
        return this.messageQueue.queueMessage(utilMsgSetAllActivePortAdminStates, true);
    }

    public boolean loadFirmware(UtilMsgFlashLoad utilMsgFlashLoad) {
        return this.messageQueue.queueMessage(utilMsgFlashLoad, true);
    }

    public boolean resetEmbeddedTOVs(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgResetEmbeddedTOVs utilMsgResetEmbeddedTOVs = new UtilMsgResetEmbeddedTOVs(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgResetEmbeddedTOVs, true);
    }

    public boolean resetEmbeddedTOVs(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, int n2) {
        UtilMsgResetEmbeddedTOVs utilMsgResetEmbeddedTOVs = new UtilMsgResetEmbeddedTOVs(utilDestination, utilEventListener, n, n2);
        return this.messageQueue.queueMessage(utilMsgResetEmbeddedTOVs, true);
    }

    public boolean commitZoning(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        UtilMsgCommitZoning utilMsgCommitZoning = new UtilMsgCommitZoning(utilDestination, utilEventListener);
        return this.messageQueue.queueMessage(utilMsgCommitZoning, true);
    }

    public void setIpAddress(InetAddress inetAddress) {
        this.tcpAgent.setIp(inetAddress);
    }

    public InetAddress getIpAddress() {
        return this.tcpAgent.getIp();
    }

    public synchronized void addComAgentListener(ComAgentEventListener comAgentEventListener) {
        if (!this.listeners.contains(comAgentEventListener)) {
            this.listeners.addElement(comAgentEventListener);
        }
    }

    public synchronized void removeComAgentListener(ComAgentEventListener comAgentEventListener) {
        if (this.listeners.contains(comAgentEventListener)) {
            this.listeners.removeElement(comAgentEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireComAgentEvent(int n, Object object) {
        Vector vector;
        ComAgentEvent comAgentEvent = new ComAgentEvent(this, n, object);
        UtilAgent utilAgent = this;
        synchronized (utilAgent) {
            vector = (Vector)this.listeners.clone();
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            ComAgentEventListener comAgentEventListener = (ComAgentEventListener)vector.elementAt(n3);
            comAgentEventListener.receiveEvent(comAgentEvent);
            ++n3;
        }
    }

    public int getQueueSize() {
        return this.messageQueue.getNumberInQueue();
    }
}

