/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilPacket;
import com.qlogic.util.QSocketFactory;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class TCPAgent {
    public static final int TCP_AGENT_REC_OK = 0;
    public static final int TCP_AGENT_REC_TIMEOUT = 1;
    public static final int TCP_AGENT_REC_ERROR = 2;
    public static final int TCP_AGENT_REC_ERROR_SOCKET_CLOSED = 3;
    public static final int TCP_AGENT_SEND_OK = 4;
    public static final int TCP_AGENT_SEND_ERROR_SOCKET_ERROR = 5;
    public static final int TCP_AGENT_SEND_ERROR_UNPACK_ERROR = 6;
    public static final int UM_MAX_RCV_SIZE = 3000;
    public static final int UM_PORT = 5000;
    public static final int UM_SOCKET_TMO = 2000;
    public static final int UM_CONNECT_TMO = 5000;
    private Socket utilSocket = null;
    private Object socketLock = new Object();
    private BufferedInputStream inData;
    private DataOutputStream outData;
    private InetAddress currentIpAddress;
    private static final int NUMBER_OF_STATUS_MESSAGES = 10;
    private int goodMessages = 10;
    private byte[] recvData = new byte[3000];
    private int recvIndex = 0;

    public TCPAgent(InetAddress inetAddress) {
        this.currentIpAddress = inetAddress;
    }

    public boolean isConnected() {
        if (this.utilSocket != null) {
            return this.utilSocket.isConnected();
        }
        return false;
    }

    public void setIp(InetAddress inetAddress) {
        this.currentIpAddress = inetAddress;
    }

    public InetAddress getIp() {
        return this.currentIpAddress;
    }

    public int sendMessage(UtilMessage utilMessage) {
        if (this.utilSocket == null || !this.utilSocket.isConnected()) {
            utilMessage.setStatus(109);
            return 5;
        }
        if (!utilMessage.pack()) {
            utilMessage.pack();
            return 6;
        }
        byte[] byArray = utilMessage.getBuffer();
        try {
            this.outData.write(byArray);
        }
        catch (SocketException socketException) {
            this.closeTheSocket();
            return 5;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return 5;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 5;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 5;
        }
        utilMessage.setStatus(102);
        utilMessage.setSendPacket(new UtilPacket(this.utilSocket.getInetAddress(), byArray));
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveMessage(UtilMessage utilMessage, int n) {
        this.verifyRightAddress();
        Object object = this.socketLock;
        synchronized (object) {
            block15: {
                if (this.utilSocket == null || !this.utilSocket.isConnected()) {
                    utilMessage.setStatus(109);
                    return 3;
                }
                try {
                    int n2;
                    this.setTimeout(n);
                    int n3 = 0;
                    if (this.recvIndex == 0) {
                        n3 = 20;
                        n2 = this.inData.read(this.recvData, 0, 20);
                        if (n2 == 20) {
                            this.recvIndex = 20;
                        } else {
                            this.closeTheSocket();
                            return 1;
                        }
                    }
                    if (this.recvIndex != 20) break block15;
                    n2 = UtilMessage.getResponseDataLength(this.recvData);
                    if (n2 + 20 > 3000) {
                        this.closeTheSocket();
                        return 1;
                    }
                    int n4 = this.inData.read(this.recvData, 20, n2);
                    this.recvIndex = 0;
                    if (n4 == n2) {
                        int n5 = 20 + n2;
                        byte[] byArray = new byte[n5];
                        int n6 = 0;
                        while (n6 < n5) {
                            byArray[n6] = this.recvData[n6];
                            ++n6;
                        }
                        UtilPacket utilPacket = new UtilPacket(this.utilSocket.getInetAddress(), byArray);
                        utilMessage.setReceivePacket(utilPacket);
                        break block15;
                    }
                    this.closeTheSocket();
                    return 1;
                }
                catch (SocketException socketException) {
                    if (socketException.toString().indexOf("Connection reset") < 0) {
                        socketException.printStackTrace();
                    }
                    utilMessage.setStatus(109);
                    return 3;
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().indexOf("timed out") >= 0) {
                        utilMessage.setStatus(107);
                        return 1;
                    }
                    utilMessage.setStatus(109);
                    return 3;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTheSocket() {
        Object object = this.socketLock;
        synchronized (object) {
            try {
                this.utilSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.utilSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean connect() {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.currentIpAddress == null) {
                this.utilSocket = null;
                this.outData = null;
                this.inData = null;
                return false;
            }
            try {
                if (this.isConnected()) {
                    this.closeTheSocket();
                }
                QSocketFactory qSocketFactory = QSocketFactory.getInstance();
                this.utilSocket = qSocketFactory.createSocket(this.currentIpAddress, 5000, 5000);
                this.outData = new DataOutputStream(this.utilSocket.getOutputStream());
                this.inData = new BufferedInputStream(this.utilSocket.getInputStream());
                this.utilSocket.setSoTimeout(2000);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    private void verifyRightAddress() {
        boolean bl = false;
        if (this.utilSocket == null || !this.isConnected() || !this.utilSocket.getInetAddress().equals(this.currentIpAddress)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connect();
        }
    }

    void setTimeout(int n) {
        try {
            this.utilSocket.setSoTimeout(n);
        }
        catch (Exception exception) {}
    }
}

