/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetActiveZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZoneMembers;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZoneSetList;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZonesInAZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetZoningConfig;
import com.qlogic.device.fcfabric.zoning.SanboxZones;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.util.Vector;

public class SanboxZoningUtilLoad
implements UtilEventListener {
    SanboxUtil sanbox;
    UtilAgent utilAgent;
    ChassisEventHandler eventHandler;
    SanboxZones tempEportZoningDB;
    SanboxZones eportZoningDB;
    private static final int E_PORT_ZONING_STATE_IDLE = 0;
    private static final int E_PORT_ZONING_STATE_LOADING = 1;
    private int eportZoningState;

    SanboxZoningUtilLoad(UtilAgent utilAgent, SanboxUtil sanboxUtil, ChassisEventHandler chassisEventHandler) {
        this.eportZoningDB = this.tempEportZoningDB = new SanboxZones();
        this.eportZoningState = 0;
        this.utilAgent = utilAgent;
        this.sanbox = sanboxUtil;
        this.eventHandler = chassisEventHandler;
    }

    public SanboxZones getZones() {
        return this.eportZoningDB;
    }

    public SanboxZones getActiveZones() {
        return this.eportZoningDB;
    }

    public void receiveMessage(UtilMessage utilMessage) {
        Object object;
        UtilMsgConfig utilMsgConfig;
        if (utilMessage instanceof UtilMsgGetZoneSetList) {
            if (utilMessage.getStatus() == 103) {
                utilMsgConfig = (UtilMsgGetZoneSetList)utilMessage;
                int n = ((UtilMsgGetZoneSetList)utilMsgConfig).getNumberOfZoneSets();
                int n2 = 0;
                while (n2 < n) {
                    object = ((UtilMsgGetZoneSetList)utilMsgConfig).getZoneSet(n2);
                    if (!SanboxZones.verifyName((String)object)) {
                        FabricUtilities.logMessage("received a bad set name from the switch set->" + (String)object + " util=" + utilMessage.getDataTransfered());
                        this.tempEportZoningDB.setErrorReading(true);
                    }
                    if (!this.addZoneSet((String)object)) {
                        FabricUtilities.logMessage("Failed to load set->" + (String)object + " util=" + utilMessage.getDataTransfered());
                        this.cancelEPortZoningLoad();
                    }
                    ++n2;
                }
                if (((UtilMsgGetZoneSetList)utilMsgConfig).getEndOfData()) {
                    this.finishedGettingSets();
                } else {
                    this.getNextZoneSets(((UtilMsgGetZoneSetList)utilMsgConfig).getStartIndex() + ((UtilMsgGetZoneSetList)utilMsgConfig).getNumberOfZoneSets());
                }
            } else {
                this.cancelEPortZoningLoad();
            }
        }
        if (utilMessage instanceof UtilMsgGetZonesInAZoneSet) {
            if (utilMessage.getStatus() == 103) {
                utilMsgConfig = (UtilMsgGetZonesInAZoneSet)utilMessage;
                String string = ((UtilMsgGetZonesInAZoneSet)utilMsgConfig).getZoneSetName();
                ZoneSet zoneSet = this.tempEportZoningDB.findZoneSet(string);
                if (zoneSet != null) {
                    Object object2;
                    int n = 0;
                    while (n < ((UtilMsgGetZonesInAZoneSet)utilMsgConfig).getNumberOfZones()) {
                        object2 = ((UtilMsgGetZonesInAZoneSet)utilMsgConfig).getZone(n);
                        if (!SanboxZones.verifyName((String)object2)) {
                            FabricUtilities.logMessage("received a bad zone name from the switch set->" + (String)object2 + " util=" + utilMessage.getDataTransfered());
                            this.tempEportZoningDB.setErrorReading(true);
                        }
                        if (!this.addZone(zoneSet, (String)object2)) {
                            FabricUtilities.logMessage("Failed to create zone " + (String)object2 + " in set->" + zoneSet + " util=" + utilMessage.getDataTransfered());
                            this.cancelEPortZoningLoad();
                        }
                        ++n;
                    }
                    if (((UtilMsgGetZonesInAZoneSet)utilMsgConfig).getEndOfData()) {
                        object2 = this.tempEportZoningDB.getNextZoneSet(zoneSet);
                        if (object2 != null) {
                            this.getFirstZoneInSet((ZoneSet)object2);
                        } else {
                            this.finshedGettingZones();
                        }
                    } else {
                        this.getNextZoneInSet(zoneSet, ((UtilMsgGetZonesInAZoneSet)utilMsgConfig).getStartIndex() + ((UtilMsgGetZonesInAZoneSet)utilMsgConfig).getNumberOfZones());
                    }
                } else {
                    FabricUtilities.logMessage("Failed to find set " + string + " for loading util=" + utilMessage.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
            } else {
                this.cancelEPortZoningLoad();
            }
        }
        if (utilMessage instanceof UtilMsgGetZoneMembers) {
            if (utilMessage.getStatus() == 103) {
                utilMsgConfig = (UtilMsgGetZoneMembers)utilMessage;
                String string = ((UtilMsgGetZoneMembers)utilMsgConfig).getZoneName();
                Zone zone = this.tempEportZoningDB.findZone(string);
                if (zone != null) {
                    if (!this.addZoneMembers(zone, ((UtilMsgGetZoneMembers)utilMsgConfig).getMemberList())) {
                        FabricUtilities.logMessage("Failed to add members " + utilMsgConfig.toString() + " to zone " + zone.getName() + " util=" + utilMessage.getDataTransfered());
                        this.cancelEPortZoningLoad();
                    }
                    if (((UtilMsgGetZoneMembers)utilMsgConfig).getEndOfData()) {
                        object = this.tempEportZoningDB.getNextZone(zone);
                        if (object != null) {
                            this.getFirstMemberInZone((Zone)object);
                        } else {
                            this.finishedLoadingZoneMembers();
                        }
                    } else {
                        this.getNextMemberInZone(zone, ((UtilMsgGetZoneMembers)utilMsgConfig).getStartIndex() + ((UtilMsgGetZoneMembers)utilMsgConfig).getNumberOfMembers());
                    }
                } else {
                    FabricUtilities.logMessage("Failed find zone " + string + " to load members util=" + utilMessage.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
            } else {
                this.cancelEPortZoningLoad();
            }
        }
        if (utilMessage instanceof UtilMsgGetActiveZoneSet) {
            if (utilMessage.getStatus() == 103) {
                utilMsgConfig = (UtilMsgGetActiveZoneSet)utilMessage;
                String string = ((UtilMsgGetActiveZoneSet)utilMsgConfig).getActiveZoneSetName();
                ZoneSet zoneSet = this.tempEportZoningDB.findZoneSet(string);
                if (!this.setActiveZoneSet(zoneSet)) {
                    FabricUtilities.logMessage("Failed load the active set " + string + " util=" + utilMessage.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
            } else {
                this.cancelEPortZoningLoad();
            }
        }
        if (utilMessage instanceof UtilMsgGetZoningConfig) {
            boolean bl = false;
            if (utilMessage.getStatus() == 103) {
                UtilMsgGetZoningConfig utilMsgGetZoningConfig = (UtilMsgGetZoningConfig)utilMessage;
                ZoningConfig zoningConfig = this.sanbox.getZoningConfig();
                zoningConfig.setDefaultVisibility(utilMsgGetZoningConfig.getZoneVisibility());
                zoningConfig.setAutoSave(true);
                zoningConfig.setMergeMode(0);
                bl = true;
            }
            this.eventHandler.fireChassisEvent(333, null, bl);
        }
    }

    public boolean updateEPortZoning() {
        if (this.eportZoningState != 0) {
            return false;
        }
        this.newZoningState(1);
        this.tempEportZoningDB = new SanboxZones();
        return this.getFirstZoneSets();
    }

    public void cancelEPortZoningLoad() {
        if (this.eportZoningState == 1) {
            this.tempEportZoningDB.setErrorReading(true);
            this.newZoningState(0);
            this.eventHandler.fireChassisEvent(241, null, false);
        }
    }

    private boolean addZoneSet(String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null) {
            return this.tempEportZoningDB.createZoneSet(string) != null;
        }
        return this.finishedGettingSets();
    }

    private boolean finishedGettingSets() {
        if (this.eportZoningState != 1) {
            return false;
        }
        ZoneSet zoneSet = this.tempEportZoningDB.getFirstZoneSet();
        if (zoneSet != null) {
            return this.getFirstZoneInSet(zoneSet);
        }
        return this.finshedGettingZones();
    }

    private boolean getFirstZoneSets() {
        return this.getNextZoneSets(0);
    }

    private boolean getNextZoneSets(int n) {
        return this.utilAgent.getZoneSetList(this.sanbox, this, (byte)n);
    }

    public boolean updateZoningConfig() {
        return this.utilAgent.getZoningConfig(this.sanbox, this);
    }

    private boolean addZone(ZoneSet zoneSet, String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        Zone zone = this.tempEportZoningDB.createZone(string);
        if (zone == null || zoneSet == null) {
            return false;
        }
        return this.tempEportZoningDB.addZoneToSet(zone, zoneSet) == 0;
    }

    private boolean getFirstZoneInSet(ZoneSet zoneSet) {
        return this.getNextZoneInSet(zoneSet, 0);
    }

    private boolean getNextZoneInSet(ZoneSet zoneSet, int n) {
        return this.utilAgent.getZonesInAZoneSet(this.sanbox, this, zoneSet.getName(), (byte)n);
    }

    private boolean getFirstMemberInZone(Zone zone) {
        return this.getNextMemberInZone(zone, 0);
    }

    private boolean getNextMemberInZone(Zone zone, int n) {
        return this.utilAgent.getMembersInAZone(this.sanbox, this, zone.getName(), n);
    }

    private boolean finshedGettingZones() {
        if (this.eportZoningState != 1) {
            return false;
        }
        Zone zone = this.tempEportZoningDB.getFirstZone();
        if (zone != null) {
            return this.getFirstMemberInZone(zone);
        }
        return this.getActiveZoneSet();
    }

    private boolean addZoneMembers(Zone zone, Vector vector) {
        if (this.eportZoningState != 1) {
            return false;
        }
        Vector<ZoneMember> vector2 = new Vector<ZoneMember>();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            ZoneMember zoneMember = this.tempEportZoningDB.createZoneMember(string);
            if (zone != null && zoneMember != null) {
                vector2.add(zoneMember);
            }
            ++n;
        }
        if (vector2.size() > 0) {
            return this.tempEportZoningDB.addZoneMembersToZone(zone, vector2) == 0;
        }
        return false;
    }

    private boolean finishedLoadingZoneMembers() {
        if (this.eportZoningState != 1) {
            return false;
        }
        return this.getActiveZoneSet();
    }

    private boolean setActiveZoneSet(ZoneSet zoneSet) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (zoneSet != null) {
            this.tempEportZoningDB.setActiveZoneSet(zoneSet);
        }
        return this.finishedGettingActiveZoneSetName();
    }

    private void newZoningState(int n) {
        this.eportZoningState = n;
    }

    private boolean getActiveZoneSet() {
        return this.utilAgent.getActiveZoneSet(this.sanbox, this);
    }

    private boolean finishedGettingActiveZoneSetName() {
        if (this.eportZoningState != 1) {
            return false;
        }
        return this.finishedLoadingEportZoning();
    }

    public boolean finishedLoadingEportZoning() {
        if (this.eportZoningState != 1) {
            return false;
        }
        this.newZoningState(0);
        this.eportZoningDB = this.tempEportZoningDB;
        this.eportZoningDB.setCurrentWithSwitch(true);
        this.eventHandler.fireChassisEvent(241, (Object)this.eportZoningDB, true);
        return true;
    }
}

