/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.device.fcfabric.util.SanboxZoningUtilLoad;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgActivateZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAddMembersToZone;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAddZonesToZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgClearZoning;
import com.qlogic.device.fcfabric.util.messages.UtilMsgCommitZoning;
import com.qlogic.device.fcfabric.util.messages.UtilMsgCreateZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetActiveZoneSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetZoningConfig;
import com.qlogic.device.fcfabric.zoning.SanboxZones;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.util.Vector;

public class SanboxZoningUtilApply
implements UtilEventListener {
    private static final long APPLY_TIMEOUT = 120000L;
    UtilDestination destination;
    SanboxUtil sanbox;
    UtilAgent utilAgent;
    ChassisEventHandler eventHandler;
    SanboxZoningUtilLoad loader;
    Thread savingThread;
    ErrorType applyErrorType = null;
    SanboxZones tempEportZoningDB = new SanboxZones();
    private static final int E_PORT_ZONING_STATE_IDLE = 0;
    private static final int E_PORT_ZONING_STATE_SAVING = 3;
    private static final int E_PORT_ZONING_STATE_ACTIVATION = 5;
    private static final int E_PORT_ZONING_STATE_DEACTIVATION = 6;
    private static final int E_PORT_ZONING_STATE_APPLYING_CONFIG = 7;
    private int eportZoningState = 0;

    SanboxZoningUtilApply(UtilAgent utilAgent, SanboxUtil sanboxUtil, ChassisEventHandler chassisEventHandler, SanboxZoningUtilLoad sanboxZoningUtilLoad) {
        this.utilAgent = utilAgent;
        this.destination = sanboxUtil;
        this.sanbox = sanboxUtil;
        this.eventHandler = chassisEventHandler;
        this.loader = sanboxZoningUtilLoad;
    }

    private void resetApplyReason() {
        this.applyErrorType = null;
    }

    protected void setApplyReason(ErrorType errorType) {
        if (this.applyErrorType == null) {
            this.applyErrorType = errorType;
        }
    }

    public boolean applyEPortZoning(Zones zones) {
        if (!(zones instanceof SanboxZones)) {
            return false;
        }
        if (this.savingThread != null) {
            return false;
        }
        switch (this.eportZoningState) {
            case 0: {
                this.newZoningState(3);
                break;
            }
            default: {
                return false;
            }
        }
        this.resetApplyReason();
        this.tempEportZoningDB = (SanboxZones)zones;
        this.savingThread = new Thread(new SavingThread());
        this.savingThread.start();
        return true;
    }

    public synchronized boolean cancelEPortZoningSave() {
        this.newZoningState(0);
        this.eventHandler.fireChassisEvent(242, null, this.applyErrorType);
        this.notifyAll();
        this.savingThread = null;
        return true;
    }

    public boolean applyActivateZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null) {
            this.newZoningState(5);
            return this.utilAgent.activateAZoneSet(this.destination, this, zoneSet.getName(), true);
        }
        return false;
    }

    public boolean applyDeactivateZoneSet() {
        this.newZoningState(6);
        ZoneSet zoneSet = this.loader.getZones().getActiveZoneSet();
        if (zoneSet != null) {
            return this.utilAgent.activateAZoneSet(this.destination, this, zoneSet.getName(), false);
        }
        return false;
    }

    public void receiveMessage(UtilMessage utilMessage) {
        Object object;
        if (utilMessage.getStatus() != 103) {
            this.setApplyReason(utilMessage.getErrorType());
            if (this.destination instanceof SanboxUtil) {
                object = (SanboxUtil)this.destination;
                ((SanboxUtil)object).receiveMessage(utilMessage);
            }
        }
        if (utilMessage instanceof UtilMsgActivateZoneSet) {
            object = (UtilMsgActivateZoneSet)utilMessage;
            if (((UtilMsgActivateZoneSet)object).getActivate()) {
                this.finishedActivation(utilMessage.getErrorType());
            } else {
                this.finishedDeactivation(utilMessage.getErrorType());
            }
        }
        if (utilMessage instanceof UtilMsgSetZoningConfig) {
            object = (UtilMsgSetZoningConfig)utilMessage;
            this.newZoningState(0);
            this.sanbox.getZoningConfig().setDefaultVisibility(((UtilMsgSetZoningConfig)object).getZoneVisibility());
            this.eventHandler.fireChassisEvent(278, null, utilMessage.getErrorType());
        }
    }

    private void finishedActivation(ErrorType errorType) {
        this.newZoningState(0);
        this.eventHandler.fireChassisEvent(247, null, errorType);
    }

    private void finishedDeactivation(ErrorType errorType) {
        this.newZoningState(0);
        this.eventHandler.fireChassisEvent(260, null, errorType);
    }

    public boolean applyZoningConfig(ZoningConfig zoningConfig) {
        this.newZoningState(7);
        return this.utilAgent.setZoningConfig(this.destination, this, zoningConfig);
    }

    private void newZoningState(int n) {
        this.eportZoningState = n;
    }

    public class SavingThread
    implements Runnable,
    UtilEventListener {
        boolean committNeeded = false;
        boolean activateNeeded = false;
        boolean resendInactive = false;
        boolean deactivateNeeded = false;
        public static final int SITUATION_A = 0;
        public static final int SITUATION_B = 1;
        public static final int SITUATION_C = 2;
        public static final int SITUATION_D = 3;
        public static final int SITUATION_E = 4;
        public static final int SITUATION_F = 5;
        public static final int SITUATION_G = 6;
        String activeZoneSetStr = null;
        UtilMessage messageIn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SavingThread savingThread = this;
            synchronized (savingThread) {
                if (!this.saveZones()) {
                    SanboxZoningUtilApply.this.cancelEPortZoningSave();
                }
            }
            SanboxZoningUtilApply.this.savingThread = null;
        }

        private boolean saveZones() {
            SanboxZoningUtilApply.this.utilAgent.getActiveZoneSet(SanboxZoningUtilApply.this.destination, this);
            if (!this.waitAndCheckForCancel()) {
                return false;
            }
            int n = -1;
            ZoneSet zoneSet = SanboxZoningUtilApply.this.tempEportZoningDB.getActiveZoneSet();
            if (zoneSet != null) {
                if (zoneSet.getName().equals(this.activeZoneSetStr)) {
                    if (zoneSet.getDirtyFlag()) {
                        n = this.activeZoneSetStr.length() > 0 ? 4 : 3;
                    } else if (this.activeZoneSetStr.length() > 0) {
                        n = 2;
                    }
                } else {
                    n = this.activeZoneSetStr.length() > 0 ? 6 : 5;
                }
            } else {
                n = this.activeZoneSetStr.length() > 0 ? 1 : 0;
            }
            if (n == 1) {
                SanboxZoningUtilApply.this.utilAgent.activateAZoneSet(SanboxZoningUtilApply.this.destination, this, this.activeZoneSetStr, false);
                if (!this.waitAndCheckForCancel()) {
                    return false;
                }
            }
            if (n == 3 || n == 4 || n == 5 || n == 6) {
                SanboxZoningUtilApply.this.utilAgent.clearZoning(SanboxZoningUtilApply.this.destination, this, (byte)1);
                if (!this.waitAndCheckForCancel()) {
                    return false;
                }
            }
            if (n == 4 || n == 6) {
                SanboxZoningUtilApply.this.utilAgent.clearZoning(SanboxZoningUtilApply.this.destination, this, (byte)2);
                if (!this.waitAndCheckForCancel()) {
                    return false;
                }
            }
            if (!(n != 3 && n != 4 && n != 5 || this.writeZoningDB(true, true))) {
                return false;
            }
            if (n == 6 && !this.writeZoningDB(true, false)) {
                return false;
            }
            if (n == 4) {
                SanboxZoningUtilApply.this.utilAgent.commitZoning(SanboxZoningUtilApply.this.destination, this);
                if (!this.waitAndCheckForCancel()) {
                    return false;
                }
            }
            if ((n == 3 || n == 5 || n == 6) && (zoneSet = SanboxZoningUtilApply.this.tempEportZoningDB.getActiveZoneSet()) != null) {
                SanboxZoningUtilApply.this.utilAgent.activateAZoneSet(SanboxZoningUtilApply.this.destination, this, zoneSet.getName(), true);
                if (!this.waitAndCheckForCancel()) {
                    return false;
                }
            }
            if (n == 0 || n == 1 || n == 2 || n == 6) {
                SanboxZoningUtilApply.this.utilAgent.clearZoning(SanboxZoningUtilApply.this.destination, this, (byte)1);
                if (!this.waitAndCheckForCancel()) {
                    return false;
                }
                if (!this.writeZoningDB(false, true)) {
                    return false;
                }
            }
            SanboxZoningUtilApply.this.newZoningState(0);
            SanboxZoningUtilApply.this.eventHandler.fireChassisEvent(242, null, true);
            return true;
        }

        public boolean writeZoningDB(boolean bl, boolean bl2) {
            boolean bl3;
            Zone zone;
            ZoneSet zoneSet = SanboxZoningUtilApply.this.tempEportZoningDB.getActiveZoneSet();
            ZoneSet zoneSet2 = SanboxZoningUtilApply.this.tempEportZoningDB.getOrphanZoneSet();
            ZoneSet zoneSet3 = SanboxZoningUtilApply.this.tempEportZoningDB.getFirstZoneSet();
            while (zoneSet3 != null) {
                if (bl && zoneSet3 == zoneSet || bl2 && zoneSet3 != zoneSet) {
                    if (!this.createZoneSet(zoneSet3)) {
                        return false;
                    }
                    if (!this.waitAndCheckForCancel()) {
                        return false;
                    }
                }
                zoneSet3 = SanboxZoningUtilApply.this.tempEportZoningDB.getNextZoneSet(zoneSet3);
            }
            zoneSet3 = SanboxZoningUtilApply.this.tempEportZoningDB.getFirstZoneSet();
            while (zoneSet3 != null) {
                if ((bl && zoneSet3 == zoneSet || bl2 && zoneSet3 != zoneSet) && zoneSet3.getFirstZone() != null) {
                    zone = null;
                    bl3 = false;
                    byte by = 0;
                    while (!bl3) {
                        byte by2 = by;
                        by = (byte)(by + 1);
                        if ((zone = this.fillZoneSet(zoneSet3, zone, by2)) != null) {
                            if (this.waitAndCheckForCancel()) continue;
                            return false;
                        }
                        bl3 = true;
                    }
                }
                zoneSet3 = SanboxZoningUtilApply.this.tempEportZoningDB.getNextZoneSet(zoneSet3);
            }
            zone = SanboxZoningUtilApply.this.tempEportZoningDB.getFirstZone();
            while (zone != null) {
                boolean bl4 = bl3 = zoneSet2.findZone(zone.getName()) == null;
                if (bl3) {
                    boolean bl5 = false;
                    if (zoneSet != null && zoneSet.findZone(zone.getName()) != null) {
                        bl5 = true;
                    }
                    if (bl5) {
                        if (!bl) {
                            bl3 = false;
                        }
                    } else if (!bl2) {
                        bl3 = false;
                    }
                }
                if (bl3 && zone.getFirstMember() != null) {
                    ZoneMember zoneMember = null;
                    boolean bl6 = false;
                    byte by = 0;
                    while (!bl6) {
                        byte by3 = by;
                        by = (byte)(by + 1);
                        if ((zoneMember = this.fillZone(zone, zoneMember, by3)) != null) {
                            if (this.waitAndCheckForCancel()) continue;
                            return false;
                        }
                        bl6 = true;
                    }
                }
                zone = SanboxZoningUtilApply.this.tempEportZoningDB.getNextZone(zone);
            }
            return true;
        }

        public boolean waitAndCheckForCancel() {
            int n = SanboxZoningUtilApply.this.eportZoningState;
            long l = System.currentTimeMillis();
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            if (System.currentTimeMillis() > l + 120000L) {
                return false;
            }
            return SanboxZoningUtilApply.this.eportZoningState == n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(UtilMessage utilMessage) {
            SavingThread savingThread = this;
            synchronized (savingThread) {
                Object object;
                if (utilMessage.getStatus() != 103) {
                    SanboxZoningUtilApply.this.setApplyReason(utilMessage.getErrorType());
                    if (SanboxZoningUtilApply.this.destination instanceof SanboxUtil) {
                        object = (SanboxUtil)SanboxZoningUtilApply.this.destination;
                        ((SanboxUtil)object).receiveMessage(utilMessage);
                    }
                }
                if (utilMessage instanceof UtilMsgClearZoning) {
                    object = (UtilMsgClearZoning)utilMessage;
                    if (((UtilMessage)object).getStatus() == 103) {
                        this.messageIn = utilMessage;
                    } else {
                        FabricUtilities.logMessage("Failed clearing zoning");
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
                if (utilMessage instanceof UtilMsgCreateZoneSet) {
                    if (utilMessage.getStatus() != 103) {
                        FabricUtilities.logMessage("Failed UtilMsgCreateZoneSet" + utilMessage.getDataTransfered());
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
                if (utilMessage instanceof UtilMsgAddZonesToZoneSet) {
                    if (utilMessage.getStatus() != 103) {
                        FabricUtilities.logMessage("Failed UtilMsgAddZonesToZoneSet" + utilMessage.getDataTransfered());
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
                if (utilMessage instanceof UtilMsgAddMembersToZone) {
                    if (utilMessage.getStatus() != 103) {
                        FabricUtilities.logMessage("Failed UtilMsgAddMembersToZone" + utilMessage.getDataTransfered());
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
                if (utilMessage instanceof UtilMsgCommitZoning) {
                    if (utilMessage.getStatus() != 103) {
                        FabricUtilities.logMessage("Failed UtilMsgCommitZoning" + utilMessage.getDataTransfered());
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
                if (utilMessage instanceof UtilMsgActivateZoneSet) {
                    object = (UtilMsgActivateZoneSet)utilMessage;
                    if (utilMessage.getStatus() != 103) {
                        FabricUtilities.logMessage("Failed UtilMsgActivateZoneSet" + utilMessage.getDataTransfered());
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
                if (utilMessage instanceof UtilMsgGetActiveZoneSet) {
                    if (utilMessage.getStatus() == 103) {
                        object = (UtilMsgGetActiveZoneSet)utilMessage;
                        this.activeZoneSetStr = ((UtilMsgGetActiveZoneSet)object).getActiveZoneSetName();
                    } else {
                        FabricUtilities.logMessage("Failed UtilMsgGetActiveZoneSet" + utilMessage.getDataTransfered());
                        SanboxZoningUtilApply.this.cancelEPortZoningSave();
                    }
                    this.notifyAll();
                }
            }
        }

        private boolean createZoneSet(ZoneSet zoneSet) {
            if (SanboxZoningUtilApply.this.eportZoningState != 3) {
                return false;
            }
            return SanboxZoningUtilApply.this.utilAgent.createZoneSet(SanboxZoningUtilApply.this.destination, this, zoneSet.getName());
        }

        private Zone fillZoneSet(ZoneSet zoneSet, Zone zone, byte by) {
            Zone zone2 = zone == null ? zoneSet.getFirstZone() : zoneSet.getNextZone(zone);
            zone = null;
            Vector<String> vector = new Vector<String>();
            while (zone2 != null && vector.size() < 6) {
                vector.add(zone2.getName());
                zone = zone2;
                zone2 = zoneSet.getNextZone(zone2);
            }
            if (vector.size() > 0) {
                SanboxZoningUtilApply.this.utilAgent.addZonesToAZoneSet(SanboxZoningUtilApply.this.destination, this, zoneSet.getName(), vector, by, zone2 == null);
            }
            return zone;
        }

        private ZoneMember fillZone(Zone zone, ZoneMember zoneMember, byte by) {
            ZoneMember zoneMember2 = zoneMember == null ? zone.getFirstMember() : zone.getNextMember(zoneMember);
            Vector<String> vector = new Vector<String>();
            zoneMember = null;
            while (zoneMember2 != null && vector.size() < 34) {
                vector.add(zoneMember2.getMemberStorageString());
                zoneMember = zoneMember2;
                zoneMember2 = zone.getNextMember(zoneMember2);
            }
            if (vector.size() > 0) {
                SanboxZoningUtilApply.this.utilAgent.addMembersToAZone(SanboxZoningUtilApply.this.destination, this, zone.getName(), vector, by, zoneMember2 == null);
            }
            return zoneMember;
        }
    }
}

