/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.LoopbackPortTestResult;
import com.qlogic.device.fcfabric.NameServerEntry;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.SanboxPerfMonResult;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.TrapLog;
import com.qlogic.device.fcfabric.Updater;
import com.qlogic.device.fcfabric.User;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.archiver.SanboxArchiver;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.util.FCSanboxPortStatisticsUtil;
import com.qlogic.device.fcfabric.util.FCSanboxSwitchStatisticsUtil;
import com.qlogic.device.fcfabric.util.NameServerEntryUtil;
import com.qlogic.device.fcfabric.util.SanboxTopologyUtil;
import com.qlogic.device.fcfabric.util.SanboxZoningUtilApply;
import com.qlogic.device.fcfabric.util.SanboxZoningUtilLoad;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgActiveTLConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAllActiveAdminPortTypes;
import com.qlogic.device.fcfabric.util.messages.UtilMsgAllPortsStates;
import com.qlogic.device.fcfabric.util.messages.UtilMsgBeaconSet;
import com.qlogic.device.fcfabric.util.messages.UtilMsgBeaconStatusReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgChassisMode;
import com.qlogic.device.fcfabric.util.messages.UtilMsgChassisStatusReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgClearZoning;
import com.qlogic.device.fcfabric.util.messages.UtilMsgDelayedSwReset;
import com.qlogic.device.fcfabric.util.messages.UtilMsgEPortIsolationReason;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetAllPortCounters;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetAllSwitchInternalCounters;
import com.qlogic.device.fcfabric.util.messages.UtilMsgGetTimeStamp;
import com.qlogic.device.fcfabric.util.messages.UtilMsgIpConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgLoginRequest;
import com.qlogic.device.fcfabric.util.messages.UtilMsgMemoryWrite;
import com.qlogic.device.fcfabric.util.messages.UtilMsgModelCfgReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNameServerGetAllNextFabricUnzoned;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTReset;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTStart;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTStatus;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLTStop;
import com.qlogic.device.fcfabric.util.messages.UtilMsgRscn;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSaveActiveTLConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSaveAllAdminPortTypes;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSensorStatus;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetAllActivePortAdminStates;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSetAllActivePortTypes;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSnmpCommunities;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSnmpConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSwitchConfigurationParameters;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSysCfgReq;
import com.qlogic.device.fcfabric.util.messages.UtilMsgTraceControl;
import com.qlogic.device.fcfabric.util.messages.UtilMsgTraceRequest;
import com.qlogic.device.fcfabric.util.messages.UtilMsgTrapConfig;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class SanboxUtil
extends Sanbox
implements UtilDestination,
UtilEventListener {
    private SanboxTopologyUtil topoUtil;
    private SanboxZoningUtilLoad zoningUtilLoad;
    private SanboxZoningUtilApply zoningUtilApply;
    private Vector nameServerEntryList = new Vector();
    private NameServerEntryUtil nameServerEntry;
    protected UtilAgent utilAgent;
    private int promHwVersion;
    private int promSwVersion;
    protected int modelType = 0;
    public static final long PERF_MON_POLLING_INTERVAL = 1000L;
    private long normalPortStatPollingInterval;
    private boolean perfMonPollingActive = false;
    private TrapLog traceLog = new TrapLog();
    private TrapLog tempTraceLog = new TrapLog();
    private int traceControlFlag;
    private boolean resettingToFactoryDefaults = false;
    private boolean getFanStatusFromPowerSupplyStatus = false;
    LoopbackPortTestResult[] loopbackResults;
    SanboxArchiver archiver = new SanboxArchiver();

    public SanboxUtil(UtilMsgVersionReq utilMsgVersionReq, UtilAgent utilAgent) {
        super(utilAgent);
        this.comAgent = utilAgent;
        this.utilAgent = utilAgent;
        this.setChassisName("unknown");
        this.nameServerEntry = new NameServerEntryUtil();
        this.saveVersionRequest(utilMsgVersionReq);
        this.topoUtil = new SanboxTopologyUtil(utilAgent, this, this.eventHandler);
        this.zoningUtilLoad = new SanboxZoningUtilLoad(utilAgent, this, this.eventHandler);
        this.zoningUtilApply = new SanboxZoningUtilApply(utilAgent, this, this.eventHandler, this.zoningUtilLoad);
        this.createUpdaters();
    }

    public SanboxUtil(String string, WorldWideName worldWideName, int n, UtilAgent utilAgent) {
        super(utilAgent);
        this.comAgent = utilAgent;
        this.utilAgent = utilAgent;
        this.setChassisName(string == null ? "unknown" : string);
        this.saveChassisType(n);
        this.WWName = worldWideName;
        this.topoUtil = new SanboxTopologyUtil(utilAgent, this, this.eventHandler);
        this.zoningUtilLoad = new SanboxZoningUtilLoad(utilAgent, this, this.eventHandler);
        this.zoningUtilApply = new SanboxZoningUtilApply(utilAgent, this, this.eventHandler, this.zoningUtilLoad);
        this.createUpdaters();
    }

    public SanboxChassisArchiver getArchiver() {
        return this.archiver;
    }

    public User getLoginInfo() {
        return this.utilAgent.getLoginInfo();
    }

    public boolean useVersion_0() {
        return this.promHwVersion != 0 && (this.promHwVersion & 0xFF) == 2;
    }

    public boolean isTimedOut(UtilMessage utilMessage) {
        return System.currentTimeMillis() - utilMessage.getTimeSent() > (long)utilMessage.getTimeoutValue();
    }

    public int getExtCreditMode(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 0 || n % 4 == 0) {
            if (n + 3 < this.portCount) {
                if (this.s43PortList[n + 3].getDonorMode() == 6) {
                    return 3;
                }
                if (this.s43PortList[n + 2].getDonorMode() == 6) {
                    return 2;
                }
                if (this.s43PortList[n + 1].getDonorMode() == 6) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean isExtCreditModeValid(int n, int n2) {
        if (n + 3 >= this.portCount) {
            return false;
        }
        PortStates portStates = this.s43PortList[n].getPortStates();
        if (portStates == null) {
            return false;
        }
        if (portStates.getPortType() == 5 && n2 != 0) {
            return false;
        }
        PortStates portStates2 = this.s43PortList[n + 1].getPortStates();
        PortStates portStates3 = this.s43PortList[n + 2].getPortStates();
        PortStates portStates4 = this.s43PortList[n + 3].getPortStates();
        if (portStates2 == null || portStates3 == null || portStates4 == null) {
            return false;
        }
        if (n == 0 || n % 4 == 0) {
            switch (n2) {
                case 0: {
                    return true;
                }
                case 1: {
                    if (portStates2.getPortType() != 7 && portStates2.getPortType() != 5) {
                        return true;
                    }
                }
                case 2: {
                    if (portStates2.getPortType() != 7 && portStates3.getPortType() != 7 && portStates2.getPortType() != 5 && portStates3.getPortType() != 5) {
                        return true;
                    }
                }
                case 3: {
                    if (portStates2.getPortType() == 7 || portStates3.getPortType() == 7 || portStates4.getPortType() == 7 || portStates2.getPortType() == 5 || portStates3.getPortType() == 5 || portStates4.getPortType() == 5) break;
                    return true;
                }
            }
        }
        return false;
    }

    public TrapLog getTrapLog() {
        return this.traceLog;
    }

    public LoopbackPortTestResult[] getLoopbackTestResults() {
        return this.loopbackResults;
    }

    public Zones getEportZoningDb() {
        return this.zoningUtilLoad.getZones();
    }

    public Zones getActiveEportZoning() {
        return this.zoningUtilLoad.getActiveZones();
    }

    public int getConfiguredDomainId() {
        return this.getDomainId();
    }

    public String getConfiguredDomainIdString() {
        return this.getDomainIdString();
    }

    public int getModelType() {
        return this.modelType;
    }

    public boolean updateChassisInfo() {
        return this.utilAgent.getChassisStatus(this, this);
    }

    public boolean updateSensorStatus() {
        return this.utilAgent.getSensorStatus(this, this);
    }

    public boolean updateTrapInfo() {
        boolean bl;
        this.tempTraceLog = new TrapLog();
        boolean bl2 = bl = this.utilAgent.getTraceLog(this, this, 0, 240) && this.utilAgent.getTraceLogControlFlag(this, this);
        if (!this.editingTrapConfig) {
            bl &= this.utilAgent.getTraceConfig(this, this);
        }
        return bl;
    }

    public boolean applyTrapConfig() {
        return this.utilAgent.setTrapConfig(this, this, this.trapsEnabled, this.sampleInterval, this.getFcAddress(), this.risingThresholds, this.fallingThresholds, this.enableArray);
    }

    public boolean clearTrapLog() {
        int n = this.traceControlFlag | 0x20000000;
        return this.utilAgent.sendTraceLogControlFlag(this, this, n);
    }

    public boolean updateIpInfo() {
        return this.utilAgent.getIpConfig(this, this);
    }

    public boolean applyIpInfo(IPInfo iPInfo) {
        if (iPInfo == null) {
            return false;
        }
        UtilMsgIpConfig utilMsgIpConfig = new UtilMsgIpConfig();
        utilMsgIpConfig.setAddress(iPInfo.getIpAddress());
        utilMsgIpConfig.setMask(iPInfo.getNetMask());
        utilMsgIpConfig.setBroadcast(iPInfo.getBroadcast());
        utilMsgIpConfig.setGateway(iPInfo.getGateway());
        utilMsgIpConfig.setUseBootp(iPInfo.getIpBootProcess());
        utilMsgIpConfig.setArpTimeout(iPInfo.getArpTimeout());
        return this.utilAgent.setIpConfig(this, this, utilMsgIpConfig);
    }

    public boolean applyLoopbackTest(int n, int n2) {
        switch (n2) {
            case 3: {
                UtilMsgOLTStart utilMsgOLTStart = new UtilMsgOLTStart();
                utilMsgOLTStart.setPortNumber(n);
                return this.utilAgent.startLoopbackTest(this, this, utilMsgOLTStart);
            }
            case 4: {
                UtilMsgOLTStop utilMsgOLTStop = new UtilMsgOLTStop();
                return this.utilAgent.stopLoopbackTest(this, this, utilMsgOLTStop);
            }
            case 5: {
                UtilMsgOLTReset utilMsgOLTReset = new UtilMsgOLTReset();
                return this.utilAgent.resetLoopbackTest(this, this, utilMsgOLTReset);
            }
        }
        return false;
    }

    public boolean applyOnlineLoopbackTest(int n, long l, int n2, long l2, boolean bl) {
        UtilMsgOLTStart utilMsgOLTStart = new UtilMsgOLTStart();
        utilMsgOLTStart.setPortNumber(n);
        utilMsgOLTStart.setTestCount((int)l);
        utilMsgOLTStart.setLength(n2);
        utilMsgOLTStart.setPattern((int)l2);
        utilMsgOLTStart.setStopOnError(bl);
        return this.utilAgent.startLoopbackTest(this, this, utilMsgOLTStart);
    }

    public boolean applyChassisMode(int n) {
        return this.utilAgent.setChassisMode(this, this, n);
    }

    public boolean resetToFactoryDefaults() {
        byte[] byArray = new byte[]{0};
        return this.utilAgent.writeMemory(this, this, -1073741824, byArray);
    }

    public boolean resetDefaultZoning() {
        return this.utilAgent.clearZoning(this, this, (byte)0);
    }

    protected void saveIpConfigRequest(UtilMsgIpConfig utilMsgIpConfig) {
        int n = utilMsgIpConfig.getStatus();
        if (n != 103) {
            if (utilMsgIpConfig.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(202, (Object)this.ipInfo, utilMsgIpConfig.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(201, (Object)this.ipInfo, utilMsgIpConfig.getErrorType());
            }
            return;
        }
        if (utilMsgIpConfig.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(202, (Object)this.ipInfo, true);
        } else {
            IPInfo iPInfo = new IPInfo();
            iPInfo.setIpAddress(utilMsgIpConfig.getAddress());
            iPInfo.setNetMask(utilMsgIpConfig.getMask());
            iPInfo.setBroadcast(utilMsgIpConfig.getBroadcast());
            iPInfo.setGateway(utilMsgIpConfig.getGateway());
            iPInfo.setIpBootProcess(utilMsgIpConfig.getUseBootp());
            iPInfo.setArpTimeout(utilMsgIpConfig.getArpTimeout());
            this.setIpInfo(iPInfo);
            this.eventHandler.fireChassisEvent(201, (Object)this.ipInfo, true);
        }
    }

    protected void saveChassisStatusRequest(UtilMsgChassisStatusReq utilMsgChassisStatusReq) {
        int n = utilMsgChassisStatusReq.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(200, null, utilMsgChassisStatusReq.getErrorType());
            return;
        }
        this.inOrderDelivery = utilMsgChassisStatusReq.getInOrderDeliveryOn() != 0;
        this.temperatureStatus = utilMsgChassisStatusReq.getBoardHeatStatus();
        this.temperature = utilMsgChassisStatusReq.getBoardTemperature() / 2;
        int n2 = utilMsgChassisStatusReq.getNumberOfPorts();
        int n3 = 0;
        while (n3 < n2) {
            FCPort fCPort = this.getPort(n3);
            fCPort.setFcAddress(utilMsgChassisStatusReq.getPortFcAddress(n3));
            fCPort.setGbicType(utilMsgChassisStatusReq.getGbicTypes(n3));
            ++n3;
        }
        this.eventHandler.fireChassisEvent(200, null, true);
    }

    protected void saveSensorStatus(UtilMsgSensorStatus utilMsgSensorStatus) {
        int n;
        int n2 = utilMsgSensorStatus.getStatus();
        if (n2 != 103) {
            this.eventHandler.fireChassisEvent(295, null, utilMsgSensorStatus.getErrorType());
            return;
        }
        int n3 = 0;
        while (n3 < this.powerSupplyCount) {
            switch (n3) {
                case 0: {
                    n = utilMsgSensorStatus.getPowerSupplyOneStatus();
                    if (n != 6) {
                        this.powerSupplyStatus[0] = SanboxUtil.convertSensorStatus(n);
                        break;
                    }
                    this.powerSupplyStatus[0] = 4;
                    break;
                }
                case 1: {
                    n = utilMsgSensorStatus.getPowerSupplyTwoStatus();
                    this.powerSupplyStatus[1] = n != 6 ? SanboxUtil.convertSensorStatus(n) : 4;
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.fanCount) {
            switch (n4) {
                case 0: {
                    if (this.getFanStatusFromPowerSupplyStatus) {
                        this.fanStatus[0] = SanboxUtil.convertSensorStatus(utilMsgSensorStatus.getPowerSupplyOneStatus());
                        break;
                    }
                    this.fanStatus[0] = SanboxUtil.convertSensorStatus(utilMsgSensorStatus.getFanOneStatus());
                    break;
                }
                case 1: {
                    if (this.getFanStatusFromPowerSupplyStatus) {
                        this.fanStatus[1] = SanboxUtil.convertSensorStatus(utilMsgSensorStatus.getPowerSupplyTwoStatus());
                        break;
                    }
                    this.fanStatus[1] = SanboxUtil.convertSensorStatus(utilMsgSensorStatus.getFanTwoStatus());
                    break;
                }
                case 2: {
                    n = utilMsgSensorStatus.getFanThreeStatus();
                    this.fanStatus[2] = n != 6 ? SanboxUtil.convertSensorStatus(n) : 4;
                }
            }
            ++n4;
        }
        this.temperatureSensorStatus = new int[3];
        this.temperatureSensorDegrees = new int[3];
        int n5 = 0;
        n = utilMsgSensorStatus.getTempOneStatus();
        if (n != 6) {
            this.temperatureSensorDegrees[0] = utilMsgSensorStatus.getTempOne() / 2;
            this.temperatureSensorStatus[0] = SanboxUtil.convertSensorStatus(n);
            ++n5;
        } else {
            this.temperatureSensorStatus[0] = 4;
        }
        n = utilMsgSensorStatus.getTempTwoStatus();
        if (n != 6) {
            this.temperatureSensorDegrees[0] = utilMsgSensorStatus.getTempTwo() / 2;
            this.temperatureSensorStatus[1] = SanboxUtil.convertSensorStatus(n);
            ++n5;
        } else {
            this.temperatureSensorStatus[1] = 4;
        }
        n = utilMsgSensorStatus.getTempThreeStatus();
        if (n != 6) {
            this.temperatureSensorDegrees[0] = utilMsgSensorStatus.getTempThree() / 2;
            this.temperatureSensorStatus[2] = SanboxUtil.convertSensorStatus(n);
            ++n5;
        } else {
            this.temperatureSensorStatus[2] = 4;
        }
        this.setTemperatureSensorCount(n5);
        this.eventHandler.fireChassisEvent(295, null, true);
    }

    protected static int convertSensorStatus(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 4;
    }

    public boolean updateLsdb() {
        return this.topoUtil.updateEPortTopology();
    }

    public boolean updateVersion() {
        return this.utilAgent.getVersion(this, this);
    }

    public boolean updateBeacon() {
        return this.utilAgent.getBeacon(this, this);
    }

    public boolean updateModelType() {
        return this.utilAgent.getModelType(this, this);
    }

    public boolean updateSysCfg() {
        return this.utilAgent.getSysCfg(this, this);
    }

    public boolean updateSnmpInfo() {
        return this.utilAgent.getSnmpConfig(this, this) && this.utilAgent.getSnmpCommunityInfo(this, this);
    }

    public boolean updateLoopbackTestStatus() {
        return this.utilAgent.getLoopbackTestStatus(this, this);
    }

    private boolean updateChassisMode() {
        return this.utilAgent.getOperationalChassisMode(this, this) && this.utilAgent.getAdminChassisMode(this, this);
    }

    public boolean updateActiveAdminPortTypes() {
        return this.utilAgent.getAllActiveAdminPortTypes(this, this);
    }

    public boolean updatePortStates() {
        return this.utilAgent.getAllPortsStates(this, this);
    }

    public boolean updateNameServerInfo() {
        if (!this.acquiringNameServerInfo) {
            this.acquiringNameServerInfo = true;
            this.nameServerEntryList = new Vector();
            return this.utilAgent.getNameServerGetAllNext(this, this, 0);
        }
        return true;
    }

    private boolean getNextNameServerInfo(int n) {
        return this.utilAgent.getNameServerGetAllNext(this, this, n);
    }

    public boolean updatePortStatistics() {
        int n = 0;
        while (n < this.portCount) {
            if (!this.utilAgent.getAllPortCounters(this, this, (byte)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean updateChassisStatistics() {
        return this.utilAgent.getAllSwitchInternalCounters(this, this);
    }

    public boolean updateSwitchConfig() {
        return this.utilAgent.getActiveSwitchConfigurationParameters(this, this);
    }

    public boolean applySnmpInfo(SnmpInfo snmpInfo) {
        UtilMsgSnmpConfig utilMsgSnmpConfig = new UtilMsgSnmpConfig();
        if (snmpInfo == null) {
            return false;
        }
        utilMsgSnmpConfig.setName(snmpInfo.getName());
        utilMsgSnmpConfig.setContact(snmpInfo.getContact());
        utilMsgSnmpConfig.setLocation(snmpInfo.getLocation());
        utilMsgSnmpConfig.setDoAuthTrap((int)snmpInfo.getDoAuthTrap());
        utilMsgSnmpConfig.setTrapAddress(snmpInfo.getTrapAddress());
        return this.utilAgent.setSnmpConfig(this, this, utilMsgSnmpConfig);
    }

    public boolean applyExtCredits(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        byte[] byArray = new byte[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            byArray[n] = (byte)this.s43PortList[n].getDonorMode();
            ++n;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            S43Port s43Port = this.s43PortList[nArray[n3]];
            int n4 = s43Port.getPortNumber();
            if (n4 == 0 || n4 % 4 == 0) {
                int n5 = n3 * 4;
                switch (nArray2[n3]) {
                    case 0: {
                        if (byArray[n5 + 1] != 5) {
                            byArray[n5 + 1] = 1;
                        }
                        if (byArray[n5 + 2] != 5) {
                            byArray[n5 + 2] = 1;
                        }
                        if (byArray[n5 + 3] == 5) break;
                        byArray[n5 + 3] = 1;
                        break;
                    }
                    case 1: {
                        byArray[n5 + 1] = 6;
                        if (byArray[n5 + 2] != 5) {
                            byArray[n5 + 2] = 1;
                        }
                        if (byArray[n5 + 3] == 5) break;
                        byArray[n5 + 3] = 1;
                        break;
                    }
                    case 2: {
                        byArray[n5 + 1] = 6;
                        byArray[n5 + 2] = 6;
                        if (byArray[n5 + 3] == 5) break;
                        byArray[n5 + 3] = 1;
                        break;
                    }
                    case 3: {
                        byArray[n5 + 1] = 6;
                        byArray[n5 + 2] = 6;
                        byArray[n5 + 3] = 6;
                    }
                }
            }
            ++n3;
        }
        this.applyActiveAdminPortTypes(this.portCount, byArray);
        return true;
    }

    public boolean applyActiveAdminPortTypes(int n, byte[] byArray) {
        UtilMsgAllActiveAdminPortTypes utilMsgAllActiveAdminPortTypes = new UtilMsgAllActiveAdminPortTypes();
        utilMsgAllActiveAdminPortTypes.setPortCount(n);
        utilMsgAllActiveAdminPortTypes.setPortTypes(byArray);
        utilMsgAllActiveAdminPortTypes.setWaitAfterSend(20000);
        return this.utilAgent.setAllActiveAdminPortTypes(this, this, utilMsgAllActiveAdminPortTypes);
    }

    public boolean applyActiveAdminPortTypesSave() {
        UtilMsgSaveAllAdminPortTypes utilMsgSaveAllAdminPortTypes = new UtilMsgSaveAllAdminPortTypes();
        return this.utilAgent.saveAllAdminPortTypes(this, this, utilMsgSaveAllAdminPortTypes);
    }

    public boolean updateEPortIsolationReasons() {
        boolean bl = this.utilAgent.getEPortIsolationReasons(this.portCount, this, this);
        return bl;
    }

    public boolean applyRscn(boolean[] blArray) {
        UtilMsgRscn utilMsgRscn = new UtilMsgRscn();
        utilMsgRscn.setPortCount(blArray.length);
        byte[] byArray = new byte[blArray.length];
        int n = 0;
        while (n < blArray.length) {
            byArray[n] = (byte)(blArray[n] ? 1 : 0);
            ++n;
        }
        utilMsgRscn.setRscnSuppression(byArray);
        utilMsgRscn.setSetCommand();
        return this.utilAgent.setRscn(this, this, utilMsgRscn);
    }

    public boolean updateRscn() {
        return this.utilAgent.getRscn(this, this);
    }

    public boolean applySnmpCommunities(SnmpInfo snmpInfo) {
        UtilMsgSnmpCommunities utilMsgSnmpCommunities = new UtilMsgSnmpCommunities();
        utilMsgSnmpCommunities.setReadCommunity(snmpInfo.getReadComm());
        utilMsgSnmpCommunities.setWriteCommunity(snmpInfo.getWriteComm());
        utilMsgSnmpCommunities.setTrapCommunity(snmpInfo.getTrapComm());
        return this.utilAgent.setSnmpCommunityStrings(this, this, utilMsgSnmpCommunities);
    }

    public boolean applySwitchReconfig() {
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters();
        utilMsgSwitchConfigurationParameters.setWaitAfterSend(15000);
        return this.utilAgent.reconfigSwitchHardware(this, this, utilMsgSwitchConfigurationParameters);
    }

    public boolean applySaveActiveSwitchConfig() {
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters();
        return this.utilAgent.saveActiveSwitchConfigurationParameters(this, this, utilMsgSwitchConfigurationParameters);
    }

    public boolean applySavePendingSwitchConfig() {
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters();
        return this.utilAgent.savePendingSwitchConfigurationParameters(this, this, utilMsgSwitchConfigurationParameters);
    }

    public boolean applySwitchConfig(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n6, int n7, int n8) {
        byte[] byArray = new byte[nArray4.length];
        int n9 = 0;
        while (n9 < byArray.length) {
            switch (nArray4[n9]) {
                case 5: {
                    byArray[n9] = 5;
                    break;
                }
                case 4: {
                    byArray[n9] = 4;
                    break;
                }
                case 6: {
                    byArray[n9] = 6;
                    break;
                }
                default: {
                    byArray[n9] = 1;
                }
            }
            ++n9;
        }
        if (!this.utilAgent.setAllActivePortTypes(this, this, byArray)) {
            return false;
        }
        UtilMsgSaveAllAdminPortTypes utilMsgSaveAllAdminPortTypes = new UtilMsgSaveAllAdminPortTypes();
        if (!this.utilAgent.saveAllAdminPortTypes(this, this, utilMsgSaveAllAdminPortTypes)) {
            return false;
        }
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters((byte)this.portCount);
        utilMsgSwitchConfigurationParameters.setTimeoutValue(2000);
        int n10 = (n & 0xF0) >> 4;
        int n11 = (n & 0xF) << 2;
        utilMsgSwitchConfigurationParameters.setChassisNumber((byte)n11);
        utilMsgSwitchConfigurationParameters.setLockChassisNumber((byte)n2);
        if (n3 == 2 || n3 == 0) {
            utilMsgSwitchConfigurationParameters.setStageType((byte)0);
        } else {
            utilMsgSwitchConfigurationParameters.setStageType((byte)1);
        }
        utilMsgSwitchConfigurationParameters.setFabricId((byte)n10);
        utilMsgSwitchConfigurationParameters.setAdminChassisMode((byte)n4);
        utilMsgSwitchConfigurationParameters.setRaTimeoutValue(n7);
        utilMsgSwitchConfigurationParameters.setRtTimeoutValue(n6);
        utilMsgSwitchConfigurationParameters.setEdTimeoutValue(n8);
        utilMsgSwitchConfigurationParameters.setMfsTimeout((byte)n5);
        int n12 = 0;
        while (n12 < this.portCount) {
            utilMsgSwitchConfigurationParameters.setPortAdminState(n12, (byte)nArray[n12]);
            utilMsgSwitchConfigurationParameters.setAlDisabled(n12, (byte)nArray3[n12]);
            utilMsgSwitchConfigurationParameters.setMfsMode(n12, (byte)nArray2[n12]);
            ++n12;
        }
        return this.utilAgent.setPendingSwitchConfigurationParameters(this, this, utilMsgSwitchConfigurationParameters);
    }

    public boolean applyActiveSwitchConfig(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n6, int n7, int n8) {
        byte[] byArray = new byte[nArray4.length];
        int n9 = 0;
        while (n9 < byArray.length) {
            switch (nArray4[n9]) {
                case 5: {
                    byArray[n9] = 5;
                    break;
                }
                case 4: {
                    byArray[n9] = 4;
                    break;
                }
                case 6: {
                    byArray[n9] = 6;
                    break;
                }
                default: {
                    byArray[n9] = 1;
                }
            }
            ++n9;
        }
        if (!this.utilAgent.setAllActivePortTypes(this, this, byArray)) {
            return false;
        }
        UtilMsgSaveAllAdminPortTypes utilMsgSaveAllAdminPortTypes = new UtilMsgSaveAllAdminPortTypes();
        if (!this.utilAgent.saveAllAdminPortTypes(this, this, utilMsgSaveAllAdminPortTypes)) {
            return false;
        }
        UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters = new UtilMsgSwitchConfigurationParameters((byte)this.portCount);
        utilMsgSwitchConfigurationParameters.setTimeoutValue(2000);
        int n10 = (n & 0xF0) >> 4;
        int n11 = (n & 0xF) << 2;
        utilMsgSwitchConfigurationParameters.setChassisNumber((byte)n11);
        utilMsgSwitchConfigurationParameters.setLockChassisNumber((byte)n2);
        if (n3 == 2 || n3 == 0) {
            utilMsgSwitchConfigurationParameters.setStageType((byte)0);
        } else {
            utilMsgSwitchConfigurationParameters.setStageType((byte)1);
        }
        utilMsgSwitchConfigurationParameters.setFabricId((byte)n10);
        utilMsgSwitchConfigurationParameters.setAdminChassisMode((byte)n4);
        utilMsgSwitchConfigurationParameters.setRaTimeoutValue(n7);
        utilMsgSwitchConfigurationParameters.setRtTimeoutValue(n6);
        utilMsgSwitchConfigurationParameters.setEdTimeoutValue(n8);
        utilMsgSwitchConfigurationParameters.setMfsTimeout((byte)n5);
        int n12 = 0;
        while (n12 < this.portCount) {
            utilMsgSwitchConfigurationParameters.setPortAdminState(n12, (byte)nArray[n12]);
            utilMsgSwitchConfigurationParameters.setAlDisabled(n12, (byte)nArray3[n12]);
            utilMsgSwitchConfigurationParameters.setMfsMode(n12, (byte)nArray2[n12]);
            ++n12;
        }
        return this.utilAgent.setActiveSwitchConfigurationParameters(this, this, utilMsgSwitchConfigurationParameters);
    }

    public boolean applyBeaconToggle(boolean bl) {
        return this.utilAgent.setBeacon(this, this, bl);
    }

    public boolean applyAllPortsAdminStates(boolean bl) {
        byte[] byArray = new byte[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            byArray[n] = bl ? 1 : 2;
            ++n;
        }
        return this.utilAgent.setAllActivePortAdminStates(this, this, byArray);
    }

    public boolean reset() {
        return this.utilAgent.delayedSwReset(this, this, 3);
    }

    public void receiveMessage(UtilMessage utilMessage) {
        Object object;
        int n = utilMessage.getStatus();
        int n2 = utilMessage.getErrorCode();
        if (n == 103 && !(utilMessage instanceof UtilMsgLoginRequest)) {
            if ((this.utilAgent.getLoginInfo().getLevel() == -2 || this.utilAgent.getLoginInfo().getLevel() == -1) && (object = FabricList.getFabric(this)) != null && ((Fabric)object).getConnectionSwitch().equals(this)) {
                this.utilAgent.getLoginInfo().setLoginLevel(0);
                this.eventHandler.fireChassisEvent(306, null, true);
            }
            if (this.getChassisStatus() != 1) {
                this.setChassisStatus(1);
            }
        } else if (n == 107 && this.getChassisStatus() != 3 && this.getChassisStatus() != 4) {
            this.setChassisStatus(3);
        } else if (n2 == 12 && this.getChassisStatus() != 2 && this.getChassisStatus() != 4) {
            this.setChassisStatus(2);
        } else if ((n2 == 5 || n2 == 14) && this.getChassisStatus() != 4) {
            this.setChassisStatus(4);
            if (!utilMessage.getIsSetCommand() && this.utilAgent.getLoginInfo().getLevel() != -2 && (object = FabricList.getFabric(this)) != null && ((Fabric)object).getConnectionSwitch().equals(this)) {
                this.utilAgent.getLoginInfo().setLoginLevel(-1);
                this.eventHandler.fireChassisEvent(306, null, true);
            }
        } else if (n2 == 15 && this.getChassisStatus() != 6) {
            this.setChassisStatus(6);
        }
        if (utilMessage instanceof UtilMsgClearZoning) {
            this.eventHandler.fireChassisEvent(276, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgIpConfig) {
            this.saveIpConfigRequest((UtilMsgIpConfig)utilMessage);
        } else if (utilMessage instanceof UtilMsgRscn) {
            this.saveRscn((UtilMsgRscn)utilMessage);
        } else if (utilMessage instanceof UtilMsgDelayedSwReset) {
            if (!this.resettingToFactoryDefaults) {
                this.eventHandler.fireChassisEvent(252, (Object)this, utilMessage.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(246, (Object)this, utilMessage.getErrorType());
            }
            this.resettingToFactoryDefaults = false;
        } else if (utilMessage instanceof UtilMsgChassisStatusReq) {
            this.saveChassisStatusRequest((UtilMsgChassisStatusReq)utilMessage);
        } else if (utilMessage instanceof UtilMsgSensorStatus) {
            this.saveSensorStatus((UtilMsgSensorStatus)utilMessage);
        } else if (utilMessage instanceof UtilMsgVersionReq) {
            this.saveVersionRequest((UtilMsgVersionReq)utilMessage);
        } else if (utilMessage instanceof UtilMsgBeaconStatusReq) {
            this.saveBeaconRequest((UtilMsgBeaconStatusReq)utilMessage);
        } else if (utilMessage instanceof UtilMsgBeaconSet) {
            this.saveBeaconSet((UtilMsgBeaconSet)utilMessage);
        } else if (utilMessage instanceof UtilMsgModelCfgReq) {
            this.saveModelTypeRequest((UtilMsgModelCfgReq)utilMessage);
        } else if (utilMessage instanceof UtilMsgSysCfgReq) {
            this.saveSysCfgRequest((UtilMsgSysCfgReq)utilMessage);
        } else if (utilMessage instanceof UtilMsgSnmpConfig) {
            this.saveSnmpRequest((UtilMsgSnmpConfig)utilMessage);
        } else if (utilMessage instanceof UtilMsgSnmpCommunities) {
            this.saveSnmpCommunityStrings((UtilMsgSnmpCommunities)utilMessage);
        } else if (utilMessage instanceof UtilMsgChassisMode) {
            this.saveChassisModeRequest((UtilMsgChassisMode)utilMessage);
        } else if (utilMessage instanceof UtilMsgAllPortsStates) {
            this.saveAllPortsStatesRequest((UtilMsgAllPortsStates)utilMessage);
        } else if (utilMessage instanceof UtilMsgGetAllPortCounters) {
            this.savePortCountersRequest((UtilMsgGetAllPortCounters)utilMessage);
        } else if (utilMessage instanceof UtilMsgGetAllSwitchInternalCounters) {
            this.saveSwitchCountersRequest((UtilMsgGetAllSwitchInternalCounters)utilMessage);
        } else if (utilMessage instanceof UtilMsgAllActiveAdminPortTypes) {
            this.saveAllActiveAdminPortTypes((UtilMsgAllActiveAdminPortTypes)utilMessage);
        } else if (utilMessage instanceof UtilMsgSaveAllAdminPortTypes) {
            this.eventHandler.fireChassisEvent(302, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgEPortIsolationReason) {
            this.saveEPortIsolationReasons((UtilMsgEPortIsolationReason)utilMessage);
        } else if (utilMessage instanceof UtilMsgActiveTLConfig) {
            this.saveTLConfig((UtilMsgActiveTLConfig)utilMessage);
        } else if (utilMessage instanceof UtilMsgSaveActiveTLConfig) {
            this.eventHandler.fireChassisEvent(305, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgNameServerGetAllNextFabricUnzoned) {
            this.saveNameServerGetAllNext((UtilMsgNameServerGetAllNextFabricUnzoned)utilMessage);
        } else if (utilMessage instanceof UtilMsgSwitchConfigurationParameters) {
            this.saveSwitchConfigParameters((UtilMsgSwitchConfigurationParameters)utilMessage);
        } else if (utilMessage instanceof UtilMsgSetAllActivePortTypes) {
            this.eventHandler.fireChassisEvent(273, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgSetAllActivePortAdminStates) {
            this.eventHandler.fireChassisEvent(313, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgGetTimeStamp) {
            if (utilMessage.getStatus() != 103) {
                this.tempTraceLog = new TrapLog();
                this.eventHandler.fireChassisEvent(274, null, utilMessage.getErrorType());
            } else {
                object = (UtilMsgGetTimeStamp)utilMessage;
                this.tempTraceLog.setTimeStamp(((UtilMsgGetTimeStamp)object).getTimeStamp());
                this.tempTraceLog.setTimeStampDate(new Date());
                this.traceLog = this.tempTraceLog;
                this.tempTraceLog = new TrapLog();
                this.eventHandler.fireChassisEvent(274, (Object)this.traceLog, true);
            }
        } else if (utilMessage instanceof UtilMsgTraceRequest) {
            if (utilMessage.getStatus() != 103) {
                this.tempTraceLog = new TrapLog();
                this.eventHandler.fireChassisEvent(274, null, utilMessage.getErrorType());
            } else {
                object = (UtilMsgTraceRequest)utilMessage;
                if (((UtilMsgTraceRequest)object).getEntryCountRecv() > 0) {
                    byte[] byArray = ((UtilMsgTraceRequest)object).getData();
                    byte[] byArray2 = new byte[this.tempTraceLog.getData().length + byArray.length];
                    System.arraycopy(this.tempTraceLog.getData(), 0, byArray2, 0, this.tempTraceLog.getData().length);
                    System.arraycopy(byArray, 0, byArray2, this.tempTraceLog.getData().length, byArray.length);
                    this.tempTraceLog.setData(byArray2);
                }
                if (((UtilMsgTraceRequest)object).getEntryCountRecv() < 240) {
                    this.utilAgent.getTimeStamp(this, this);
                } else {
                    this.utilAgent.getTraceLog(this, this, ((UtilMsgTraceRequest)object).getOffset() + ((UtilMsgTraceRequest)object).getEntryCountRecv(), 240);
                }
            }
        } else if (utilMessage instanceof UtilMsgMemoryWrite) {
            if (utilMessage.getStatus() == 103) {
                this.resettingToFactoryDefaults = true;
                this.utilAgent.resetSwitch(this, this);
            } else {
                this.eventHandler.fireChassisEvent(246, null, utilMessage.getErrorType());
            }
        } else if (utilMessage instanceof UtilMsgOLTStart) {
            this.eventHandler.fireChassisEvent(282, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgOLTStop) {
            this.eventHandler.fireChassisEvent(283, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgOLTReset) {
            this.eventHandler.fireChassisEvent(284, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgOLTStatus) {
            if (utilMessage.getStatus() == 103) {
                this.saveLoopbackResults((UtilMsgOLTStatus)utilMessage);
            }
            this.eventHandler.fireChassisEvent(285, null, utilMessage.getErrorType());
        } else if (utilMessage instanceof UtilMsgTraceControl) {
            object = (UtilMsgTraceControl)utilMessage;
            if (utilMessage.getStatus() == 103) {
                if (!((UtilMsgTraceControl)object).getIsSetCommand()) {
                    this.traceControlFlag = ((UtilMsgTraceControl)object).getFlag();
                    this.eventHandler.fireChassisEvent(290, null, true);
                } else {
                    this.updateTrapInfo();
                    this.eventHandler.fireChassisEvent(289, null, true);
                }
            } else if (((UtilMsgTraceControl)object).getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(289, null, utilMessage.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(290, null, utilMessage.getErrorType());
            }
        } else if (utilMessage instanceof UtilMsgTrapConfig) {
            object = (UtilMsgTrapConfig)utilMessage;
            if (((UtilMsgTrapConfig)object).getIsSaveCommand()) {
                this.eventHandler.fireChassisEvent(275, null, utilMessage.getErrorType());
            } else if (((UtilMsgTrapConfig)object).getIsSetCommand()) {
                if (((UtilMessage)object).getStatus() == 103) {
                    this.utilAgent.saveTraceConfig(this, this);
                } else {
                    this.eventHandler.fireChassisEvent(275, null, utilMessage.getErrorType());
                }
            } else if (!this.editingTrapConfig && ((UtilMessage)object).getStatus() == 103) {
                this.trapsEnabled = ((UtilMsgTrapConfig)object).getTrapsEnabled();
                this.numberOfTraps = ((UtilMsgTrapConfig)object).getNumberOfTraps();
                this.fallingThresholds = ((UtilMsgTrapConfig)object).getFallingThresholds();
                this.risingThresholds = ((UtilMsgTrapConfig)object).getRisingThresholds();
                this.enableArray = new boolean[this.numberOfTraps];
                byte[] byArray = ((UtilMsgTrapConfig)object).getEnableArray();
                int n3 = 0;
                while (n3 < byArray.length) {
                    this.enableArray[n3] = byArray[n3] == 1;
                    ++n3;
                }
                this.sampleInterval = ((UtilMsgTrapConfig)object).getSampleInterval();
                this.eventHandler.fireChassisEvent(292, null, true);
            } else {
                this.eventHandler.fireChassisEvent(292, null, ((UtilMessage)object).getErrorType());
            }
        } else if (utilMessage instanceof UtilMsgLoginRequest && (object = FabricList.getFabric(this)) != null && ((Fabric)object).getConnectionSwitch().equals(this)) {
            UtilMsgLoginRequest utilMsgLoginRequest = (UtilMsgLoginRequest)utilMessage;
            User user = this.utilAgent.getLoginInfo();
            int n4 = user.getLevel();
            if (utilMsgLoginRequest.getStatus() == 103) {
                if (utilMsgLoginRequest.getLoginStatus() == 0) {
                    user.setLoginLevel(utilMsgLoginRequest.getLoginLevel());
                }
                if (utilMsgLoginRequest.getLoginStatus() == 6) {
                    user.setLoginLevel(-2);
                }
            } else {
                user.setLoginLevel(-2);
            }
            if (n4 != user.getLevel()) {
                this.eventHandler.fireChassisEvent(306, null, true);
            }
        }
    }

    protected void saveChassisType(int n) {
        switch (n) {
            case 0: {
                this.chassisType = 0;
                this.portCount = 16;
                break;
            }
            case 2: {
                this.chassisType = 2;
                this.portCount = 8;
            }
        }
        if (this.s43PortList == null) {
            this.s43PortList = new S43Port[this.portCount];
            int n2 = 0;
            while (n2 < this.portCount) {
                this.s43PortList[n2] = this.createPort(n2, this, new FCSanboxPortStatisticsUtil());
                this.s43PortList[n2].setFcAddress(this.fcAddress | n2 << 8);
                ++n2;
            }
        }
    }

    protected void saveVersionRequest(UtilMsgVersionReq utilMsgVersionReq) {
        int n = utilMsgVersionReq.getStatus();
        if (n != 103) {
            this.checkForRelogin(utilMsgVersionReq, this, this);
            this.eventHandler.fireChassisEvent(212, null, utilMsgVersionReq.getErrorType());
            return;
        }
        long l = utilMsgVersionReq.getWWName();
        if (this.WWName != null && this.WWName.getWWName() != l) {
            this.eventHandler.fireChassisEvent(261, null, false);
            this.eventHandler.fireChassisEvent(212, null, false);
            return;
        }
        this.setFcAddress(utilMsgVersionReq.getResponseFcAddress() & 0xFFFFFF);
        this.flashVersionString = Integer.toHexString(utilMsgVersionReq.getFlashRevision());
        this.promHwVersion = utilMsgVersionReq.getPromHardwareVersion();
        this.promSwVersion = utilMsgVersionReq.getPromSoftwareVersion();
        this.promSwVersionString = Integer.toHexString(this.promSwVersion);
        int n2 = utilMsgVersionReq.getChassisType();
        this.saveChassisType(n2);
        this.macAddress = utilMsgVersionReq.getMacAddress();
        this.securityEnabled = utilMsgVersionReq.getSecurityOn() ? 2 : 1;
        this.moduleAddr = utilMsgVersionReq.getModuleAddress();
        this.sysConfigRegister = utilMsgVersionReq.getSystemConfigRegister();
        int n3 = utilMsgVersionReq.getStageType();
        if (this.chassisMode == 1) {
            if (n3 == 0) {
                this.stageType = 0;
            } else if (n3 == 1) {
                this.stageType = 1;
            }
        } else {
            this.stageType = 2;
        }
        this.WWName = new WorldWideName(l);
        this.eventHandler.fireChassisEvent(212, null, true);
    }

    protected void saveBeaconRequest(UtilMsgBeaconStatusReq utilMsgBeaconStatusReq) {
        int n = utilMsgBeaconStatusReq.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(309, null, utilMsgBeaconStatusReq.getErrorType());
            return;
        }
        this.setSwitchBeaconStatus(utilMsgBeaconStatusReq.getBeaconStatus());
        this.eventHandler.fireChassisEvent(309, null, true);
    }

    protected void saveBeaconSet(UtilMsgBeaconSet utilMsgBeaconSet) {
        int n = utilMsgBeaconSet.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(310, null, utilMsgBeaconSet.getErrorType());
            return;
        }
        this.eventHandler.fireChassisEvent(310, null, true);
    }

    protected void saveModelTypeRequest(UtilMsgModelCfgReq utilMsgModelCfgReq) {
        int n = utilMsgModelCfgReq.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(316, null, utilMsgModelCfgReq.getErrorType());
            return;
        }
        this.modelType = utilMsgModelCfgReq.getModelType();
        int n2 = 1;
        this.getFanStatusFromPowerSupplyStatus = false;
        if (this.modelType == 2 || this.modelType == 3) {
            n2 = 2;
            this.getFanStatusFromPowerSupplyStatus = true;
        }
        this.setPowerSupplyCount(n2);
        if (this.modelType == 1) {
            this.setFanCount(3);
        } else {
            this.setFanCount(n2);
        }
        this.eventHandler.fireChassisEvent(316, null, true);
    }

    protected void saveSysCfgRequest(UtilMsgSysCfgReq utilMsgSysCfgReq) {
        int n = utilMsgSysCfgReq.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(337, null, utilMsgSysCfgReq.getErrorType());
            return;
        }
        this.setSysDesc(utilMsgSysCfgReq.getSysDesc());
        this.eventHandler.fireChassisEvent(337, null, true);
    }

    protected void saveSnmpRequest(UtilMsgSnmpConfig utilMsgSnmpConfig) {
        int n = utilMsgSnmpConfig.getStatus();
        if (n != 103) {
            if (utilMsgSnmpConfig.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(214, null, utilMsgSnmpConfig.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(213, null, utilMsgSnmpConfig.getErrorType());
            }
            return;
        }
        this.chassisName = utilMsgSnmpConfig.getName();
        SnmpInfo snmpInfo = new SnmpInfo();
        snmpInfo.setName(this.chassisName);
        snmpInfo.setContact(utilMsgSnmpConfig.getContact());
        snmpInfo.setLocation(utilMsgSnmpConfig.getLocation());
        snmpInfo.setDoAuthTrap(utilMsgSnmpConfig.getDoAuthTrap());
        snmpInfo.setTrapAddress(utilMsgSnmpConfig.getTrapAddress());
        this.snmpInfo = snmpInfo;
        if (utilMsgSnmpConfig.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(214, null, true);
        } else {
            this.eventHandler.fireChassisEvent(213, null, true);
        }
    }

    protected void saveRscn(UtilMsgRscn utilMsgRscn) {
        int n = utilMsgRscn.getStatus();
        if (n != 103) {
            if (utilMsgRscn.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(298, null, utilMsgRscn.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(297, null, utilMsgRscn.getErrorType());
            }
            return;
        }
        if (!utilMsgRscn.getIsSetCommand()) {
            byte[] byArray = utilMsgRscn.getRscnSuppression();
            int n2 = byArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (byArray[n3] == 1) {
                    this.s43PortList[n3].setRscnSuppressed(true);
                } else {
                    this.s43PortList[n3].setRscnSuppressed(false);
                }
                ++n3;
            }
        }
        if (utilMsgRscn.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(298, null, true);
        } else {
            this.eventHandler.fireChassisEvent(297, null, true);
        }
    }

    protected void saveAllActiveAdminPortTypes(UtilMsgAllActiveAdminPortTypes utilMsgAllActiveAdminPortTypes) {
        int n = utilMsgAllActiveAdminPortTypes.getStatus();
        if (n != 103) {
            if (utilMsgAllActiveAdminPortTypes.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(301, null, utilMsgAllActiveAdminPortTypes.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(300, null, utilMsgAllActiveAdminPortTypes.getErrorType());
            }
            return;
        }
        byte[] byArray = utilMsgAllActiveAdminPortTypes.getPortTypes();
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.s43PortList[n3].setDonorMode(byArray[n3]);
            ++n3;
        }
        if (utilMsgAllActiveAdminPortTypes.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(301, null, true);
        } else {
            this.eventHandler.fireChassisEvent(300, null, true);
        }
    }

    protected void saveTLConfig(UtilMsgActiveTLConfig utilMsgActiveTLConfig) {
        int n = utilMsgActiveTLConfig.getStatus();
        if (n != 103) {
            if (utilMsgActiveTLConfig.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(304, null, utilMsgActiveTLConfig.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(303, null, utilMsgActiveTLConfig.getErrorType());
            }
            return;
        }
        if (!utilMsgActiveTLConfig.getIsSetCommand()) {
            int n2 = utilMsgActiveTLConfig.getPortNum();
            boolean bl = utilMsgActiveTLConfig.getAutoLearn();
            this.s43PortList[n2].setAutoLearnEnabled(bl);
            this.eventHandler.fireChassisEvent(303, null, true);
        }
        if (utilMsgActiveTLConfig.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(304, null, true);
        }
    }

    protected void saveEPortIsolationReasons(UtilMsgEPortIsolationReason utilMsgEPortIsolationReason) {
        int n = utilMsgEPortIsolationReason.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(311, null, utilMsgEPortIsolationReason.getErrorType());
            return;
        }
        if (!utilMsgEPortIsolationReason.getIsSetCommand()) {
            int n2 = 0;
            while (n2 < this.portCount) {
                String string;
                byte by = utilMsgEPortIsolationReason.getEPortIsolationReason(n2);
                if (by > 0) {
                    this.s43PortList[n2].setEPortConnState(3);
                }
                StringBuffer stringBuffer = new StringBuffer(this.translateIsolationReason(by));
                if (by == 7 && (string = utilMsgEPortIsolationReason.getMergeFailureZoneName()) != null) {
                    stringBuffer.append(" [" + string + "]");
                }
                this.s43PortList[n2].setEPortIsolatedReason(stringBuffer.toString());
                ++n2;
            }
            this.eventHandler.fireChassisEvent(311, null, true);
        }
    }

    protected String translateIsolationReason(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "N/A";
                break;
            }
            case 1: {
                string = "Rejected domain ID";
                break;
            }
            case 2: {
                string = "Inconsistent domain ID range";
                break;
            }
            case 3: {
                string = "Incompatible fabric";
                break;
            }
            case 4: {
                string = "Domain ID out of range";
                break;
            }
            case 5: {
                string = "Inconsistent domain ID range";
                break;
            }
            case 6: {
                string = "TOV mismatch";
                break;
            }
            case 7: {
                string = "Zone merge failure";
                break;
            }
            case 8: {
                string = "Remove E_Port isolated";
                break;
            }
            default: {
                string = "Unknown reason (" + n + ")";
            }
        }
        return string;
    }

    protected void saveLoopbackResults(UtilMsgOLTStatus utilMsgOLTStatus) {
        this.loopbackResults = new LoopbackPortTestResult[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            int n2 = utilMsgOLTStatus.getFailCount(n);
            LoopbackPortTestResult loopbackPortTestResult = n2 == 0 ? new LoopbackPortTestResult(n, true) : new LoopbackPortTestResult(n, false);
            loopbackPortTestResult.setFailureCount(utilMsgOLTStatus.getFailCount(n));
            loopbackPortTestResult.setFrameCount(utilMsgOLTStatus.getTestCount(n));
            switch (utilMsgOLTStatus.getTestStatus(n) & 0xFF) {
                case 0: {
                    loopbackPortTestResult.setTestStatus("No tests run");
                    break;
                }
                case 1: {
                    loopbackPortTestResult.setTestStatus("Passed");
                    break;
                }
                case 2: {
                    loopbackPortTestResult.setTestStatus("Failed");
                    break;
                }
                case 3: {
                    loopbackPortTestResult.setTestStatus("Echo frame rejected");
                }
            }
            this.loopbackResults[n] = loopbackPortTestResult;
            ++n;
        }
    }

    protected void saveSnmpCommunityStrings(UtilMsgSnmpCommunities utilMsgSnmpCommunities) {
        int n = utilMsgSnmpCommunities.getStatus();
        SnmpInfo snmpInfo = this.getSnmpInfo();
        if (n != 103) {
            if (utilMsgSnmpCommunities.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(270, null, utilMsgSnmpCommunities.getErrorType());
                return;
            }
            this.eventHandler.fireChassisEvent(312, null, utilMsgSnmpCommunities.getErrorType());
            return;
        }
        if (utilMsgSnmpCommunities.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(270, null, true);
        } else if (this.snmpInfo != null) {
            snmpInfo.setReadComm(utilMsgSnmpCommunities.getReadCommunity());
            snmpInfo.setWriteComm(utilMsgSnmpCommunities.getWriteCommunity());
            snmpInfo.setTrapComm(utilMsgSnmpCommunities.getTrapCommunity());
            this.eventHandler.fireChassisEvent(312, null, true);
        } else {
            this.eventHandler.fireChassisEvent(312, null, utilMsgSnmpCommunities.getErrorType());
        }
    }

    protected void saveChassisModeRequest(UtilMsgChassisMode utilMsgChassisMode) {
        int n = utilMsgChassisMode.getStatus();
        if (n != 103) {
            if (utilMsgChassisMode.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(217, (Object)new Integer(this.chassisMode), utilMsgChassisMode.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(216, (Object)new Integer(this.chassisMode), utilMsgChassisMode.getErrorType());
            }
            return;
        }
        if (!utilMsgChassisMode.getIsSetCommand()) {
            if (utilMsgChassisMode.isAdmin()) {
                this.adminMode = utilMsgChassisMode.getChassisMode();
            } else {
                this.chassisMode = utilMsgChassisMode.getChassisMode();
            }
            if (this.chassisMode == 2 && this.stageType != 2) {
                this.stageType = 2;
                this.eventHandler.fireChassisEvent(215, (Object)new Integer(this.stageType), true);
            }
        }
        if (utilMsgChassisMode.getIsSetCommand()) {
            this.eventHandler.fireChassisEvent(217, (Object)new Integer(this.chassisMode), true);
        } else {
            this.eventHandler.fireChassisEvent(216, (Object)new Integer(this.chassisMode), true);
        }
    }

    protected void saveAllPortsStatesRequest(UtilMsgAllPortsStates utilMsgAllPortsStates) {
        int n = utilMsgAllPortsStates.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(269, null, utilMsgAllPortsStates.getErrorType());
            return;
        }
        if (this.s43PortList == null) {
            return;
        }
        int n2 = utilMsgAllPortsStates.getNumberOfPorts();
        int n3 = 0;
        while (n3 < n2) {
            PortStates portStates = utilMsgAllPortsStates.getPortState(n3);
            if (portStates.getLoggedIn() == 0) {
                if (portStates.getAlDisabled() == 1 && (portStates.getPortType() == 1 || portStates.getPortType() == 2)) {
                    portStates.setPortType((byte)8);
                } else if (portStates.getAlDisabled() == 0 && (portStates.getPortType() == 1 || portStates.getPortType() == 2)) {
                    portStates.setPortType((byte)9);
                }
            }
            this.s43PortList[n3].setPortStates(portStates);
            ++n3;
        }
        this.eventHandler.fireChassisEvent(269, (Object)((FCPort[])this.s43PortList.clone()), true);
    }

    protected void savePortCountersRequest(UtilMsgGetAllPortCounters utilMsgGetAllPortCounters) {
        int n = utilMsgGetAllPortCounters.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(221, null, utilMsgGetAllPortCounters.getErrorType());
            return;
        }
        if (this.s43PortList == null) {
            return;
        }
        int n2 = utilMsgGetAllPortCounters.getPortNumber();
        FCSanboxPortStatisticsUtil fCSanboxPortStatisticsUtil = (FCSanboxPortStatisticsUtil)this.s43PortList[n2].getStats();
        fCSanboxPortStatisticsUtil.saveStats(utilMsgGetAllPortCounters);
        this.eventHandler.fireChassisEvent(221, (Object)new Integer(n2), true);
        if (this.perfMonPollingActive) {
            int n3 = utilMsgGetAllPortCounters.getPortNumber();
            long[] lArray = new long[this.portCount];
            long l = (long)fCSanboxPortStatisticsUtil.getStatisticRate(0);
            SanboxPerfMonResult sanboxPerfMonResult = new SanboxPerfMonResult(n3, l);
            this.eventHandler.fireChassisEvent(326, (Object)sanboxPerfMonResult, true);
            l = (long)fCSanboxPortStatisticsUtil.getStatisticRate(1);
            sanboxPerfMonResult = new SanboxPerfMonResult(n3, l);
            this.eventHandler.fireChassisEvent(325, (Object)sanboxPerfMonResult, true);
            long l2 = (long)fCSanboxPortStatisticsUtil.getStatisticRate(0);
            long l3 = (long)fCSanboxPortStatisticsUtil.getStatisticRate(1);
            l = l2 + l3;
            sanboxPerfMonResult = new SanboxPerfMonResult(n3, l);
            this.eventHandler.fireChassisEvent(324, (Object)sanboxPerfMonResult, true);
            long l4 = (long)fCSanboxPortStatisticsUtil.getStatisticRate(7);
            l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(8);
            l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(9);
            l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(10);
            l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(11);
            l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(25);
            l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(26);
            sanboxPerfMonResult = new SanboxPerfMonResult(n3, l4 += (long)fCSanboxPortStatisticsUtil.getStatisticRate(27));
            this.eventHandler.fireChassisEvent(327, (Object)sanboxPerfMonResult, true);
        }
    }

    protected void saveSwitchCountersRequest(UtilMsgGetAllSwitchInternalCounters utilMsgGetAllSwitchInternalCounters) {
        int n = utilMsgGetAllSwitchInternalCounters.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(222, (Object)this.stats, utilMsgGetAllSwitchInternalCounters.getErrorType());
            return;
        }
        if (this.stats == null) {
            this.stats = new FCSanboxSwitchStatisticsUtil();
        }
        ((FCSanboxSwitchStatisticsUtil)this.stats).saveStats(utilMsgGetAllSwitchInternalCounters);
        this.eventHandler.fireChassisEvent(222, (Object)this.stats, true);
    }

    protected void saveNameServerGetAllNext(UtilMsgNameServerGetAllNextFabricUnzoned utilMsgNameServerGetAllNextFabricUnzoned) {
        int n = utilMsgNameServerGetAllNextFabricUnzoned.getStatus();
        if (utilMsgNameServerGetAllNextFabricUnzoned.getMessageRejected() != 0) {
            this.acquiringNameServerInfo = false;
            this.clearPortsNodeList(0, this.getPortCount() - 1);
            this.eventHandler.fireChassisEvent(219, (Object)this, true);
        } else if (n != 103) {
            this.acquiringNameServerInfo = false;
            this.nameServerEntryList = new Vector();
            this.eventHandler.fireChassisEvent(219, (Object)this, utilMsgNameServerGetAllNextFabricUnzoned.getErrorType());
        } else if (utilMsgNameServerGetAllNextFabricUnzoned.getPortAddress() == utilMsgNameServerGetAllNextFabricUnzoned.getReqFcAddress()) {
            this.finishedNameSeverScan(this.nameServerEntryList, true);
        } else {
            this.nameServerEntry = new NameServerEntryUtil();
            this.nameServerEntry.saveEntry(utilMsgNameServerGetAllNextFabricUnzoned);
            this.nameServerEntryList.add(this.nameServerEntry);
            int n2 = this.nameServerEntryList.size();
            NameServerEntry nameServerEntry = (NameServerEntry)this.nameServerEntryList.get(n2 - 1);
            if (this.nameServerEntryList.indexOf(nameServerEntry) != n2 - 1) {
                this.nameServerEntryList.remove(n2 - 1);
                this.finishedNameSeverScan(this.nameServerEntryList, true);
            } else {
                this.getNextNameServerInfo(nameServerEntry.getFcAddress());
            }
        }
    }

    protected void saveSwitchConfigParameters(UtilMsgSwitchConfigurationParameters utilMsgSwitchConfigurationParameters) {
        int n;
        int n2 = utilMsgSwitchConfigurationParameters.getStatus();
        if (n2 != 103) {
            int n3 = utilMsgSwitchConfigurationParameters.getExtCommand();
            if (n3 == 6) {
                this.eventHandler.fireChassisEvent(267, null, utilMsgSwitchConfigurationParameters.getErrorType());
            } else if (n3 == 7) {
                this.eventHandler.fireChassisEvent(266, null, utilMsgSwitchConfigurationParameters.getErrorType());
            } else if (n3 == 9) {
                this.eventHandler.fireChassisEvent(268, null, utilMsgSwitchConfigurationParameters.getErrorType());
            } else if (utilMsgSwitchConfigurationParameters.getIsSetCommand()) {
                this.eventHandler.fireChassisEvent(231, null, utilMsgSwitchConfigurationParameters.getErrorType());
            } else {
                this.eventHandler.fireChassisEvent(230, null, utilMsgSwitchConfigurationParameters.getErrorType());
            }
            return;
        }
        if (!utilMsgSwitchConfigurationParameters.getIsSetCommand()) {
            n = utilMsgSwitchConfigurationParameters.getStageType();
            if (this.chassisMode == 1) {
                if (n == 0) {
                    this.stageType = 0;
                } else if (n == 1) {
                    this.stageType = 1;
                }
            } else {
                this.stageType = 2;
            }
            this.fabricId = utilMsgSwitchConfigurationParameters.getFabricId();
            this.setDomainIdLock(utilMsgSwitchConfigurationParameters.getLockChassisNumber());
            this.raTimeout = utilMsgSwitchConfigurationParameters.getRaTimeoutValue();
            this.rtTimeout = utilMsgSwitchConfigurationParameters.getRtTimeoutValue();
            this.edTimeout = utilMsgSwitchConfigurationParameters.getEdTimeoutValue();
            this.mfsTimeout = utilMsgSwitchConfigurationParameters.getMfsTimeout();
            int n4 = 0;
            while (n4 < this.portCount) {
                this.s43PortList[n4].setAdminState(utilMsgSwitchConfigurationParameters.getPortAdminState(n4));
                this.s43PortList[n4].setAlDisabled(utilMsgSwitchConfigurationParameters.getAlDisabled(n4));
                this.s43PortList[n4].setMfsMode(utilMsgSwitchConfigurationParameters.getMfsMode(n4));
                ++n4;
            }
        }
        if (utilMsgSwitchConfigurationParameters.getIsSetCommand()) {
            n = utilMsgSwitchConfigurationParameters.getExtCommand();
            if (n == 6) {
                this.eventHandler.fireChassisEvent(267, null, true);
            } else if (n == 7) {
                this.eventHandler.fireChassisEvent(266, null, true);
            } else if (n == 9) {
                this.eventHandler.fireChassisEvent(268, null, true);
            } else {
                this.eventHandler.fireChassisEvent(231, null, true);
            }
        } else {
            this.eventHandler.fireChassisEvent(230, null, true);
        }
    }

    public boolean updateEPortZoning() {
        return this.zoningUtilLoad.updateEPortZoning();
    }

    public void cancelEPortZoningLoad() {
        this.zoningUtilLoad.cancelEPortZoningLoad();
    }

    public boolean applyEPortZoning(Zones zones) {
        return this.zoningUtilApply.applyEPortZoning(zones);
    }

    public boolean applyZoningConfig(ZoningConfig zoningConfig) {
        return this.zoningUtilApply.applyZoningConfig(zoningConfig);
    }

    public void cancelEPortZoningSave() {
        this.zoningUtilApply.setApplyReason(new GuiError(100));
        this.zoningUtilApply.cancelEPortZoningSave();
    }

    public boolean applyActivateZoneSet(ZoneSet zoneSet) {
        return this.zoningUtilApply.applyActivateZoneSet(zoneSet);
    }

    public boolean applyDeactivateZoneSet() {
        return this.zoningUtilApply.applyDeactivateZoneSet();
    }

    public boolean startPerformanceMonitoring() {
        Fabric fabric = FabricList.getFabric(this);
        this.normalPortStatPollingInterval = fabric.getPollingInterval(this, 221);
        fabric.setPollingInterval(this, 221, 1000L);
        this.perfMonPollingActive = true;
        return true;
    }

    public boolean stopPerformanceMonitoring() {
        Fabric fabric = FabricList.getFabric(this);
        fabric.setPollingInterval(this, 221, this.normalPortStatPollingInterval);
        this.perfMonPollingActive = false;
        return true;
    }

    public boolean isPerformanceMonitoringActive() {
        return this.perfMonPollingActive;
    }

    public boolean updateAll() {
        this.eventHandler.fireChassisEvent(291, null, true);
        return true;
    }

    protected void createUpdaters() {
        this.updaters = new Vector();
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateVersion();
            }

            public int getEvent() {
                return 212;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateModelType();
            }

            public int getEvent() {
                return 316;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateSnmpInfo();
            }

            public int getEvent() {
                return 213;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateChassisMode();
            }

            public int getEvent() {
                return 216;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updatePortStates();
            }

            public int getEvent() {
                return 269;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateSwitchConfig();
            }

            public int getEvent() {
                return 230;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateChassisInfo();
            }

            public int getEvent() {
                return 200;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateSensorStatus();
            }

            public int getEvent() {
                return 295;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateIpInfo();
            }

            public int getEvent() {
                return 201;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateRscn();
            }

            public int getEvent() {
                return 297;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateTrapInfo();
            }

            public int getEvent() {
                return 274;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateActiveAdminPortTypes();
            }

            public int getEvent() {
                return 300;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateEPortIsolationReasons();
            }

            public int getEvent() {
                return 311;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateNameServerInfo();
            }

            public int getEvent() {
                return 219;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateEPortZoning();
            }

            public int getEvent() {
                return 241;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updatePortStatistics();
            }

            public int getEvent() {
                return 221;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateChassisStatistics();
            }

            public int getEvent() {
                return 222;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateBeacon();
            }

            public int getEvent() {
                return 309;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.zoningUtilLoad.updateZoningConfig();
            }

            public int getEvent() {
                return 333;
            }
        });
        this.updaters.add(new Updater(){

            public boolean update() {
                return SanboxUtil.this.updateSysCfg();
            }

            public int getEvent() {
                return 337;
            }
        });
        Collections.sort(this.updaters);
    }
}

