/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.EPortEntryList;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.FwVersion;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.LoopbackPortTestResult;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.Updater;
import com.qlogic.device.fcfabric.User;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.archiver.Sanbox2Archiver;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.event.ComAgentEvent;
import com.qlogic.device.fcfabric.event.ComAgentEventListener;
import com.qlogic.device.fcfabric.event.FwLoadError;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.switchAttributes.AlarmLogAttr;
import com.qlogic.device.fcfabric.switchAttributes.AlarmThresholdsAttr;
import com.qlogic.device.fcfabric.switchAttributes.BBCreditsAttr;
import com.qlogic.device.fcfabric.switchAttributes.BeaconAttr;
import com.qlogic.device.fcfabric.switchAttributes.BroadcastSupportAttr;
import com.qlogic.device.fcfabric.switchAttributes.ChassisInfoAttr;
import com.qlogic.device.fcfabric.switchAttributes.ChassisNameAttr;
import com.qlogic.device.fcfabric.switchAttributes.CreditPoolAttr;
import com.qlogic.device.fcfabric.switchAttributes.DateTimeAttr;
import com.qlogic.device.fcfabric.switchAttributes.DeviceScanAttr;
import com.qlogic.device.fcfabric.switchAttributes.DomainIdLockAttr;
import com.qlogic.device.fcfabric.switchAttributes.ExtCreditAttr;
import com.qlogic.device.fcfabric.switchAttributes.FlashVersionAttr;
import com.qlogic.device.fcfabric.switchAttributes.InbandEnableAttr;
import com.qlogic.device.fcfabric.switchAttributes.IpInfoAttr;
import com.qlogic.device.fcfabric.switchAttributes.LoopbackTestAttr;
import com.qlogic.device.fcfabric.switchAttributes.LsdbAttr;
import com.qlogic.device.fcfabric.switchAttributes.NameServerAttr;
import com.qlogic.device.fcfabric.switchAttributes.PerfMonIntervalAttr;
import com.qlogic.device.fcfabric.switchAttributes.PortInfoAttr;
import com.qlogic.device.fcfabric.switchAttributes.PortNameAttr;
import com.qlogic.device.fcfabric.switchAttributes.PortSpeedAttr;
import com.qlogic.device.fcfabric.switchAttributes.PortStatisticsAttr;
import com.qlogic.device.fcfabric.switchAttributes.RscnAttr;
import com.qlogic.device.fcfabric.switchAttributes.SessionTimerAttr;
import com.qlogic.device.fcfabric.switchAttributes.SnmpInfoAttr;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.switchAttributes.SwitchConfigAttr;
import com.qlogic.device.fcfabric.switchAttributes.SysDescAttr;
import com.qlogic.device.fcfabric.switchAttributes.SyslogInfoAttr;
import com.qlogic.device.fcfabric.switchAttributes.TempMonitoringAttr;
import com.qlogic.device.fcfabric.switchAttributes.UserAccountsAttr;
import com.qlogic.device.fcfabric.switchAttributes.ZoningActiveAttr;
import com.qlogic.device.fcfabric.switchAttributes.ZoningConfiguredAttr;
import com.qlogic.device.fcfabric.switchAttributes.ZoningParametersAttr;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgLoginRequest;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNotifySml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Vector;

public class Sanbox2Sml
extends Sanbox2
implements UtilDestination,
UtilEventListener,
ComAgentEventListener {
    public static final int MAX_IP_LENGTH = 8;
    protected UtilAgent utilAgent;
    private static final int DOMAIN_FCADDRESS_SHIFT_COUNT = 16;
    private static final int SML_FIRST_NS_ENTRY = -1;
    private String notifyTag;
    static final int SML_RESET = 0;
    static final int SML_GET_ADMIN_PORT_SPEEDS = 1;
    static final int SML_GET_OPER_PORT_SPEEDS = 2;
    static final int SML_SET_OPER_PORT_SPEEDS = 3;
    static final int SML_GET_PORT_STATES = 4;
    static final int SML_GET_SWITCH_CONFIG = 5;
    static final int SML_SAVE_CONFIG = 6;
    static final int SML_ACTIVATE_CONFIG = 7;
    static final int SML_EDIT_CONFIG = 8;
    static final int SML_REQ_ADMIN = 9;
    static final int SML_REL_ADMIN = 10;
    static final int SML_GET_ADMIN_PORT_SPEED = 32;
    static final int SML_GET_OPER_PORT_SPEED = 33;
    static final int SML_REGISTER_FOR_NOTIFICATIONS = 34;
    static final int SML_RESET_FACTORY_DEFAULTS = 35;
    static final int SML_ISL_SECURITY = 37;
    static final int SML_INBAND_MGMT = 38;
    static final int SML_DOMAIN_OFFSET = 39;
    static final int SML_SERIAL_NUMBER = 40;
    static final int SML_TL_MODE = 42;
    static final int SML_BB_CREDITS = 43;
    static final int SML_PORT_RESET = 44;
    static final int SML_OPERATIONAL_STATE = 46;
    static final int SML_ACTIVATE_CONFIG_AND_REL_ADMIN = 47;
    static final int SML_GET_IP_CONFIG_INFO = 48;
    static final int SML_RESET_DEFAULT_ZONING = 52;
    static final int SML_LOOPBACK_TEST = 54;
    static final int SML_CREDIT_POOL = 62;
    static final int SML_EXT_CREDIT_INFO = 63;
    static final int SML_ADMIN_MODE = 64;
    static final int SML_DELAYED_RESET = 65;
    static final int SML_RSCN = 67;
    static final int SML_BROADCAST_SUPPORT = 70;
    static final int SML_STOP_LOOPBACK_TEST = 76;
    static final int SML_LOOPBACK_TEST_STATUS = 77;
    static final int SML_ONLINE_LOOPBACK_TEST = 78;
    static final int SML_PORT_MODE = 79;
    static final int SML_PORT_STATE = 80;
    static final int SML_GET_ALL_PORT_STATES = 82;
    static final int SML_REGISTER_FOR_PERF_NOTIFICATIONS = 83;
    static final int SML_UNREGISTER_FOR_PERF_NOTIFICATIONS = 84;
    static final int SML_SET_PERF_TIMER = 85;
    static final int SML_GET_PERF_TIMER = 86;
    static final int SML_REQ_IO_MODULES_STATES = 87;
    static final int SML_REQ_IO_MODULES_INFO = 88;
    static final int SML_DOMAIN_ID_LOCK = 89;
    static final int SML_TEMP_PORT_MODE = 90;
    static final int SML_TEMP_PORT_STATE = 91;
    static final int SML_RESET_BLADES = 96;
    static final int SML_TEST_BLADES = 97;
    static final int SML_APPLY_BLADES_ADMIN = 98;
    static final int SML_APPLY_BLADES_CONFIG_ADMIN = 99;
    static final int SML_REGISTER_FOR_UPLOAD_NOTIFICATION = 102;
    static final int SML_REQ_FW_IMAGE_UNPACK = 103;
    static final int SML_REGISTER_FOR_UNPACK_NOTIFICATION = 104;
    static final int SML_FIRMWARE_FALLBACK = 105;
    static final int SML_INBAND_ENABLE = 106;
    static final int SML_DATE_TIME = 107;
    static final int SML_CLOSE_SESSION = 108;
    static final int SML_SHUTDOWN_SWITCH = 109;
    static final int SML_NOP = 110;
    static final int SML_TEMP_MONITORING = 113;
    static final int SML_USER_ACCOUNT_LIST = 114;
    static final int SML_USER_ACCOUNT_ADMIN_AUTHORITY = 115;
    static final int SML_USER_ACCOUNT_EXPIRATION = 116;
    static final int SML_ADD_USER_ACCOUNT = 117;
    static final int SML_REMOVE_USER_ACCOUNT = 118;
    static final int SML_APPLY_BLADE_REMOVE = 119;
    static final int SML_APPLY_BLADE_REMOVED = 120;
    static final int SML_APPLY_BLADE_INSERT = 121;
    static final int SML_APPLY_BLADE_INSERTED = 122;
    static final int SML_UPDATE_BLADE_DIAGNOSTIC_STATUS = 123;
    static final int SML_CHANGE_PASSWORD = 124;
    static final int SML_SET_PORT_CONFIG = 125;
    static final int SML_HOT_RESET = 126;
    static final int SML_FW_IMAGE_CLEANUP = 127;
    static final int SML_HARD_RESET = 128;
    boolean bRunningTopology = false;
    private boolean firstLsdbDomain;
    private boolean lastLsdbUpdateFailed;
    Vector perfMonRegistrationList = new Vector();
    boolean performanceMonitoringActive = false;
    EPortEntryList tempEPortEntryList = new EPortEntryList();
    Sanbox2Archiver archiver = new Sanbox2Archiver();
    private long lastPing = System.currentTimeMillis();
    protected String lsdbTs;
    protected Vector updatedUserAccountList;
    protected boolean userAccountListUpdateInProgress = false;
    static FwVersion verBottomBrocade = null;
    static FwVersion verTopBrocade = null;
    static FwVersion verNonSwLegacy = null;

    public Sanbox2Sml(UtilMsgVersionReq utilMsgVersionReq, UtilAgent utilAgent) {
        super(utilAgent);
        this.notifyTag = Long.toHexString(utilMsgVersionReq.getWWName());
        this.utilAgent = utilAgent;
        this.chassisName = new String("unknown");
        this.saveVersionRequest(utilMsgVersionReq);
        this.createAttrs();
        utilAgent.addComAgentListener(this);
    }

    public Sanbox2Sml(String string, WorldWideName worldWideName, int n, UtilAgent utilAgent) {
        super(utilAgent);
        this.notifyTag = worldWideName.toString();
        this.utilAgent = utilAgent;
        this.chassisName = string == null ? "unknown" : string;
        this.WWName = worldWideName;
        this.saveChassisType(n);
        this.createAttrs();
        utilAgent.addComAgentListener(this);
    }

    public void dispose() {
        this.utilAgent.removeComAgentListener(this);
    }

    public SanboxChassisArchiver getArchiver() {
        return this.archiver;
    }

    public boolean useVersion_0() {
        return false;
    }

    public boolean supportsBrocadeMergeMode() {
        if (verBottomBrocade == null) {
            verBottomBrocade = new FwVersion("V1.4.0.0-0");
            verTopBrocade = new FwVersion("V1.5.1.4-0");
        }
        if (this.firmwareVersion.compareTo(verTopBrocade) > 0) {
            return true;
        }
        return this.firmwareVersion.compareTo(verBottomBrocade) < 0;
    }

    public boolean supportsNonSw2Legacy() {
        if (verNonSwLegacy == null) {
            verNonSwLegacy = new FwVersion("V1.5.1.5-0");
        }
        return this.firmwareVersion.compareTo(verNonSwLegacy) >= 0;
    }

    public boolean applyChassisMode(int n) {
        return true;
    }

    public boolean applyLoopbackTest(int n, int n2) {
        LoopbackTestAttr loopbackTestAttr = (LoopbackTestAttr)this.getAttr(285);
        return loopbackTestAttr.applyLoopbackTest(n, n2);
    }

    public boolean applyLoopbackTest(int n, long l, int n2, long l2, boolean bl, int n3) {
        LoopbackTestAttr loopbackTestAttr = (LoopbackTestAttr)this.getAttr(285);
        return loopbackTestAttr.applyLoopbackTest(n, l, n2, l2, bl, n3);
    }

    public boolean applyLoopbackTest(int n, long l, int n2, boolean bl, int n3) {
        LoopbackTestAttr loopbackTestAttr = (LoopbackTestAttr)this.getAttr(285);
        return loopbackTestAttr.applyLoopbackTest(n, l, n2, bl, n3);
    }

    public boolean applyOnlineLoopbackTest(int n, long l, int n2, long l2, boolean bl) {
        return this.applyLoopbackTest(n, l, n2, l2, bl, 3);
    }

    public boolean applyOnlineLoopbackTest(int n, long l, int n2, boolean bl) {
        return this.applyLoopbackTest(n, l, n2, bl, 3);
    }

    public boolean applyStopLoopbackTest(int n) {
        LoopbackTestAttr loopbackTestAttr = (LoopbackTestAttr)this.getAttr(285);
        return loopbackTestAttr.applyStopLoopbackTest(n);
    }

    public boolean updateChassisInfo() {
        ChassisInfoAttr chassisInfoAttr = (ChassisInfoAttr)this.getAttr(200);
        return chassisInfoAttr.update();
    }

    public boolean updateIpInfo() {
        IpInfoAttr ipInfoAttr = (IpInfoAttr)this.getAttr(201);
        return ipInfoAttr.update();
    }

    public boolean applyIpInfo(IPInfo iPInfo) {
        IpInfoAttr ipInfoAttr = (IpInfoAttr)this.getAttr(201);
        return ipInfoAttr.apply(iPInfo);
    }

    public static String padIPAddr(InetAddress inetAddress) {
        if (inetAddress != null) {
            StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(inetAddress.hashCode()));
            if (stringBuffer.length() < 8) {
                int n = 8 - stringBuffer.length();
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.insert(0, "0");
                    ++n2;
                }
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static String padIPAddr(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() < 8) {
            int n = 8 - stringBuffer.length();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.insert(0, "0");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public Zones getEportZoningDb() {
        ZoningConfiguredAttr zoningConfiguredAttr = (ZoningConfiguredAttr)this.getAttr(378);
        return zoningConfiguredAttr.getZones();
    }

    public Zones getActiveEportZoning() {
        ZoningActiveAttr zoningActiveAttr = (ZoningActiveAttr)this.getAttr(377);
        return zoningActiveAttr.getZones();
    }

    public boolean applyPerfMonInterval(int n) {
        if (n < 1 || n > 60) {
            return false;
        }
        PerfMonIntervalAttr perfMonIntervalAttr = (PerfMonIntervalAttr)this.getAttr(329);
        return perfMonIntervalAttr.apply(n);
    }

    public boolean updatePerfMonInterval() {
        PerfMonIntervalAttr perfMonIntervalAttr = (PerfMonIntervalAttr)this.getAttr(329);
        return perfMonIntervalAttr.update();
    }

    public boolean stopPerformanceMonitoring() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(84);
        utilMsgSml.setSetCommand();
        int n = this.perfMonRegistrationList.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = (Integer)this.perfMonRegistrationList.elementAt(n2);
            switch (n3) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    String string = UtilMsgNotifySml.notifySmlCommands[n3] + "." + this.notifyTag + "(" + UtilMsgNotifySml.removePeriods(UtilMsgNotifySml.notifySmlCommands[n3]) + ")" + ".Ack.False.Reg.False";
                    utilMsgSml.addSmlCommand(string);
                    break;
                }
            }
            ++n2;
        }
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean startPerformanceMonitoring() {
        this.perfMonRegistrationList = new Vector();
        this.perfMonRegistrationList.add(new Integer(49));
        this.perfMonRegistrationList.add(new Integer(50));
        this.perfMonRegistrationList.add(new Integer(51));
        this.perfMonRegistrationList.add(new Integer(52));
        this.perfMonRegistrationList.add(new Integer(53));
        this.perfMonRegistrationList.add(new Integer(54));
        this.perfMonRegistrationList.add(new Integer(55));
        return this.registerForPerformanceNotifications();
    }

    public boolean isPerformanceMonitoringActive() {
        return this.performanceMonitoringActive;
    }

    boolean registerForPerformanceNotifications() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(83);
        utilMsgSml.setSetCommand();
        int n = this.perfMonRegistrationList.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = (Integer)this.perfMonRegistrationList.elementAt(n2);
            switch (n3) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    String string = UtilMsgNotifySml.notifySmlCommands[n3] + "." + this.notifyTag + "(" + UtilMsgNotifySml.removePeriods(UtilMsgNotifySml.notifySmlCommands[n3]) + ")" + ".Ack.False.Reg.True";
                    utilMsgSml.addSmlCommand(string);
                    break;
                }
            }
            ++n2;
        }
        return this.utilAgent.sendSml(utilMsgSml);
    }

    boolean ackImageUnpackNotification() {
        return this.registerForImageUnpackNotification(false);
    }

    public boolean registerForImageUnpackNotification(boolean bl) {
        int n = 58;
        String string = UtilMsgNotifySml.notifySmlCommands[n];
        String string2 = string + "." + this.notifyTag + "(" + UtilMsgNotifySml.removePeriods(string) + ")" + ".Ack.True.Reg." + (bl ? "True" : "False");
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(104);
        utilMsgSml.setSetCommand();
        utilMsgSml.addSmlCommand(string2);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    boolean ackUploadNotification() {
        return this.registerForUploadNotification(false);
    }

    public boolean registerForUploadNotification(boolean bl) {
        int n = 45;
        String string = UtilMsgNotifySml.notifySmlCommands[n];
        String string2 = string + "." + this.notifyTag + "(" + UtilMsgNotifySml.removePeriods(string) + ")" + ".Ack.True.Reg." + (bl ? "True" : "False");
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(102);
        utilMsgSml.setSetCommand();
        utilMsgSml.addSmlCommand(string2);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean registerForNotifications() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.sendEvenIfUnreachable(true);
        utilMsgSml.setGroupKey(34);
        utilMsgSml.setSetCommand();
        int n = 0;
        while (n < UtilMsgNotifySml.notifySmlCommands.length) {
            switch (n) {
                case 8: 
                case 47: 
                case 48: {
                    if (!(this instanceof Sanbox8000)) break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: 
                case 56: 
                case 57: 
                case 59: 
                case 61: {
                    String string = UtilMsgNotifySml.notifySmlCommands[n] + "." + this.notifyTag + "(" + UtilMsgNotifySml.removePeriods(UtilMsgNotifySml.notifySmlCommands[n]) + ")" + ".Ack.False.Reg.True";
                    utilMsgSml.addSmlCommand(string);
                    break;
                }
                case 60: {
                    String string = UtilMsgNotifySml.notifySmlCommands[n] + "." + this.notifyTag + "(" + UtilMsgNotifySml.removePeriods(UtilMsgNotifySml.notifySmlCommands[n]) + ")" + ".Ack.False.Reg.True";
                    utilMsgSml.addSmlCommand(string);
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    break;
                }
                case 0: 
                case 1: {
                    break;
                }
                case 45: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 58: {
                    break;
                }
                default: {
                    System.err.println("Unknown sml notification index.");
                    System.err.println("notification=" + utilMsgSml);
                    try {
                        throw new Exception();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                }
            }
            ++n;
        }
        boolean bl = this.utilAgent.sendSml(utilMsgSml);
        boolean bl2 = true;
        if (!this.perfMonRegistrationList.isEmpty()) {
            bl2 = this.registerForPerformanceNotifications();
        }
        return bl && bl2;
    }

    public void receiveEvent(ComAgentEvent comAgentEvent) {
        if (comAgentEvent.getEventType() == 2) {
            UtilMsgNotifySml utilMsgNotifySml = (UtilMsgNotifySml)comAgentEvent.getValue();
            String string = utilMsgNotifySml.getResponse(0).getResponse();
            int n = string.indexOf("(");
            int n2 = string.indexOf(")");
            if (n < 0 || n2 <= n) {
                FabricUtilities.logMessage("Bad Notification:" + utilMsgNotifySml.getDataTransfered());
                return;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            if (!this.notifyTag.equals(string2)) {
                return;
            }
            int n3 = -1;
            int n4 = 0;
            while (n4 < UtilMsgNotifySml.notifySmlCommands.length) {
                if (string3.equals(UtilMsgNotifySml.removePeriods(UtilMsgNotifySml.notifySmlCommands[n4]))) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            String string4 = utilMsgNotifySml.getResponseStr();
            int n5 = string4.indexOf(59);
            int n6 = string4.indexOf(";", n5 + 1);
            if (n5 < 0 || n6 <= n5) {
                FabricUtilities.logMessage("Bad Notification:" + utilMsgNotifySml.getDataTransfered());
                return;
            }
            string4 = string4.substring(0, n5 + 1) + string4.substring(n6 + 1);
            if (this.ignoreNotifications && n3 != 59 && !utilMsgNotifySml.isReceivedAlarm(n3)) {
                return;
            }
            SwitchAttribute switchAttribute = null;
            switch (n3) {
                case 4: {
                    this.eventHandler.fireChassisEvent(244, null, true);
                    break;
                }
                case 2: 
                case 42: 
                case 43: 
                case 44: {
                    switchAttribute = this.getAttr(378);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    switchAttribute = this.getAttr(377);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    switchAttribute = this.getAttr(333);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 3: 
                case 61: {
                    switchAttribute = this.getAttr(219);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 39: {
                    this.updateAll();
                    break;
                }
                case 9: 
                case 10: {
                    switchAttribute = this.getAttr(225);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    switchAttribute = this.getAttr(269);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 60: {
                    switchAttribute = this.getAttr(367);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 12: {
                    switchAttribute = this.getAttr(213);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 13: {
                    ZoningActiveAttr zoningActiveAttr = (ZoningActiveAttr)this.getAttr(377);
                    zoningActiveAttr.receivedZoningMergeAlarm(string4);
                    this.eventHandler.fireChassisEvent(262, null, true);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    switchAttribute = this.getAttr(200);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    this.eventHandler.fireChassisEvent(262, (Object)string4, true);
                    break;
                }
                case 8: 
                case 48: {
                    if (!(this instanceof Sanbox8000)) break;
                    switchAttribute = this.getAttr(330);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 47: {
                    this.bladeTestDone(utilMsgNotifySml);
                    break;
                }
                case 57: {
                    switchAttribute = this.getAttr(343);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 59: {
                    this.lastPing = System.currentTimeMillis();
                    if (utilMsgNotifySml.getNumberOfResponses() <= 5) break;
                    int n7 = this.busyStatus;
                    if (utilMsgNotifySml.getResponse(5).getResponse().equals("None")) {
                        this.busyStatus = 1;
                    } else if (utilMsgNotifySml.getResponse(5).getResponse().equals("Waiting")) {
                        this.busyStatus = 3;
                    } else if (utilMsgNotifySml.getResponse(5).getResponse().equals("Busy")) {
                        this.busyStatus = 2;
                    }
                    if (this.busyStatus == n7) break;
                    this.calculateOverallStatus();
                    break;
                }
                case 56: {
                    String string5 = utilMsgNotifySml.getResponse(4).getResponse();
                    Object[] objectArray = new Object[]{new Integer(string5), Boolean.TRUE};
                    switchAttribute = this.getAttr(221);
                    this.eventHandler.fireChassisEvent(379, (Object)new Object[]{switchAttribute, objectArray}, true);
                    break;
                }
                case 40: {
                    String string6 = utilMsgNotifySml.getResponse(4).getResponse();
                    this.eventHandler.fireChassisEvent(336, (Object)Integer.valueOf(string6), true);
                    switchAttribute = this.getAttr(269);
                    this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    break;
                }
                case 41: {
                    String string7 = utilMsgNotifySml.getResponse(4).getResponse();
                    int n8 = Integer.parseInt(string7);
                    String string8 = utilMsgNotifySml.getResponse(5).getResponse();
                    boolean bl = string8.equals("Passed");
                    LoopbackPortTestResult loopbackPortTestResult = new LoopbackPortTestResult(n8, bl);
                    loopbackPortTestResult.setTestDone(true);
                    this.eventHandler.fireChassisEvent(279, (Object)loopbackPortTestResult, utilMsgNotifySml.getErrorType());
                    break;
                }
                case 45: {
                    this.ackUploadNotification();
                    FwLoadError fwLoadError = new FwLoadError(utilMsgNotifySml.getResponse(5).getResponse());
                    if (fwLoadError.getError() == 1) {
                        switchAttribute = this.getAttr(240);
                        this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                        fwLoadError = null;
                    }
                    this.eventHandler.fireChassisEvent(281, null, fwLoadError);
                    break;
                }
                case 58: {
                    this.ackImageUnpackNotification();
                    FwLoadError fwLoadError = new FwLoadError(utilMsgNotifySml.getResponse(5).getResponse());
                    if (fwLoadError.getError() == 1) {
                        switchAttribute = this.getAttr(240);
                        this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                        fwLoadError = null;
                    }
                    this.eventHandler.fireChassisEvent(281, null, fwLoadError);
                    break;
                }
                case 46: {
                    try {
                        String string9 = utilMsgNotifySml.getResponse(5).getResponse();
                        String string10 = UtilMessage.ipConvert(Long.parseLong(string9));
                        this.changedIpAddress = InetAddress.getByName(string10);
                        this.eventHandler.fireChassisEvent(299, null, utilMsgNotifySml.getErrorType());
                    }
                    catch (Exception exception) {
                        System.err.println("switch=" + this.getChassisName() + ": exception thrown handling notification");
                    }
                    break;
                }
                case 49: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(321, (Object)lArray, true);
                    break;
                }
                case 50: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(322, (Object)lArray, true);
                    break;
                }
                case 51: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(323, (Object)lArray, true);
                    break;
                }
                case 52: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(324, (Object)lArray, true);
                    break;
                }
                case 53: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(325, (Object)lArray, true);
                    break;
                }
                case 54: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(326, (Object)lArray, true);
                    break;
                }
                case 55: {
                    long[] lArray = this.extractPerfMonValues(utilMsgNotifySml);
                    this.eventHandler.fireChassisEvent(327, (Object)lArray, true);
                    break;
                }
            }
        }
    }

    public boolean isReachable() {
        if (!super.isReachable()) {
            return false;
        }
        if (System.currentTimeMillis() - this.lastPing > 20000L) {
            this.setChassisStatus(3);
            return false;
        }
        return true;
    }

    public boolean isTimedOut(UtilMessage utilMessage) {
        long l;
        if (utilMessage.sendEvenIfUnreachable()) {
            if (System.currentTimeMillis() - utilMessage.getTimeSent() > 4000L) {
                return true;
            }
        } else if (System.currentTimeMillis() - this.lastPing > 20000L) {
            this.setChassisStatus(3);
            return true;
        }
        return (l = this.lastPing - utilMessage.getTimeSent()) > 6000L && this.busyStatus == 1;
    }

    public void bladeTestDone(UtilMsgNotifySml utilMsgNotifySml) {
    }

    public long[] extractPerfMonValues(UtilMsgSml utilMsgSml) {
        long[] lArray = new long[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            try {
                String string = utilMsgSml.getResponse(n + 5).getResponse();
                Long l = Long.valueOf(string, 16);
                lArray[n] = l;
            }
            catch (Exception exception) {
                System.err.println("Exception parsing perf mon notification:" + exception);
            }
            ++n;
        }
        return lArray;
    }

    public String getSmlWord(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = string.indexOf(46, n2);
            if (n5 < 0) {
                return null;
            }
            n2 = n5 + 1;
            ++n4;
        }
        n3 = string.indexOf(46, n2);
        if (n3 < 0) {
            n3 = string.length();
        }
        String string2 = string.substring(n2, n3);
        return string2;
    }

    protected void saveChassisType(int n) {
        switch (n) {
            case 0: {
                this.chassisType = 0;
                this.portCount = 16;
                break;
            }
            case 2: {
                this.chassisType = 2;
                this.portCount = 8;
                break;
            }
            case 16: {
                this.chassisType = 16;
                this.portCount = 16;
                break;
            }
            case 8: {
                this.chassisType = 8;
                this.portCount = 8;
                break;
            }
            case 30: {
                this.chassisType = 30;
                this.portCount = 8;
                break;
            }
            case 26: {
                this.chassisType = 26;
                this.portCount = 64;
                break;
            }
            case 33: {
                this.chassisType = 33;
                this.portCount = 16;
                break;
            }
            case 38: {
                this.chassisType = 38;
                this.portCount = 16;
                break;
            }
            case 35: 
            case 36: {
                this.chassisType = 16;
                this.portCount = 16;
            }
        }
        if (this.s16PortList == null) {
            this.createS16Ports();
        }
    }

    protected void createS16Ports() {
        this.s16PortList = new S16Port[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            this.s16PortList[n] = this.createS16Port(n, this, new FCStatistics());
            ++n;
        }
    }

    protected void saveVersionRequest(UtilMsgVersionReq utilMsgVersionReq) {
        long l = utilMsgVersionReq.getWWName();
        int n = utilMsgVersionReq.getStatus();
        if (n != 103) {
            this.checkForRelogin(utilMsgVersionReq, this, this);
            this.eventHandler.fireChassisEvent(212, null, utilMsgVersionReq.getErrorType());
            return;
        }
        if (this.WWName != null && this.WWName.getWWName() != l) {
            this.eventHandler.fireChassisEvent(261, null, utilMsgVersionReq.getErrorType());
            return;
        }
        this.setFcAddress(utilMsgVersionReq.getResponseFcAddress());
        this.setFlashVersion(new FwVersion(utilMsgVersionReq.getFlashRevision()));
        int n2 = utilMsgVersionReq.getChassisType();
        this.saveChassisType(n2);
        this.macAddress = utilMsgVersionReq.getMacAddress();
        this.moduleAddr = utilMsgVersionReq.getModuleAddress();
        this.sysConfigRegister = utilMsgVersionReq.getSystemConfigRegister();
        int n3 = utilMsgVersionReq.getStageType();
        if (this.chassisMode == 1) {
            switch (n3) {
                case 0: {
                    this.stageType = 0;
                    break;
                }
                case 1: {
                    this.stageType = 1;
                }
            }
        } else {
            this.stageType = 2;
        }
        this.WWName = new WorldWideName(l);
        this.eventHandler.fireChassisEvent(212, null, true);
    }

    private int translateEPortConnState(String string) {
        if (string.equalsIgnoreCase("None")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Connecting")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Connected")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Isolated")) {
            return 3;
        }
        return -1;
    }

    private byte translatePortLogin(String string) {
        if (string.equalsIgnoreCase("loggedin")) {
            return 1;
        }
        if (string.equalsIgnoreCase("notloggedin")) {
            return 0;
        }
        return -1;
    }

    public void updateStatusWithMsgResponse(UtilMessage utilMessage) {
        int n = utilMessage.getStatus();
        int n2 = utilMessage.getErrorCode();
        if (n == 103 && !(utilMessage instanceof UtilMsgLoginRequest)) {
            Fabric fabric;
            this.lastPing = System.currentTimeMillis();
            this.busyStatus = 1;
            if ((this.utilAgent.getLoginInfo().getLevel() == -2 || this.utilAgent.getLoginInfo().getLevel() == -1) && (fabric = FabricList.getFabric(this)) != null && fabric.getConnectionSwitch().equals(this)) {
                this.utilAgent.getLoginInfo().setLoginLevel(0);
                this.eventHandler.fireChassisEvent(306, null, true);
            }
            if (this.getChassisStatus() != 1) {
                this.setChassisStatus(1);
            }
        } else if (n2 == 12 && this.getChassisStatus() != 2 && this.getChassisStatus() != 4) {
            this.setChassisStatus(2);
        } else if ((n2 == 5 || n2 == 9) && this.getChassisStatus() != 5) {
            Fabric fabric;
            this.setChassisStatus(5);
            if (this.utilAgent.getLoginInfo().getLevel() != -2 && (fabric = FabricList.getFabric(this)) != null && fabric.getConnectionSwitch().equals(this)) {
                this.utilAgent.getLoginInfo().setLoginLevel(-1);
                this.eventHandler.fireChassisEvent(306, null, true);
            }
        } else if (n2 == 14 && this.getChassisStatus() != 4 && this.getChassisStatus() != 7 && this.getChassisStatus() != 5) {
            Fabric fabric;
            this.setChassisStatus(4);
            if (this.utilAgent.getLoginInfo().getLevel() != -2 && (fabric = FabricList.getFabric(this)) != null && fabric.getConnectionSwitch().equals(this)) {
                this.utilAgent.getLoginInfo().setLoginLevel(-1);
                this.eventHandler.fireChassisEvent(306, null, true);
            }
        } else if (n2 == 15 && this.getChassisStatus() != 6) {
            this.setChassisStatus(6);
        }
    }

    public void receiveMessage(UtilMessage utilMessage) {
        boolean bl = false;
        int n = utilMessage.getStatus();
        int n2 = utilMessage.getErrorCode();
        this.updateStatusWithMsgResponse(utilMessage);
        if (utilMessage instanceof UtilMsgSml) {
            UtilMsgSml utilMsgSml = (UtilMsgSml)utilMessage;
            boolean bl2 = true;
            boolean bl3 = false;
            bl = true;
            int n3 = utilMsgSml.getGroupKey();
            switch (n3) {
                case 5: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 124: {
                    return;
                }
            }
            switch (utilMsgSml.getGroupKey()) {
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: {
                    break;
                }
                case 52: {
                    this.eventHandler.fireChassisEvent(276, null, utilMsgSml.getErrorType());
                    break;
                }
                case 83: {
                    if (!utilMsgSml.AllResponsesOk()) {
                        this.performanceMonitoringActive = false;
                        this.sessionTs = "";
                    } else {
                        this.performanceMonitoringActive = true;
                    }
                    this.eventHandler.fireChassisEvent(319, null, utilMessage.getErrorType());
                    break;
                }
                case 84: {
                    if (utilMsgSml.AllResponsesOk()) {
                        this.perfMonRegistrationList.removeAllElements();
                        this.performanceMonitoringActive = false;
                    }
                    this.eventHandler.fireChassisEvent(320, null, utilMessage.getErrorType());
                    break;
                }
                case 34: {
                    if (utilMsgSml.AllResponsesOk()) {
                        this.registeredForNotifications = true;
                    }
                    this.eventHandler.fireChassisEvent(245, null, utilMessage.getErrorType());
                    break;
                }
                case 35: {
                    this.eventHandler.fireChassisEvent(246, null, utilMessage.getErrorType());
                    break;
                }
                case 9: {
                    this.eventHandler.fireChassisEvent(238, null, utilMessage.getErrorType());
                    break;
                }
                case 10: {
                    this.eventHandler.fireChassisEvent(239, null, utilMessage.getErrorType());
                    break;
                }
                case 8: {
                    this.eventHandler.fireChassisEvent(237, null, utilMessage.getErrorType());
                    break;
                }
                case 6: {
                    this.eventHandler.fireChassisEvent(235, null, utilMessage.getErrorType());
                    break;
                }
                case 7: {
                    this.eventHandler.fireChassisEvent(236, null, utilMessage.getErrorType());
                    break;
                }
                case 47: {
                    this.eventHandler.fireChassisEvent(264, null, utilMsgSml.getErrorType());
                    break;
                }
                case 105: {
                    if (utilMsgSml.getErrorType() == null) {
                        SwitchAttribute switchAttribute = this.getAttr(240);
                        this.eventHandler.fireChassisEvent(379, (Object)switchAttribute, true);
                    }
                    this.eventHandler.fireChassisEvent(347, null, utilMsgSml.getErrorType());
                    break;
                }
                case 125: {
                    if (utilMsgSml.AllResponsesOk()) {
                        this.eventHandler.fireChassisEvent(376, (Object)this, true);
                        break;
                    }
                    this.eventHandler.fireChassisEvent(376, null, utilMessage.getErrorType());
                    break;
                }
                case 109: {
                    if (!utilMsgSml.AllResponsesOk()) {
                        this.eventHandler.fireChassisEvent(353, null, utilMsgSml.getErrorType());
                        return;
                    }
                    this.eventHandler.fireChassisEvent(353, null, true);
                    break;
                }
                case 126: {
                    this.eventHandler.fireChassisEvent(252, (Object)Boolean.TRUE, utilMsgSml.getErrorType());
                    break;
                }
                case 0: 
                case 65: 
                case 128: {
                    this.eventHandler.fireChassisEvent(252, (Object)Boolean.FALSE, utilMsgSml.getErrorType());
                    break;
                }
                case 44: {
                    this.eventHandler.fireChassisEvent(259, null, utilMsgSml.getErrorType());
                    break;
                }
                case 104: {
                    this.eventHandler.fireChassisEvent(346, null, utilMsgSml.getErrorType());
                    break;
                }
                case 102: {
                    this.eventHandler.fireChassisEvent(344, null, utilMsgSml.getErrorType());
                    break;
                }
                case 103: {
                    this.eventHandler.fireChassisEvent(345, null, utilMsgSml.getErrorType());
                    break;
                }
                case 127: {
                    this.eventHandler.fireChassisEvent(381, null, utilMsgSml.getErrorType());
                    break;
                }
                case 108: {
                    this.eventHandler.fireChassisEvent(352, null, utilMsgSml.getErrorType());
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        } else if (utilMessage instanceof UtilMsgVersionReq) {
            this.saveVersionRequest((UtilMsgVersionReq)utilMessage);
            bl = true;
        } else if (utilMessage instanceof UtilMsgLoginRequest) {
            Fabric fabric = FabricList.getFabric(this);
            if (fabric != null && fabric.getConnectionSwitch().equals(this)) {
                UtilMsgLoginRequest utilMsgLoginRequest = (UtilMsgLoginRequest)utilMessage;
                User user = this.utilAgent.getLoginInfo();
                int n4 = user.getLevel();
                if (utilMsgLoginRequest.getStatus() == 103) {
                    if (utilMsgLoginRequest.getLoginStatus() == 0) {
                        user.setLoginLevel(utilMsgLoginRequest.getLoginLevel());
                    }
                    if (utilMsgLoginRequest.getLoginStatus() == 6) {
                        user.setLoginLevel(-2);
                    }
                } else {
                    user.setLoginLevel(-2);
                }
                if (user.getLevel() == -2 && this.getChassisStatus() != 7 && this.getChassisStatus() != 5) {
                    this.setChassisStatus(7);
                }
                if (n4 != user.getLevel()) {
                    this.eventHandler.fireChassisEvent(306, null, true);
                }
            }
            bl = true;
        } else if (!bl) {
            System.err.println("unhandled response!!!! msg:  " + utilMessage + ".");
        }
    }

    public User getLoginInfo() {
        return this.utilAgent.getLoginInfo();
    }

    int getPort(UtilMsgSml utilMsgSml, int n) {
        String string = utilMsgSml.getRequest(n).getRequestWord(3);
        return Integer.parseInt(string);
    }

    public int getConfiguredDomainId() {
        return this.configuredDomainId;
    }

    public void setConfiguredDomainId(int n) {
        this.configuredDomainId = n;
    }

    public String getConfiguredDomainIdString() {
        return Integer.toString(this.configuredDomainId);
    }

    public boolean updatePortSpeeds() {
        PortSpeedAttr portSpeedAttr = (PortSpeedAttr)this.getAttr(225);
        return portSpeedAttr.update();
    }

    public boolean updateVersion() {
        return this.utilAgent.getVersion(this, this);
    }

    public boolean applyBeaconToggle(boolean bl) {
        BeaconAttr beaconAttr = (BeaconAttr)this.getAttr(309);
        return beaconAttr.apply(bl);
    }

    public boolean updateBeacon() {
        BeaconAttr beaconAttr = (BeaconAttr)this.getAttr(309);
        return beaconAttr.update();
    }

    public boolean updatePortStates() {
        PortInfoAttr portInfoAttr = (PortInfoAttr)this.getAttr(269);
        return portInfoAttr.update();
    }

    public boolean updateCreditPool() {
        CreditPoolAttr creditPoolAttr = (CreditPoolAttr)this.getAttr(286);
        return creditPoolAttr.update();
    }

    public boolean updateExtCreditInfo() {
        ExtCreditAttr extCreditAttr = (ExtCreditAttr)this.getAttr(288);
        return extCreditAttr.update();
    }

    public boolean applyExtCredit(int n, int n2) {
        ExtCreditAttr extCreditAttr = (ExtCreditAttr)this.getAttr(288);
        return extCreditAttr.apply(n, n2);
    }

    public boolean updateUserAccountList() {
        UserAccountsAttr userAccountsAttr = (UserAccountsAttr)this.getAttr(367);
        return userAccountsAttr.update();
    }

    public void setUserAccountListUpdateInProgress(boolean bl) {
        this.userAccountListUpdateInProgress = bl;
    }

    public boolean getUserAccountListUpdateInProgress() {
        return this.userAccountListUpdateInProgress;
    }

    public boolean applyUserAccountExpiration(int n) {
        UserAccountsAttr userAccountsAttr = (UserAccountsAttr)this.getAttr(367);
        return userAccountsAttr.applyUserAccountExpiration(n);
    }

    public boolean applyAddUserAccount(String string, boolean bl, String string2) {
        UserAccountsAttr userAccountsAttr = (UserAccountsAttr)this.getAttr(367);
        return userAccountsAttr.applyAddUserAccount(string, bl, string2);
    }

    public boolean applyRemoveUserAccount(String string) {
        UserAccountsAttr userAccountsAttr = (UserAccountsAttr)this.getAttr(367);
        return userAccountsAttr.applyRemoveUserAccount(string);
    }

    public boolean applyChangePassword(String string, String string2, String string3) {
        UserAccountsAttr userAccountsAttr = (UserAccountsAttr)this.getAttr(367);
        return userAccountsAttr.applyChangePassword(string, string2, string3);
    }

    public boolean applyDateTime(String string) {
        if (string.length() != 12) {
            return false;
        }
        DateTimeAttr dateTimeAttr = (DateTimeAttr)this.getAttr(350);
        return dateTimeAttr.apply(string);
    }

    public boolean applyPortConfig(int[] nArray, int[] nArray2) {
        PortInfoAttr portInfoAttr = (PortInfoAttr)this.getAttr(269);
        return portInfoAttr.applyPortConfig(nArray, nArray2);
    }

    public boolean applySwitchConfig(int n, int n2, int n3, int n4) {
        SwitchConfigAttr switchConfigAttr = (SwitchConfigAttr)this.getAttr(230);
        return switchConfigAttr.apply(n2, n, n3, n4);
    }

    public boolean applyPortMode(int n, int n2) {
        PortInfoAttr portInfoAttr = (PortInfoAttr)this.getAttr(269);
        return portInfoAttr.applyPortMode(n, n2);
    }

    public boolean applyPortState(int n, int n2) {
        PortInfoAttr portInfoAttr = (PortInfoAttr)this.getAttr(269);
        return portInfoAttr.applyPortState(n, n2);
    }

    public boolean applyTempPortMode(int n, int n2) {
        PortInfoAttr portInfoAttr = (PortInfoAttr)this.getAttr(269);
        return portInfoAttr.applyTempPortMode(n, n2);
    }

    public boolean applyTempPortState(int n, int n2) {
        PortInfoAttr portInfoAttr = (PortInfoAttr)this.getAttr(269);
        return portInfoAttr.applyTempPortState(n, n2);
    }

    public boolean updateFlashVersion() {
        FlashVersionAttr flashVersionAttr = (FlashVersionAttr)this.getAttr(240);
        return flashVersionAttr.update();
    }

    public boolean resetDefaultZoning() {
        this.requestAdmin();
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(52);
        utilMsgSml.addSmlCommand("Cmd.Zoning.ResetConfig");
        utilMsgSml.setSetCommand();
        this.utilAgent.sendSml(utilMsgSml);
        this.releaseAdmin();
        return true;
    }

    public boolean resetToFactoryDefaults() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(35);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.ResetConfig");
        utilMsgSml.addSmlCommand("Cmd.Zoning.ResetConfig");
        utilMsgSml.addSmlCommand("Cmd.System.ResetSetup");
        utilMsgSml.addSmlCommand("Cmd.Snmp.ResetSetup");
        utilMsgSml.setSetCommand();
        this.utilAgent.sendSml(utilMsgSml);
        this.activateConfigAndReleaseAdmin();
        return true;
    }

    public boolean applyFirmwareFallback() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(105);
        utilMsgSml.setSetCommand();
        utilMsgSml.addSmlCommand("Cmd.Switch.Fallback");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyName(String string) {
        ChassisNameAttr chassisNameAttr = (ChassisNameAttr)this.getAttr(253);
        return chassisNameAttr.apply(string);
    }

    public boolean updateName() {
        ChassisNameAttr chassisNameAttr = (ChassisNameAttr)this.getAttr(253);
        return chassisNameAttr.update();
    }

    public boolean updateInbandEnable() {
        InbandEnableAttr inbandEnableAttr = (InbandEnableAttr)this.getAttr(348);
        return inbandEnableAttr.update();
    }

    public boolean updateDateTime() {
        DateTimeAttr dateTimeAttr = (DateTimeAttr)this.getAttr(350);
        return dateTimeAttr.update();
    }

    public boolean applyInbandEnable(int n) {
        InbandEnableAttr inbandEnableAttr = (InbandEnableAttr)this.getAttr(348);
        return inbandEnableAttr.apply(n);
    }

    public boolean updateTempMonitoring() {
        TempMonitoringAttr tempMonitoringAttr = (TempMonitoringAttr)this.getAttr(358);
        return tempMonitoringAttr.update();
    }

    public boolean applyTempMonitoring(int n, int n2, int n3) {
        TempMonitoringAttr tempMonitoringAttr = (TempMonitoringAttr)this.getAttr(358);
        return tempMonitoringAttr.apply(n, n2, n3);
    }

    public boolean applyDomainIdLock(int n) {
        DomainIdLockAttr domainIdLockAttr = (DomainIdLockAttr)this.getAttr(332);
        return domainIdLockAttr.apply(n);
    }

    public boolean updateDomainIdLock() {
        DomainIdLockAttr domainIdLockAttr = (DomainIdLockAttr)this.getAttr(332);
        return domainIdLockAttr.update();
    }

    public boolean updateSwitchConfig() {
        SwitchConfigAttr switchConfigAttr = (SwitchConfigAttr)this.getAttr(230);
        return switchConfigAttr.update();
    }

    public boolean updateSyslogServerInfo() {
        SyslogInfoAttr syslogInfoAttr = (SyslogInfoAttr)this.getAttr(314);
        return syslogInfoAttr.update();
    }

    public boolean updateSysDesc() {
        SysDescAttr sysDescAttr = (SysDescAttr)this.getAttr(337);
        return sysDescAttr.update();
    }

    public boolean applySnmpInfo(SnmpInfo snmpInfo) {
        SnmpInfoAttr snmpInfoAttr = (SnmpInfoAttr)this.getAttr(213);
        return snmpInfoAttr.apply(snmpInfo);
    }

    public boolean reset() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(65);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.Reset.3");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setWaitAfterSend(6000);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean hardReset() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(128);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.PostReset.3");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setWaitAfterSend(6000);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean hotReset() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(126);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.HotStart.3");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setWaitAfterSend(6000);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean shutdownSwitch() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(109);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.Shutdown");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean resetPort(int n) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(44);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".Reset");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setWaitAfterSend(3000);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean updateNameServerInfo() {
        NameServerAttr nameServerAttr = (NameServerAttr)this.getAttr(219);
        return nameServerAttr.update();
    }

    public Vector getAlarmLog() {
        AlarmLogAttr alarmLogAttr = (AlarmLogAttr)this.getAttr(277);
        return alarmLogAttr.getAlarmLog();
    }

    public String getLsdbTs() {
        return this.lsdbTs;
    }

    public void setLsdbTs(String string) {
        this.lsdbTs = string;
    }

    public boolean updateLsdb() {
        LsdbAttr lsdbAttr = (LsdbAttr)this.getAttr(232);
        return lsdbAttr.update();
    }

    public boolean updateChassisStatistics() {
        return true;
    }

    public boolean updatePortStatistics(int n, boolean bl) {
        PortStatisticsAttr portStatisticsAttr = (PortStatisticsAttr)this.getAttr(221);
        return portStatisticsAttr.update(n, bl);
    }

    public boolean updatePortStatistics() {
        PortStatisticsAttr portStatisticsAttr = (PortStatisticsAttr)this.getAttr(221);
        return portStatisticsAttr.update();
    }

    public boolean updateSnmpInfo() {
        SnmpInfoAttr snmpInfoAttr = (SnmpInfoAttr)this.getAttr(213);
        return snmpInfoAttr.update();
    }

    public boolean applyRscn(int n, boolean bl) {
        RscnAttr rscnAttr = (RscnAttr)this.getAttr(297);
        return rscnAttr.apply(n, bl);
    }

    public boolean applyDeviceScan(int n, boolean bl) {
        DeviceScanAttr deviceScanAttr = (DeviceScanAttr)this.getAttr(354);
        return deviceScanAttr.apply(n, bl);
    }

    public boolean updateRscn() {
        RscnAttr rscnAttr = (RscnAttr)this.getAttr(297);
        return rscnAttr.update();
    }

    public boolean updateDeviceScan() {
        DeviceScanAttr deviceScanAttr = (DeviceScanAttr)this.getAttr(354);
        return deviceScanAttr.update();
    }

    public boolean updateLoopbackTestStatus() {
        LoopbackTestAttr loopbackTestAttr = (LoopbackTestAttr)this.getAttr(285);
        return loopbackTestAttr.update();
    }

    public boolean applyBBCredits(int n, int n2) {
        if (n2 < 0 || n2 > 255) {
            return false;
        }
        BBCreditsAttr bBCreditsAttr = (BBCreditsAttr)this.getAttr(257);
        return bBCreditsAttr.apply(n, n2);
    }

    public boolean updateBBCredits() {
        BBCreditsAttr bBCreditsAttr = (BBCreditsAttr)this.getAttr(257);
        return bBCreditsAttr.update();
    }

    public boolean applyPortName(int n, String string) {
        PortNameAttr portNameAttr = (PortNameAttr)this.getAttr(356);
        return portNameAttr.apply(n, string);
    }

    public boolean updatePortNames() {
        PortNameAttr portNameAttr = (PortNameAttr)this.getAttr(356);
        return portNameAttr.update();
    }

    public boolean applyBroadcastSupport(boolean bl) {
        BroadcastSupportAttr broadcastSupportAttr = (BroadcastSupportAttr)this.getAttr(307);
        return broadcastSupportAttr.apply(bl);
    }

    public boolean updateBroadcastSupport() {
        BroadcastSupportAttr broadcastSupportAttr = (BroadcastSupportAttr)this.getAttr(307);
        return broadcastSupportAttr.update();
    }

    public boolean applyPortSpeed(int n, int n2) {
        PortSpeedAttr portSpeedAttr = (PortSpeedAttr)this.getAttr(225);
        return portSpeedAttr.apply(n, n2);
    }

    public boolean editConfig() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(8);
        utilMsgSml.addSmlCommand("Cmd.Switch.EditConfig");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean requestAdmin() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(9);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean releaseAdmin() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(10);
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean saveConfig() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(6);
        utilMsgSml.addSmlCommand("Cmd.Switch.SaveConfig");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applySyslogInfo(boolean bl, InetAddress inetAddress) {
        SyslogInfoAttr syslogInfoAttr = (SyslogInfoAttr)this.getAttr(314);
        return syslogInfoAttr.apply(bl, inetAddress);
    }

    private int decodeCreditResp(String string) {
        if (string.equals("None")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public boolean activateConfig() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(7);
        utilMsgSml.addSmlCommand("Cmd.Switch.ActConfig");
        utilMsgSml.setWaitAfterSend(4000);
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean activateConfigAndReleaseAdmin() {
        return this.activateConfigAndReleaseAdmin(10000, 3000);
    }

    public boolean activateConfigAndReleaseAdmin(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(47);
        utilMsgSml.addSmlCommand("Cmd.Switch.ActConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setWaitAfterSend(n2);
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public void cancelEPortZoningLoad() {
        ZoningConfiguredAttr zoningConfiguredAttr = (ZoningConfiguredAttr)this.getAttr(378);
        zoningConfiguredAttr.cancelEPortZoningLoad();
    }

    public boolean applyEPortZoning(Zones zones) {
        ZoningConfiguredAttr zoningConfiguredAttr = (ZoningConfiguredAttr)this.getAttr(378);
        return zoningConfiguredAttr.applyEPortZoning(zones);
    }

    public boolean applyZoningConfig(ZoningConfig zoningConfig) {
        ZoningParametersAttr zoningParametersAttr = (ZoningParametersAttr)this.getAttr(333);
        return zoningParametersAttr.applyZoningConfig(zoningConfig);
    }

    public boolean applyZoningConfigWithoutGettingAdmin(ZoningConfig zoningConfig) {
        ZoningParametersAttr zoningParametersAttr = (ZoningParametersAttr)this.getAttr(333);
        return zoningParametersAttr.applyZoningConfigWithoutGettingAdmin(zoningConfig);
    }

    public void cancelEPortZoningSave() {
        ZoningConfiguredAttr zoningConfiguredAttr = (ZoningConfiguredAttr)this.getAttr(378);
        zoningConfiguredAttr.setApplyError(new GuiError(100));
        zoningConfiguredAttr.cancelEPortZoningSave();
    }

    public boolean applyActivateZoneSet(ZoneSet zoneSet) {
        ZoningActiveAttr zoningActiveAttr = (ZoningActiveAttr)this.getAttr(377);
        return zoningActiveAttr.applyActivateZoneSet(zoneSet);
    }

    public boolean applyDeactivateZoneSet() {
        ZoningActiveAttr zoningActiveAttr = (ZoningActiveAttr)this.getAttr(377);
        return zoningActiveAttr.applyDeactivateZoneSet();
    }

    public boolean updateSessionTs() {
        SessionTimerAttr sessionTimerAttr = (SessionTimerAttr)this.getAttr(318);
        return sessionTimerAttr.update();
    }

    public boolean applySessionTimer(boolean bl) {
        SessionTimerAttr sessionTimerAttr = (SessionTimerAttr)this.getAttr(318);
        return sessionTimerAttr.apply(new String[]{bl ? "True" : "False"});
    }

    public boolean updateAll() {
        this.eventHandler.fireChassisEvent(291, null, true);
        return true;
    }

    public boolean applyTrapConfig() {
        AlarmThresholdsAttr alarmThresholdsAttr = (AlarmThresholdsAttr)this.getAttr(343);
        return alarmThresholdsAttr.apply();
    }

    public void setEditingTrapConfig(boolean bl) {
        AlarmThresholdsAttr alarmThresholdsAttr = (AlarmThresholdsAttr)this.getAttr(343);
        alarmThresholdsAttr.setEditingTrapConfig(bl);
    }

    public boolean updateTrapInfo() {
        AlarmThresholdsAttr alarmThresholdsAttr = (AlarmThresholdsAttr)this.getAttr(343);
        return alarmThresholdsAttr.update();
    }

    public boolean unpackFwImage(String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(103);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.UnpackImage." + string);
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean cleanupFwImage() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(127);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.CleanupImage");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean closeMgmtSession() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setSetCommand();
        utilMsgSml.setGroupKey(108);
        utilMsgSml.addSmlCommand("Cmd.Switch.CloseSession");
        utilMsgSml.sendEvenIfUnreachable(true);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public UtilAgent getUtilAgent() {
        return (UtilAgent)this.comAgent;
    }

    public SwitchAttribute getAttr(int n) {
        return (SwitchAttribute)this.getUpdater(n);
    }

    protected void createAttrs() {
        this.attributes = new Vector();
        this.attributes.add(new PortSpeedAttr(this));
        this.attributes.add(new PortInfoAttr(this));
        this.attributes.add(new Updater(){

            public boolean update() {
                return Sanbox2Sml.this.updateVersion();
            }

            public int getEvent() {
                return 212;
            }
        });
        this.attributes.add(new SwitchConfigAttr(this));
        this.attributes.add(new SnmpInfoAttr(this));
        this.attributes.add(new FlashVersionAttr(this));
        this.attributes.add(new UserAccountsAttr(this));
        this.attributes.add(new ChassisNameAttr(this));
        this.attributes.add(new InbandEnableAttr(this));
        this.attributes.add(new TempMonitoringAttr(this));
        this.attributes.add(new DateTimeAttr(this));
        this.attributes.add(new DomainIdLockAttr(this));
        this.attributes.add(new BroadcastSupportAttr(this));
        this.attributes.add(new RscnAttr(this));
        this.attributes.add(new DeviceScanAttr(this));
        this.attributes.add(new BBCreditsAttr(this));
        this.attributes.add(new PortNameAttr(this));
        this.attributes.add(new ChassisInfoAttr(this));
        this.attributes.add(new IpInfoAttr(this));
        this.attributes.add(new AlarmLogAttr((Sanbox2)this));
        this.attributes.add(new CreditPoolAttr(this));
        this.attributes.add(new ExtCreditAttr(this));
        this.attributes.add(new ZoningActiveAttr(this.utilAgent, this, this.eventHandler));
        this.attributes.add(new ZoningConfiguredAttr(this.utilAgent, this, this.eventHandler));
        this.attributes.add(new ZoningParametersAttr(this.utilAgent, this, this.eventHandler));
        this.attributes.add(new NameServerAttr((Sanbox2)this));
        this.attributes.add(new PortStatisticsAttr(this));
        this.attributes.add(new BeaconAttr(this));
        this.attributes.add(new SyslogInfoAttr(this));
        this.attributes.add(new SessionTimerAttr(this));
        this.attributes.add(new SysDescAttr(this));
        this.attributes.add(new AlarmThresholdsAttr((Sanbox2)this));
        this.attributes.add(new LsdbAttr(this));
        this.attributes.add(new PerfMonIntervalAttr(this));
        this.attributes.add(new LoopbackTestAttr(this));
        Collections.sort(this.attributes);
    }
}

