/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;

public class ZoningParametersAttr
extends SwitchAttribute
implements UtilEventListener {
    public static final int UPDATE_COMPLETE_EVENT = 333;
    private static final int SML_GET_ZONING_PARAMS = 1;
    private static final int SML_ZONING_CONFIG_SAVE = 2;
    private static final int SML_APPLY_ZONING_CONFIG = 3;
    Sanbox2 sanbox2;
    UtilAgent utilAgent;
    ChassisEventHandler eventHandler;

    public ZoningParametersAttr(UtilAgent utilAgent, Sanbox2 sanbox2, ChassisEventHandler chassisEventHandler) {
        super((Sanbox2Sml)sanbox2, 333);
        this.utilAgent = utilAgent;
        this.sanbox2 = sanbox2;
        this.eventHandler = chassisEventHandler;
    }

    public void saveResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    public void receiveMessage(UtilMessage utilMessage) {
        if (!(utilMessage instanceof UtilMsgSml)) {
            return;
        }
        UtilMsgSml utilMsgSml = (UtilMsgSml)utilMessage;
        if (utilMessage.getStatus() != 103 || !utilMsgSml.AllResponsesOk()) {
            if (utilMessage.getIsSetCommand()) {
                FabricUtilities.logMessage("ZoningParametersAttr.set failed" + utilMessage.getDataTransfered());
            }
            ((Sanbox2Sml)this.sanbox2).updateStatusWithMsgResponse(utilMsgSml);
        }
        switch (utilMsgSml.getGroupKey()) {
            case 2: {
                this.eventHandler.fireChassisEvent(278, null, utilMsgSml.getErrorType());
                break;
            }
            case 3: {
                this.eventHandler.fireChassisEvent(380, null, utilMsgSml.getErrorType());
                break;
            }
            case 1: {
                boolean bl = false;
                if (utilMsgSml.AllResponsesOk()) {
                    ZoningConfig zoningConfig = this.sanbox2.getZoningConfig();
                    zoningConfig.setAutoSave(utilMsgSml.getResponse(0).getResponse().equals(ZoningConfig.getAutoSaveString(true)));
                    String string = utilMsgSml.getResponse(1).getResponse();
                    if (string.equals("SW2")) {
                        zoningConfig.setMergeMode(0);
                    }
                    if (string.equals("Brocade") || string.equals("NonSW2")) {
                        zoningConfig.setMergeMode(1);
                    }
                    if ((string = utilMsgSml.getResponse(2).getResponse()).equals("All")) {
                        zoningConfig.setDefaultVisibility(0);
                    }
                    if (string.equals("None")) {
                        zoningConfig.setDefaultVisibility(1);
                    }
                    if (this.sanbox2.supportsNonSw2Legacy() && utilMsgSml.getNumberOfResponses() >= 4) {
                        zoningConfig.setNonSw2Legacy(utilMsgSml.getResponse(3).getResponse().equals("True"));
                    }
                    bl = true;
                }
                this.eventHandler.fireChassisEvent(333, null, bl);
                break;
            }
        }
    }

    public boolean update() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(1);
        utilMsgSml.addSmlCommand("Config.Zoning.AutoSave");
        utilMsgSml.addSmlCommand("Config.Zoning.MergeMode");
        utilMsgSml.addSmlCommand("Config.Zoning.Default");
        if (this.sanbox2.supportsNonSw2Legacy()) {
            utilMsgSml.addSmlCommand("Config.Switch.NonSW2Legacy");
        }
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyZoningConfigWithoutGettingAdmin(ZoningConfig zoningConfig) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setSetCommand();
        utilMsgSml.setGroupKey(3);
        this.addApplyZoningConfigCommands(zoningConfig, utilMsgSml);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyZoningConfig(ZoningConfig zoningConfig) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setSetCommand();
        utilMsgSml.setGroupKey(2);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.EditConfig");
        this.addApplyZoningConfigCommands(zoningConfig, utilMsgSml);
        utilMsgSml.addSmlCommand("Cmd.Switch.SaveConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.ActConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setTimeoutValue(4000);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private void addApplyZoningConfigCommands(ZoningConfig zoningConfig, UtilMsgSml utilMsgSml) {
        switch (zoningConfig.getDefaultVisibility()) {
            case 0: {
                utilMsgSml.addSmlCommand("Config.Zoning.Default.All");
                break;
            }
            case 1: {
                utilMsgSml.addSmlCommand("Config.Zoning.Default.None");
            }
        }
        if (this.sanbox2.supportsBrocadeMergeMode()) {
            switch (zoningConfig.getMergeMode()) {
                case 1: {
                    utilMsgSml.addSmlCommand("Config.Zoning.MergeMode.Brocade");
                    break;
                }
                case 0: {
                    utilMsgSml.addSmlCommand("Config.Zoning.MergeMode.SW2");
                }
            }
        } else {
            utilMsgSml.addSmlCommand("Config.Zoning.MergeMode.SW2");
        }
        if (zoningConfig.getAutoSave()) {
            utilMsgSml.addSmlCommand("Config.Zoning.AutoSave.True");
        } else {
            utilMsgSml.addSmlCommand("Config.Zoning.AutoSave.False");
        }
        if (this.sanbox2.supportsNonSw2Legacy()) {
            utilMsgSml.addSmlCommand("Config.Switch.NonSW2Legacy." + (zoningConfig.getNonSw2Legacy() ? "True" : "False"));
        }
    }
}

